/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import de.riwagis.geotools.data.geopkg.GeoPackageDataStoreFactory;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.geopkg.Entry;
import org.geotools.geopkg.GeoPackage;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.util.SqlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletableGeoPackage
extends GeoPackage {
    private static final Logger log = LoggerFactory.getLogger(DeletableGeoPackage.class);

    public DeletableGeoPackage(File file) throws IOException {
        super(file);
    }

    public DeletableGeoPackage(JDBCDataStore dataStore) {
        super(dataStore);
    }

    private static void close(Connection cx) {
        if (cx != null) {
            try {
                cx.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error closing connection", e);
            }
        }
    }

    private static void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error closing statement", e);
            }
        }
    }

    public void deleteEntry(Entry entry) throws IOException {
        String tableName = entry.getTableName();
        this.removeRTree(entry, tableName);
        this.dataStore().removeSchema(tableName);
    }

    private void removeRTree(Entry entry, String tableName) throws IOException {
        try {
            this.deleteRowsForTable(entry, "gpkg_extensions");
            this.deleteRowsForTable(entry, "gpkg_data_columns");
            this.deleteTable("rtree_", tableName, "_GEOM");
        }
        catch (IOException e) {
            log.error("Could not delete old spatial tree.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTable(String pre, String table, String post) throws IOException {
        String sql = String.format("DROP TABLE IF EXISTS %s%s%s", pre, table, post);
        try {
            Connection cx = this.connPool.getConnection();
            try {
                PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)sql).log(Level.FINE).statement();
                try {
                    ps.execute();
                }
                finally {
                    DeletableGeoPackage.close(ps);
                }
            }
            finally {
                DeletableGeoPackage.close(cx);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRowsForTable(Entry e, String table) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE table_name = ?", table);
        try {
            Connection cx = this.connPool.getConnection();
            try {
                PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)sql).set(e.getTableName()).log(Level.FINE).statement();
                try {
                    ps.execute();
                }
                finally {
                    DeletableGeoPackage.close(ps);
                }
            }
            finally {
                DeletableGeoPackage.close(cx);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    JDBCDataStore createDataStore() throws IOException {
        Map<String, File> params = Map.of(GeoPackageDataStoreFactory.FILE.key, this.file);
        return (JDBCDataStore)new GeoPackageDataStoreFactory().createDataStore(params);
    }
}

