/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOUtilities {
    private static final Logger LOG = LoggerFactory.getLogger(NIOUtilities.class);

    public static boolean clean(ByteBuffer buffer, boolean memoryMapped) {
        if (memoryMapped) {
            return NIOUtilities.clean(buffer);
        }
        if (org.geotools.util.NIOUtilities.returnToCache((ByteBuffer)buffer)) {
            return true;
        }
        return NIOUtilities.clean(buffer);
    }

    public static boolean clean(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return true;
        }
        Boolean b = AccessController.doPrivileged(() -> {
            Boolean success = Boolean.FALSE;
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object theUnsafe = theUnsafeField.get(null);
                Method invokeCleanerMethod = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                invokeCleanerMethod.invoke(theUnsafe, buffer);
                success = Boolean.TRUE;
            }
            catch (Exception e) {
                LOG.error("Cleaning up file handle failed!", (Throwable)e);
            }
            return success;
        });
        return b;
    }
}

