/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.index.rtree.memory;

import de.riwagis.geotools.index.DataDefinition;
import de.riwagis.geotools.index.LockManager;
import de.riwagis.geotools.index.TreeException;
import de.riwagis.geotools.index.rtree.Entry;
import de.riwagis.geotools.index.rtree.Node;
import de.riwagis.geotools.index.rtree.PageStore;
import de.riwagis.geotools.index.rtree.memory.MemoryNode;

public class MemoryPageStore
extends PageStore {
    private static final int DEF_MAX = 50;
    private static final int DEF_MIN = 25;
    private static final short DEF_SPLIT = 1;
    private LockManager lockManager = new LockManager();
    private Node root = null;

    public MemoryPageStore(DataDefinition def) throws TreeException {
        this(def, 50, 25, 1);
    }

    public MemoryPageStore(DataDefinition def, int max, int min, short split) throws TreeException {
        super(def, max, min, split);
        this.root = new MemoryNode(max);
        this.root.setLeaf(true);
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Node node) throws TreeException {
        this.root = node;
        this.root.setParent(null);
    }

    @Override
    public Node getEmptyNode(boolean isLeaf) {
        MemoryNode ret = new MemoryNode(this.maxNodeEntries);
        ret.setLeaf(isLeaf);
        return ret;
    }

    @Override
    public Node getNode(Entry parentEntry, Node parent) throws TreeException {
        Node ret = (Node)parentEntry.getData();
        ret.setParent(parent);
        return ret;
    }

    @Override
    public Entry createEntryPointingNode(Node node) {
        return new Entry<Node>(node.getBounds(), node);
    }

    @Override
    public void free(Node node) {
    }

    @Override
    public void close() throws TreeException {
        this.root = null;
    }
}

