/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.index.rtree.database;

import de.riwagis.geotools.index.DataDefinition;
import de.riwagis.geotools.index.Lock;
import de.riwagis.geotools.index.LockTimeoutException;
import de.riwagis.geotools.index.TreeException;
import de.riwagis.geotools.index.rtree.Entry;
import de.riwagis.geotools.index.rtree.Node;
import de.riwagis.geotools.index.rtree.PageStore;
import de.riwagis.geotools.index.rtree.database.DatabaseNode;
import de.riwagis.geotools.index.rtree.database.Dialect;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class DatabasePageStore
extends PageStore {
    protected static final int DEF_MAX = 50;
    protected static final int DEF_MIN = 25;
    protected static final short DEF_SPLIT = 1;
    private DataSource dataSource;
    private Dialect dialect;
    private String rtreeName;
    private DatabaseNode root;

    public DatabasePageStore(DataSource ds, Dialect dialect, String rtreeName) throws TreeException {
        this.dataSource = ds;
        this.dialect = dialect;
        this.rtreeName = rtreeName;
        this.createNew();
    }

    public DatabasePageStore(DataSource ds, Dialect dialect, String rtreeName, DataDefinition def) throws TreeException {
        this(ds, dialect, rtreeName, def, 50, 25, 1);
    }

    public DatabasePageStore(DataSource ds, Dialect dialect, String rtreeName, DataDefinition def, int maxNodeEntries, int minNodeEntries, short splitAlg) throws TreeException {
        super(def, maxNodeEntries, minNodeEntries, splitAlg);
        this.dataSource = ds;
        this.dialect = dialect;
        this.rtreeName = rtreeName;
        this.init();
    }

    private void createNew() throws TreeException {
        Connection cnn = null;
        Statement pst = null;
        ResultSet rs = null;
        try {
            cnn = this.dataSource.getConnection();
            pst = cnn.prepareStatement(this.dialect.getCatalogQuery());
            pst.setString(1, this.rtreeName);
            rs = pst.executeQuery();
            if (rs.next()) {
                throw new TreeException(this.rtreeName + " already exists!");
            }
            rs.close();
            pst.close();
            int i = 1;
            pst = cnn.prepareStatement(this.dialect.getCatalogInsert());
            pst.setString(i++, this.rtreeName);
            pst.setInt(i++, this.minNodeEntries);
            pst.setInt(i++, this.maxNodeEntries);
            pst.setShort(i++, this.splitAlg);
            pst.executeUpdate();
            cnn.commit();
            pst.close();
            pst = cnn.prepareStatement(this.dialect.getCreateTable(this.rtreeName));
            pst.execute();
            this.root = new DatabaseNode(this.maxNodeEntries, this.dataSource, this.dialect, this.rtreeName);
            this.root.setLeaf(true);
            this.root.save();
        }
        catch (SQLException e) {
            try {
                cnn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new TreeException(e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                pst.close();
            }
            catch (Exception exception) {}
            try {
                cnn.close();
            }
            catch (Exception exception) {}
        }
    }

    private void init() {
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Node node) throws TreeException {
        DatabaseNode n = (DatabaseNode)node;
        n.setParent(null);
        this.root = n;
    }

    @Override
    public Node getEmptyNode(boolean isLeaf) {
        return null;
    }

    @Override
    public Node getNode(Entry parentEntry, Node parent) throws TreeException {
        return null;
    }

    @Override
    public Entry createEntryPointingNode(Node node) {
        return null;
    }

    @Override
    public int getMaxNodeEntries() {
        return 0;
    }

    @Override
    public int getMinNodeEntries() {
        return 0;
    }

    @Override
    public short getSplitAlgorithm() {
        return 0;
    }

    @Override
    public DataDefinition getDataDefinition() {
        return null;
    }

    @Override
    public void free(Node node) {
    }

    @Override
    public Lock getWriteLock() throws LockTimeoutException {
        return null;
    }

    @Override
    public Lock getReadLock() throws LockTimeoutException {
        return null;
    }

    @Override
    public void releaseLock(Lock lock) {
    }

    @Override
    public void close() throws TreeException {
    }
}

