/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.index.rtree.database;

import de.riwagis.geotools.index.TreeException;
import de.riwagis.geotools.index.rtree.Entry;
import de.riwagis.geotools.index.rtree.Node;
import de.riwagis.geotools.index.rtree.database.Dialect;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class DatabaseNode
extends Node {
    private DataSource dataSource;
    private Dialect dialect;
    private String tableName;
    private Integer parentId;
    private Integer pageId;

    public DatabaseNode(int maxNodeEntries, DataSource ds, Dialect dialect, String tableName) {
        super(maxNodeEntries);
        this.dataSource = ds;
        this.dialect = dialect;
        this.tableName = tableName;
    }

    public DatabaseNode(int maxNodeEntries, DataSource ds, Dialect dialect, String tableName, Integer pageId) throws TreeException {
        this(maxNodeEntries, ds, dialect, tableName);
    }

    @Override
    protected void doSave() throws TreeException {
        byte[] bytes = null;
        Connection cnn = null;
        try {
            cnn = this.dataSource.getConnection();
            if (this.pageId == null) {
                this.doInsert(cnn, bytes);
            } else {
                this.doUpdate(cnn, bytes);
            }
        }
        catch (SQLException e) {
            throw new TreeException(e);
        }
        catch (IOException e) {
            throw new TreeException(e);
        }
        finally {
            try {
                cnn.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInsert(Connection cnn, byte[] bytes) throws SQLException, IOException {
        Statement pst = null;
        try {
            int i = 1;
            int id = this.dialect.getNextPageId(cnn, this.tableName);
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            pst = cnn.prepareStatement(this.dialect.getInsertPage(this.tableName));
            pst.setInt(i++, id);
            pst.setString(i++, this.isLeaf() ? "Y" : "N");
            pst.setBinaryStream(i++, is, bytes.length);
            pst.executeUpdate();
            cnn.commit();
            is.close();
            this.pageId = id;
        }
        catch (SQLException e) {
            try {
                cnn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                pst.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpdate(Connection cnn, byte[] bytes) throws SQLException, IOException {
        Statement pst = null;
        try {
            int i = 1;
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            pst = cnn.prepareStatement(this.dialect.getUpdatePage(this.tableName));
            pst.setString(i++, this.isLeaf() ? "Y" : "N");
            pst.setBinaryStream(i++, is, bytes.length);
            pst.setInt(i++, this.pageId);
            pst.executeUpdate();
            cnn.commit();
            is.close();
        }
        catch (SQLException e) {
            try {
                cnn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                pst.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected Entry getEntry(Node node) {
        DatabaseNode dn = (DatabaseNode)node;
        Entry ret = null;
        Integer id = null;
        for (int i = 0; i < this.getEntriesCount(); ++i) {
            id = (Integer)this.entries[i].getData();
            if (!id.equals(dn.getPageId())) continue;
            ret = this.entries[i];
            break;
        }
        return ret;
    }

    @Override
    public Node getParent() throws TreeException {
        if (this.parentId == null) {
            return null;
        }
        return new DatabaseNode(this.maxNodeEntries, this.dataSource, this.dialect, this.tableName, this.parentId);
    }

    @Override
    public void setParent(Node node) {
        this.parentId = ((DatabaseNode)node).getPageId();
    }

    public Integer getPageId() {
        return this.pageId;
    }

    public void setPageId(Integer pageId) {
        this.pageId = pageId;
    }
}

