/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.index.rtree.database;

import de.riwagis.geotools.index.rtree.database.Dialect;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractDialect
implements Dialect {
    protected static final String CAT_TABLE = "rtrees_cat";
    private static final String QUERY_CAT = "select * from rtrees_cat where rtree_name=?";
    private static final String INSERT_CAT = "insert into rtrees_cat (rtree_name, min_entries, max_entries, split_alg) values (?, ?, ?, ?)";
    private int current = -1;

    @Override
    public String getCatalogQuery() {
        return QUERY_CAT;
    }

    @Override
    public String getCatalogInsert() {
        return INSERT_CAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getNextPageId(Connection cnn, String tableName) throws SQLException {
        if (this.current == -1) {
            PreparedStatement pst = null;
            ResultSet rs = null;
            try {
                pst = cnn.prepareStatement("select max(page_id) from " + tableName);
                rs = pst.executeQuery();
                rs.next();
                this.current = rs.getInt(1);
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
                try {
                    pst.close();
                }
                catch (Exception exception) {}
            }
        }
        return ++this.current;
    }

    @Override
    public String getSelectPage(String tableName) {
        return "select * from " + tableName + " where page_id=?";
    }

    @Override
    public String getInsertPage(String tableName) {
        return "insert into " + tableName + " (page_id, fl_leaf, blob_content) values (?,?,?)";
    }

    @Override
    public String getUpdatePage(String tableName) {
        return "update " + tableName + " set fl_leaf=?, blob_content=? where page_id=?";
    }
}

