/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.index.rtree.cachefs;

import de.riwagis.geotools.index.DataDefinition;
import de.riwagis.geotools.index.TreeException;
import de.riwagis.geotools.index.rtree.cachefs.FileSystemNode;
import de.riwagis.geotools.index.rtree.cachefs.NodeCache;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Stack;

public class Parameters {
    private int maxNodeEntries;
    private int minNodeEntries;
    private short splitAlg;
    private DataDefinition dataDef;
    private FileChannel channel;
    private Stack freePages = new Stack();
    private boolean forceChannel;
    private NodeCache cache = new NodeCache();
    private long newNodeOffset;

    public FileChannel getChannel() {
        return this.channel;
    }

    public DataDefinition getDataDef() {
        return this.dataDef;
    }

    public int getMaxNodeEntries() {
        return this.maxNodeEntries;
    }

    public int getMinNodeEntries() {
        return this.minNodeEntries;
    }

    public short getSplitAlg() {
        return this.splitAlg;
    }

    public void setChannel(FileChannel channel) {
        this.channel = channel;
    }

    public void setDataDef(DataDefinition definition) {
        this.dataDef = definition;
    }

    public void setMaxNodeEntries(int i) {
        this.maxNodeEntries = i;
    }

    public void setMinNodeEntries(int i) {
        this.minNodeEntries = i;
    }

    public void setSplitAlg(short s) {
        this.splitAlg = s;
    }

    public boolean getForceChannel() {
        return this.forceChannel;
    }

    public void setForceChannel(boolean b) {
        this.forceChannel = b;
    }

    public Stack getFreePages() {
        return this.freePages;
    }

    public void setFreePages(Stack stack) {
        this.freePages = stack;
    }

    public synchronized void setNodeCacheSize(int size) throws TreeException {
        if (this.cache != null) {
            this.flushCache();
        }
        this.cache = size == 0 ? null : (size < 0 ? new NodeCache() : new NodeCache(size));
    }

    public synchronized FileSystemNode getFromCache(long offset) throws IOException, TreeException {
        FileSystemNode node = null;
        if (this.cache != null) {
            node = (FileSystemNode)this.cache.get(offset);
        }
        if (node == null) {
            node = new FileSystemNode(this, offset);
            this.putToCache(node);
        }
        return node;
    }

    public synchronized long getNewNodeOffset(int len) throws IOException {
        long offset = 0L;
        offset = this.newNodeOffset == 0L ? this.channel.size() : this.newNodeOffset;
        this.newNodeOffset = offset + (long)len;
        return offset;
    }

    public synchronized void putToCache(FileSystemNode node) throws TreeException {
        if (this.cache != null) {
            this.cache.put(node.getOffset(), node);
        } else {
            node.flush();
        }
    }

    public synchronized void removeFromCache(FileSystemNode node) {
        if (this.cache != null) {
            this.cache.remove(node);
        }
    }

    public synchronized void flushCache() throws TreeException {
        if (this.cache == null) {
            return;
        }
        Iterator iter = this.cache.keySet().iterator();
        while (iter.hasNext()) {
            FileSystemNode element = (FileSystemNode)this.cache.get(iter.next());
            element.flush();
        }
        this.cache.clear();
    }
}

