/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.index.rtree;

import de.riwagis.geotools.index.DataDefinition;
import de.riwagis.geotools.index.Lock;
import de.riwagis.geotools.index.LockManager;
import de.riwagis.geotools.index.LockTimeoutException;
import de.riwagis.geotools.index.TreeException;
import de.riwagis.geotools.index.rtree.Entry;
import de.riwagis.geotools.index.rtree.Node;

public abstract class PageStore {
    public static final short SPLIT_QUADRATIC = 1;
    public static final short SPLIT_LINEAR = 2;
    protected DataDefinition def;
    protected int maxNodeEntries;
    protected int minNodeEntries;
    protected short splitAlg;
    private LockManager lockManager = new LockManager();

    public PageStore() {
    }

    public PageStore(DataDefinition def, int maxNodeEntries, int minNodeEntries, short splitAlg) throws TreeException {
        this();
        if (minNodeEntries > maxNodeEntries / 2) {
            throw new TreeException("minNodeEntries shoud be <= maxNodeEntries / 2");
        }
        if (splitAlg != 2 && splitAlg != 1) {
            throw new TreeException("Split algorithm shoud be SPLIT_LINEAR or SPLIT_QUADRATIC");
        }
        if (!def.isValid()) {
            throw new TreeException("Invalid DataDefinition");
        }
        if (splitAlg != 1) {
            throw new UnsupportedOperationException("Only SPLIT_QUARDATIC is allowed by now...");
        }
        this.def = def;
        this.maxNodeEntries = maxNodeEntries;
        this.minNodeEntries = minNodeEntries;
        this.splitAlg = splitAlg;
    }

    public abstract Node getRoot();

    public abstract void setRoot(Node var1) throws TreeException;

    public abstract Node getEmptyNode(boolean var1);

    public abstract Node getNode(Entry var1, Node var2) throws TreeException;

    public abstract Entry createEntryPointingNode(Node var1);

    public int getMaxNodeEntries() {
        return this.maxNodeEntries;
    }

    public int getMinNodeEntries() {
        return this.minNodeEntries;
    }

    public short getSplitAlgorithm() {
        return this.splitAlg;
    }

    public DataDefinition getDataDefinition() {
        return this.def;
    }

    public abstract void free(Node var1);

    public Lock getWriteLock() throws LockTimeoutException {
        return this.lockManager.aquireExclusive();
    }

    public Lock getReadLock() throws LockTimeoutException {
        return this.lockManager.aquireShared();
    }

    public void releaseLock(Lock lock) {
        this.lockManager.release(lock);
    }

    public abstract void close() throws TreeException;
}

