/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.index.rtree;

import de.riwagis.geotools.index.TreeException;
import de.riwagis.geotools.index.rtree.Entry;
import de.riwagis.geotools.index.rtree.EntryBoundsChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.locationtech.jts.geom.Envelope;

public abstract class Node
implements EntryBoundsChangeListener {
    private boolean leaf;
    protected int entriesCount = 0;
    protected int maxNodeEntries;
    protected Envelope bounds;
    protected Entry[] entries;
    protected boolean isChanged;

    public Node(int maxNodeEntries) {
        this.maxNodeEntries = maxNodeEntries;
        this.entries = new Entry[maxNodeEntries + 1];
        this.bounds = null;
    }

    public final void addEntry(Entry entry) {
        this.entries[this.entriesCount++] = entry;
        entry.setListener(this);
        if (this.bounds == null) {
            this.bounds = new Envelope(entry.getBounds());
        } else {
            this.bounds.expandToInclude(entry.getBounds());
        }
        this.isChanged = true;
    }

    public final void removeEntry(Entry entry) {
        Entry[] newEntries = new Entry[this.entries.length];
        Envelope newBounds = null;
        int newSize = 0;
        for (int i = 0; i < this.entriesCount; ++i) {
            if (this.entries[i].equals(entry)) continue;
            newEntries[newSize++] = this.entries[i];
            if (newBounds == null) {
                newBounds = new Envelope(this.entries[i].getBounds());
                continue;
            }
            newBounds.expandToInclude(this.entries[i].getBounds());
        }
        this.entries = newEntries;
        this.entriesCount = newSize;
        this.bounds = newBounds;
        this.isChanged = true;
    }

    public void clear() {
        Arrays.fill(this.entries, null);
        this.entriesCount = 0;
        this.bounds = null;
        this.isChanged = true;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean b) {
        this.leaf = b;
    }

    public int getEntriesCount() {
        return this.entriesCount;
    }

    public Entry getEntry(int n) {
        return this.entries[n];
    }

    public Collection getEntries() {
        ArrayList<Entry> ret = new ArrayList<Entry>(this.entriesCount);
        for (int i = 0; i < this.entriesCount; ++i) {
            ret.add((Entry)this.entries[i].clone());
        }
        return ret;
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    @Override
    public void boundsChanged(Entry e) {
        this.bounds = new Envelope(this.entries[0].getBounds());
        for (int i = 1; i < this.entriesCount; ++i) {
            this.bounds.expandToInclude(this.entries[i].getBounds());
        }
    }

    public final void save() throws TreeException {
        this.doSave();
        this.isChanged = false;
    }

    public abstract Node getParent() throws TreeException;

    public abstract void setParent(Node var1);

    protected abstract Entry getEntry(Node var1);

    protected abstract void doSave() throws TreeException;
}

