/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.index.quadtree.fs;

import de.riwagis.geotools.data.shapefile.shp.IndexFile;
import de.riwagis.geotools.index.quadtree.IndexStore;
import de.riwagis.geotools.index.quadtree.Node;
import de.riwagis.geotools.index.quadtree.QuadTree;
import de.riwagis.geotools.index.quadtree.StoreException;
import de.riwagis.geotools.index.quadtree.fs.FileSystemNode;
import de.riwagis.geotools.index.quadtree.fs.IndexHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemIndexStore
implements IndexStore {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemIndexStore.class);
    private final File file;
    private final byte byteOrder;

    public FileSystemIndexStore(File file) {
        this(file, 2);
    }

    public FileSystemIndexStore(File file, byte byteOrder) {
        this.file = file;
        this.byteOrder = byteOrder;
    }

    @Override
    public void store(QuadTree tree) throws StoreException {
        tree.trim();
        FileOutputStream fos = null;
        AbstractInterruptibleChannel channel = null;
        try {
            fos = new FileOutputStream(this.file);
            channel = fos.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(8);
            if (this.byteOrder > 0) {
                LOG.trace("Writing file header");
                IndexHeader header = new IndexHeader(this.byteOrder);
                header.writeTo(buf);
                buf.flip();
                ((FileChannel)channel).write(buf);
            }
            ByteOrder order = FileSystemIndexStore.byteToOrder(this.byteOrder);
            buf.clear();
            buf.order(order);
            buf.putInt(tree.getNumShapes());
            buf.putInt(tree.getMaxDepth());
            buf.flip();
            ((FileChannel)channel).write(buf);
            this.writeNode(tree.getRoot(), (FileChannel)channel, order);
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
        finally {
            try {
                channel.close();
            }
            catch (Exception exception) {}
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    private void writeNode(Node node, FileChannel channel, ByteOrder order) throws IOException, StoreException {
        int i;
        int offset = this.getSubNodeOffset(node);
        ByteBuffer buf = ByteBuffer.allocate(44 + node.getNumShapeIds() * 4);
        buf.order(order);
        buf.putInt(offset);
        Envelope env = node.getBounds();
        buf.putDouble(env.getMinX());
        buf.putDouble(env.getMinY());
        buf.putDouble(env.getMaxX());
        buf.putDouble(env.getMaxY());
        buf.putInt(node.getNumShapeIds());
        for (i = 0; i < node.getNumShapeIds(); ++i) {
            buf.putInt(node.getShapeId(i));
        }
        buf.putInt(node.getNumSubNodes());
        buf.flip();
        channel.write(buf);
        for (i = 0; i < node.getNumSubNodes(); ++i) {
            this.writeNode(node.getSubNode(i), channel, order);
        }
    }

    private int getSubNodeOffset(Node node) throws StoreException {
        int offset = 0;
        Node tmp = null;
        for (int i = 0; i < node.getNumSubNodes(); ++i) {
            tmp = node.getSubNode(i);
            offset += 32;
            offset += (tmp.getNumShapeIds() + 3) * 4;
            offset += this.getSubNodeOffset(tmp);
        }
        return offset;
    }

    @Override
    public QuadTree load(IndexFile indexfile) throws StoreException {
        QuadTree tree;
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Opening QuadTree '%s'", this.file.getCanonicalPath()));
            }
            final FileInputStream fis = new FileInputStream(this.file);
            final FileChannel channel = fis.getChannel();
            IndexHeader header = new IndexHeader(channel);
            ByteOrder order = FileSystemIndexStore.byteToOrder(header.getByteOrder());
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.order(order);
            channel.read(buf);
            buf.flip();
            tree = new QuadTree(buf.getInt(), buf.getInt(), indexfile){

                @Override
                public void insert(int recno, Envelope bounds) {
                    throw new UnsupportedOperationException("File quadtrees are immutable");
                }

                @Override
                public boolean trim() {
                    return false;
                }

                @Override
                public void close() throws StoreException {
                    super.close();
                    try {
                        channel.close();
                        fis.close();
                    }
                    catch (IOException e) {
                        throw new StoreException(e);
                    }
                }
            };
            tree.setRoot(FileSystemNode.readNode(0, null, channel, order));
            LOG.trace("QuadTree opened");
        }
        catch (IOException e) {
            throw new StoreException(String.format("Error loading indexfile: '%s'", this.file), e);
        }
        return tree;
    }

    private static ByteOrder byteToOrder(byte order) {
        return switch (order) {
            case 0 -> ByteOrder.nativeOrder();
            case -1, 1 -> ByteOrder.LITTLE_ENDIAN;
            case -2, 2 -> ByteOrder.BIG_ENDIAN;
            default -> null;
        };
    }

    public int getByteOrder() {
        return this.byteOrder;
    }
}

