/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.index.quadtree;

import de.riwagis.geotools.data.shapefile.shp.IndexFile;
import de.riwagis.geotools.index.Data;
import de.riwagis.geotools.index.DataDefinition;
import de.riwagis.geotools.index.quadtree.Node;
import de.riwagis.geotools.index.quadtree.StoreException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.locationtech.jts.geom.Envelope;

public class LazySearchIterator
implements Iterator<Data> {
    static final DataDefinition DATA_DEFINITION = new DataDefinition("US-ASCII");
    private static final int MAX_INDICES = 32768;
    Data next = null;
    Node current;
    int idIndex = 0;
    private boolean closed;
    private final Envelope bounds;
    Iterator data;
    private final IndexFile indexfile;

    public LazySearchIterator(Node root, IndexFile indexfile, Envelope bounds) {
        this.current = root;
        this.bounds = bounds;
        this.closed = false;
        this.next = null;
        this.indexfile = indexfile;
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Iterator has been closed!");
        }
        if (this.next != null) {
            return true;
        }
        if (this.data != null && this.data.hasNext()) {
            this.next = (Data)this.data.next();
        } else {
            this.fillCache();
            if (this.data != null && this.data.hasNext()) {
                this.next = (Data)this.data.next();
            }
        }
        return this.next != null;
    }

    private void fillCache() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<Data> dataList = new ArrayList<Data>();
        try {
            while (indices.size() < 32768 && this.current != null) {
                if (this.idIndex < this.current.getNumShapeIds() && !this.current.isVisited() && this.current.getBounds().intersects(this.bounds)) {
                    indices.add(this.current.getShapeId(this.idIndex));
                    ++this.idIndex;
                    continue;
                }
                this.current.setShapesId(new int[0]);
                this.idIndex = 0;
                boolean foundUnvisited = false;
                for (int i = 0; i < this.current.getNumSubNodes(); ++i) {
                    Node node = this.current.getSubNode(i);
                    if (node.isVisited() || !node.getBounds().intersects(this.bounds)) continue;
                    foundUnvisited = true;
                    this.current = node;
                    break;
                }
                if (foundUnvisited) continue;
                this.current.setVisited(true);
                this.current = this.current.getParent();
            }
            Collections.sort(indices);
            for (Integer recno : indices) {
                Data addData = new Data(DATA_DEFINITION);
                addData.addValue(recno + 1);
                addData.addValue(this.indexfile.getOffsetInBytes(recno));
                dataList.add(addData);
            }
        }
        catch (StoreException | IOException e) {
            throw new RuntimeException(e);
        }
        this.data = dataList.iterator();
    }

    @Override
    public Data next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        Data temp = this.next;
        this.next = null;
        return temp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws StoreException {
        this.closed = true;
    }

    static {
        DATA_DEFINITION.addField(Integer.class);
        DATA_DEFINITION.addField(Long.class);
    }
}

