/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.index.quadtree;

import de.riwagis.geotools.data.shapefile.ShapefileDataStoreFactory;
import de.riwagis.geotools.index.CloseableCollection;
import de.riwagis.geotools.index.Data;
import de.riwagis.geotools.index.quadtree.LazySearchIterator;
import de.riwagis.geotools.index.quadtree.QuadTree;
import de.riwagis.geotools.index.quadtree.StoreException;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.logging.Level;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public class LazySearchCollection
extends AbstractCollection<Data>
implements CloseableCollection<Data> {
    private final QuadTree tree;
    private final Envelope bounds;

    public LazySearchCollection(QuadTree tree, Envelope bounds) {
        this.tree = tree;
        this.bounds = bounds;
    }

    @Override
    public Iterator<Data> iterator() {
        LazySearchIterator object;
        try {
            object = new LazySearchIterator(this.tree.getRoot().copy(), this.tree.getIndexfile(), this.bounds);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tree.registerIterator(object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Iterator<Data> iter = this.iterator();
        try {
            int count = 0;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            try {
                this.tree.close(iter);
            }
            catch (StoreException e) {
                Logging.getLogger((String)"org.geotools.index.quadtree").severe("Couldn't close iterator");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Iterator<Data> iter = this.iterator();
        boolean isEmtpy = true;
        try {
            isEmtpy = !iter.hasNext();
        }
        finally {
            try {
                this.tree.close(iter);
            }
            catch (StoreException e) {
                Logging.getLogger((String)"org.geotools.index.quadtree").severe("Couldn't close iterator");
            }
        }
        return isEmtpy;
    }

    @Override
    public void close() {
        try {
            this.tree.close();
        }
        catch (StoreException e) {
            ShapefileDataStoreFactory.LOGGER.log(Level.SEVERE, "Error closing QuadTree", e);
        }
    }

    @Override
    public void closeIterator(Iterator<Data> iter) throws IOException {
        try {
            this.tree.close(iter);
        }
        catch (StoreException e) {
            throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
        }
    }
}

