/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.wfs;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.opengis.wfs20.GetFeatureType;
import net.opengis.wfs20.QueryType;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.v2_0.StrictWFS_2_0_Strategy;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.util.factory.FactoryRegistryException;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.PropertyName;

public class StrictPrefixEnforcingWFS_2_0_Strategy
extends StrictWFS_2_0_Strategy {
    protected EObject createGetFeatureRequestPost(GetFeatureRequest query) throws IOException {
        GetFeatureType getFeatureType = (GetFeatureType)super.createGetFeatureRequestPost(query);
        String prefix = query.getTypeName().getPrefix();
        if (StringUtils.isBlank((String)prefix)) {
            return getFeatureType;
        }
        QueryType wfsQuery = (QueryType)getFeatureType.getAbstractQueryExpression().get(0);
        this.enforceTypePrefixForFilterProperties(wfsQuery, prefix);
        this.enforceTypePrefixForProperties(wfsQuery, prefix);
        return getFeatureType;
    }

    private void enforceTypePrefixForFilterProperties(QueryType wfsQuery, String prefix) throws FactoryRegistryException {
        Filter filter = wfsQuery.getFilter();
        if (filter == Filter.INCLUDE || filter == null) {
            return;
        }
        Filter newFilter = (Filter)filter.accept((FilterVisitor)new PrefixEnforcingFilterVisitor(prefix), (Object)CommonFactoryFinder.getFilterFactory2());
        wfsQuery.setFilter(newFilter);
    }

    private void enforceTypePrefixForProperties(QueryType wfsQuery, String prefix) {
        EList propertyNames = wfsQuery.getPropertyNames();
        List prefixedPropertyNames = propertyNames.stream().map(name -> new QName(name.getNamespaceURI(), name.getLocalPart(), prefix)).collect(Collectors.toList());
        propertyNames.clear();
        propertyNames.addAll(prefixedPropertyNames);
    }

    private static class PrefixEnforcingFilterVisitor
    extends DuplicatingFilterVisitor {
        private final String prefixWithSeparator;

        public PrefixEnforcingFilterVisitor(String prefix) {
            this.prefixWithSeparator = prefix + ":";
        }

        public Object visit(PropertyName expression, Object data) {
            if (expression.getPropertyName() != null && !expression.getPropertyName().startsWith(this.prefixWithSeparator)) {
                return this.getFactory(data).property(this.prefixWithSeparator + expression.getPropertyName(), expression.getNamespaceContext());
            }
            return super.visit(expression, data);
        }
    }
}

