/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.wfs;

import de.riwagis.geotools.data.wfs.LenientGetFeatureResponseParserFactory;
import de.riwagis.geotools.data.wfs.StrictPrefixEnforcingWFS_2_0_Strategy;
import java.awt.RenderingHints;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.impl.WFSDataAccessFactory;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.data.wfs.internal.WFSExtensions;
import org.geotools.data.wfs.internal.WFSGetCapabilities;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.parsers.GetFeatureResponseParserFactory;
import org.geotools.data.wfs.internal.v2_0.StrictWFS_2_0_Strategy;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.http.HTTPClient;
import org.geotools.ows.ServiceException;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.opengis.feature.type.FeatureTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiwaWFSDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger log = LoggerFactory.getLogger(RiwaWFSDataStoreFactory.class);
    public static final DataAccessFactory.Param URL = new DataAccessFactory.Param("get_capabilities_url", URL.class, "WFS GetCapabilities URL", true, null);
    public static final DataAccessFactory.Param USERNAME = new DataAccessFactory.Param("username", String.class, "Username", false, null);
    public static final DataAccessFactory.Param PASSWORD = new DataAccessFactory.Param("password", String.class, "Password", false, null);
    public static final DataAccessFactory.Param AXIS_ORDER = new DataAccessFactory.Param("axis_order", String.class, "Axis Order (compliant,east_north, north_east)", false, null);
    private final DataStoreFactorySpi delegate;

    public RiwaWFSDataStoreFactory() {
        this.fixDefectGeoToolsGetParser();
        this.delegate = new WFSDataStoreFactory(){

            public WFSDataStore createDataStore(Map<String, ?> params) throws IOException {
                WFSClientWithExtendedWFS2_0 wfsClient;
                WFSConfig config = WFSConfig.fromParams(params);
                if (config.getUser() == null && config.getPassword() != null || config.getPassword() == null && config.getUser() != null) {
                    throw new IOException("Cannot define only one of USERNAME or PASSWORD, must define both or neither");
                }
                URL capabilitiesURL = (URL)URL.lookUp(params);
                HTTPClient http = this.getHttpClient(params);
                http.setTryGzip(config.isTryGZIP());
                http.setUser(config.getUser());
                http.setPassword(config.getPassword());
                http.setConnectTimeout(config.getTimeoutMillis() / 1000);
                http.setReadTimeout(config.getTimeoutMillis() / 1000);
                try {
                    wfsClient = new WFSClientWithExtendedWFS2_0(capabilitiesURL, http, config);
                }
                catch (ServiceException e) {
                    throw new IOException(e);
                }
                WFSDataStore dataStore = new WFSDataStore((WFSClient)wfsClient);
                dataStore.setFilterFactory(CommonFactoryFinder.getFilterFactory(null));
                dataStore.setGeometryFactory(new GeometryFactory((CoordinateSequenceFactory)PackedCoordinateSequenceFactory.DOUBLE_FACTORY));
                dataStore.setFeatureTypeFactory((FeatureTypeFactory)new FeatureTypeFactoryImpl());
                dataStore.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
                dataStore.setDataStoreFactory((DataStoreFactorySpi)this);
                dataStore.setNamespaceURI(config.getNamespaceOverride());
                return dataStore;
            }
        };
    }

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        return this.delegate.createDataStore(this.mapParameters(params));
    }

    public String getDisplayName() {
        return "Web Feature Service (WFS)";
    }

    public String getDescription() {
        return "RIWA Web Feature Service (WFS) Data Store";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URL, USERNAME, PASSWORD, AXIS_ORDER};
    }

    public boolean canProcess(Map<String, ?> params) {
        return params.containsKey(RiwaWFSDataStoreFactory.URL.key) && this.delegate.canProcess(this.mapParameters(params));
    }

    public boolean isAvailable() {
        return this.delegate.isAvailable();
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        return this.delegate.createNewDataStore(this.mapParameters(params));
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return this.delegate.getImplementationHints();
    }

    private Map<String, ?> mapParameters(Map<String, ?> params) {
        String axisOrder;
        HashMap<String, Object> mappedParams = new HashMap<String, Object>();
        mappedParams.put(WFSDataAccessFactory.URL.key, params.get(RiwaWFSDataStoreFactory.URL.key));
        String username = (String)params.get(RiwaWFSDataStoreFactory.USERNAME.key);
        String password = (String)params.get(RiwaWFSDataStoreFactory.PASSWORD.key);
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            mappedParams.put(WFSDataAccessFactory.USERNAME.key, username);
            mappedParams.put(WFSDataAccessFactory.PASSWORD.key, password);
        }
        if (StringUtils.isNotBlank((CharSequence)(axisOrder = (String)params.get(RiwaWFSDataStoreFactory.AXIS_ORDER.key)))) {
            String wfsAxisOrder = switch (axisOrder) {
                case "east_north" -> "East / North";
                case "north_east" -> "North / East";
                default -> "Compliant";
            };
            mappedParams.put(WFSDataAccessFactory.AXIS_ORDER.key, wfsAxisOrder);
            mappedParams.put(WFSDataAccessFactory.AXIS_ORDER_FILTER.key, wfsAxisOrder);
        }
        mappedParams.put(WFSDataAccessFactory.TRY_GZIP.key, true);
        mappedParams.put(WFSDataAccessFactory.BUFFER_SIZE.key, 100);
        mappedParams.put(WFSDataAccessFactory.LENIENT.key, true);
        mappedParams.put(WFSDataAccessFactory.USEDEFAULTSRS.key, true);
        mappedParams.put(WFSDataAccessFactory.WFS_STRATEGY.key, null);
        mappedParams.put(WFSDataAccessFactory.USE_HTTP_CONNECTION_POOLING.key, false);
        return mappedParams;
    }

    private synchronized void fixDefectGeoToolsGetParser() {
        try {
            WFSExtensions.findResponseFactories((WFSOperationType)WFSOperationType.GET_FEATURE);
            Field field = WFSExtensions.class.getDeclaredField("registry");
            field.setAccessible(true);
            Set registry = (Set)field.get(null);
            registry.removeIf(f -> f instanceof GetFeatureResponseParserFactory && !(f instanceof LenientGetFeatureResponseParserFactory));
        }
        catch (Throwable ex) {
            log.error("Could not unregister default WFS feature parser", ex);
        }
    }

    private static class WFSClientWithExtendedWFS2_0
    extends WFSClient {
        public WFSClientWithExtendedWFS2_0(URL url, HTTPClient httpc, WFSConfig wfsc) throws IOException, ServiceException {
            super(url, httpc, wfsc);
            this.createExtendedWFS2_0Strategy();
        }

        private void createExtendedWFS2_0Strategy() {
            if (!(this.specification instanceof StrictWFS_2_0_Strategy)) {
                return;
            }
            StrictPrefixEnforcingWFS_2_0_Strategy strategy = new StrictPrefixEnforcingWFS_2_0_Strategy();
            this.specification = strategy;
            strategy.setConfig(this.config);
            strategy.setCapabilities((WFSGetCapabilities)this.capabilities);
        }
    }
}

