/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.wfs;

import de.riwagis.geotools.feature.util.FeatureUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.geotools.data.wfs.internal.GetParser;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.data.wfs.internal.parsers.PullParserFeatureReader;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.LenientPullParser;
import org.geotools.xsd.PullParser;
import org.geotools.xsd.impl.ParserHandler;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.xml.sax.SAXException;

public class LenientPullParserFeatureReader
implements GetParser<SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger(PullParserFeatureReader.class);
    private PullParser parser;
    private InputStream inputStream;
    private FeatureType featureType;
    private final String axisOrder;
    GeometryCoordinateSequenceTransformer transformer;

    public LenientPullParserFeatureReader(Configuration wfsConfiguration, InputStream getFeatureResponseStream, FeatureType featureType, String axisOrder) throws IOException {
        this.inputStream = getFeatureResponseStream;
        this.featureType = featureType;
        this.axisOrder = axisOrder;
        this.parser = new LenientPullParser(wfsConfiguration, getFeatureResponseStream, new QName(featureType.getName().getNamespaceURI(), featureType.getName().getLocalPart()));
        this.transformer = new GeometryCoordinateSequenceTransformer();
        this.transformer.setMathTransform((MathTransform)new AffineTransform2D(0.0, 1.0, 1.0, 0.0, 0.0, 0.0));
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            finally {
                this.inputStream = null;
                this.parser = null;
            }
        }
    }

    public SimpleFeature parse() throws IOException {
        CoordinateReferenceSystem crs;
        Geometry geometry;
        SimpleFeature feature;
        Object parsed;
        try {
            parsed = this.parser.parse();
        }
        catch (XMLStreamException | SAXException e) {
            throw new IOException(e);
        }
        if (parsed instanceof Map) {
            String geomAttr = this.featureType.getGeometryDescriptor().getName().toString();
            Map data = (Map)parsed;
            SimpleFeatureType sft = (SimpleFeatureType)this.featureType;
            parsed = FeatureUtil.createFeature((SimpleFeatureType)sft, (String)((String)data.get("id")), (Geometry)((Geometry)data.get(geomAttr)));
            for (Map.Entry kv : data.entrySet()) {
                String key = (String)kv.getKey();
                Object rawValue = kv.getValue();
                AttributeDescriptor attributeDescriptor = FeatureUtil.getAttributeDescriptor((SimpleFeatureType)sft, (String)key);
                if (attributeDescriptor == null) continue;
                Object value = Converters.convert(rawValue, (Class)attributeDescriptor.getType().getBinding());
                FeatureUtil.setAttribute((SimpleFeature)((SimpleFeature)parsed), (String)key, (Object)value);
            }
        }
        if ((feature = (SimpleFeature)parsed) != null && feature.getDefaultGeometry() != null && (geometry = (Geometry)feature.getDefaultGeometry()).getUserData() instanceof CoordinateReferenceSystem && WFSConfig.invertAxisNeeded((String)this.axisOrder, (CoordinateReferenceSystem)(crs = (CoordinateReferenceSystem)geometry.getUserData()))) {
            try {
                feature.setDefaultGeometry((Object)this.invertGeometryCoordinates(geometry));
            }
            catch (TransformException e) {
                throw new IOException(e);
            }
        }
        return feature;
    }

    private Geometry invertGeometryCoordinates(Geometry geometry) throws TransformException {
        return this.transformer.transform(geometry);
    }

    public int getNumberOfFeatures() {
        LOGGER.warning("Pull Parser doesn't implement counting features");
        return -1;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
    }

    public void setContextCustomizer(ParserHandler.ContextCustomizer contextCustomizer) {
        this.parser.setContextCustomizer(contextCustomizer);
    }
}

