/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.wfs;

import de.riwagis.geotools.data.wfs.LenientPullParserFeatureReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.GetParser;
import org.geotools.data.wfs.internal.Versions;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.parsers.GetFeatureResponseParserFactory;
import org.geotools.wfs.v1_0.WFSConfiguration_1_0;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xsd.Configuration;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.FeatureType;

public class LenientGetFeatureResponseParserFactory
extends GetFeatureResponseParserFactory {
    private final Map<String, String> lenientToCompliantType = new HashMap<String, String>();

    public LenientGetFeatureResponseParserFactory() {
        for (String type : this.getSupportedOutputFormats()) {
            String lenientType = LenientGetFeatureResponseParserFactory.removeWhiteSpacesAndCasingAndCharset(type);
            this.lenientToCompliantType.putIfAbsent(lenientType, type);
        }
    }

    private static String removeWhiteSpacesAndCasingAndCharset(String type) {
        return StringUtils.substringBefore((String)StringUtils.deleteWhitespace((String)type.toLowerCase()), (String)";charset=");
    }

    public boolean canProcess(WFSRequest request, String contentType) {
        String lenientType = LenientGetFeatureResponseParserFactory.removeWhiteSpacesAndCasingAndCharset(contentType);
        String compliantType = this.lenientToCompliantType.get(lenientType);
        if (compliantType == null) {
            for (String supported : this.lenientToCompliantType.keySet()) {
                if (!supported.startsWith(lenientType) && !lenientType.startsWith(supported)) continue;
                compliantType = this.lenientToCompliantType.get(supported);
                break;
            }
        }
        if (compliantType == null) {
            return false;
        }
        return super.canProcess(request, compliantType);
    }

    protected GetParser<SimpleFeature> parser(GetFeatureRequest request, InputStream in) throws IOException {
        FeatureType queryType = request.getQueryType();
        if (queryType == null) {
            queryType = request.getFullType();
        }
        WFSConfiguration config = null;
        if (request.getStrategy().getVersion().equals(Versions.v2_0_0.toString())) {
            config = new WFSConfiguration();
        } else if (request.getStrategy().getVersion().equals(Versions.v1_1_0.toString())) {
            config = new org.geotools.wfs.v1_1.WFSConfiguration();
        } else if (request.getStrategy().getVersion().equals(Versions.v1_0_0.toString())) {
            config = new WFSConfiguration_1_0();
        }
        return new LenientPullParserFeatureReader((Configuration)config, in, queryType, request.getStrategy().getConfig().getAxisOrder());
    }
}

