/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.spatialite;

import de.riwagis.geotools.data.spatialite.VersionedDialect;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geotools.geometry.jts.Geometries;
import org.locationtech.jts.geom.Geometry;

class VersionedDialectV4
implements VersionedDialect {
    VersionedDialectV4() {
    }

    @Override
    public String getGeometryTypeForTableQuery(String tableName, String columnName) {
        return "SELECT geometry_type FROM geometry_columns WHERE f_table_name = '" + tableName + "' AND lower(f_geometry_column) = lower('" + columnName + "')";
    }

    @Override
    public String getSRIDForTableQuery(String tableName, String columnName) {
        return "SELECT srid FROM geometry_columns WHERE f_table_name = '" + tableName + "' AND f_geometry_column = lower('" + columnName + "')";
    }

    @Override
    public String getGeometryTypeForViewQuery(String viewName, String columnName) {
        return "SELECT b.geometry_type FROM views_geometry_columns a, geometry_columns b WHERE a.f_table_name = b.f_table_name AND lower(a.f_geometry_column) = lower(b.f_geometry_column) AND a.view_name = '" + viewName + "' AND a.view_geometry = lower('" + columnName + "')";
    }

    @Override
    public String getSRIDForViewQuery(String viewName, String columnName) {
        return "SELECT b.srid FROM views_geometry_columns a, geometry_columns b WHERE a.f_table_name = b.f_table_name AND lower(a.f_geometry_column) = lower(b.f_geometry_column) AND a.view_name = '" + viewName + "' AND a.view_geometry = lower('" + columnName + "')";
    }

    @Override
    public Class<? extends Geometry> getTypeFromResult(ResultSet rs) throws SQLException {
        int type = rs.getInt("geometry_type");
        Geometries binding = Geometries.getForSQLType((int)type);
        if (binding == null) {
            binding = Geometries.GEOMETRY;
        }
        return binding.getBinding();
    }
}

