/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.spatialite;

import de.riwagis.geotools.data.spatialite.SpatiaLiteDialect;
import java.io.IOException;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.geotools.jdbc.SQLDialect;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class SpatiaLiteFilterToSQL
extends FilterToSQL {
    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = super.createFilterCapabilities();
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        return caps;
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry g = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (g instanceof LinearRing) {
            g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
        }
        this.out.write("ST_GeomFromText('" + g.toText() + "', " + this.currentSRID + ")");
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        try {
            String spatialIndex;
            if (filter instanceof DistanceBufferOperator) {
                this.out.write("ST_Distance(");
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(", ");
                geometry.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (filter instanceof DWithin) {
                    this.out.write("<");
                } else if (filter instanceof Beyond) {
                    this.out.write(">");
                } else {
                    throw new RuntimeException("Unknown distance operator");
                }
                this.out.write(Double.toString(((DistanceBufferOperator)filter).getDistance()));
            } else if (filter instanceof BBOX) {
                this.out.write("MbrIntersects(");
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(",");
                geometry.accept((ExpressionVisitor)this, extraData);
                this.out.write(") = 1");
            } else {
                if (filter instanceof Contains) {
                    this.out.write("ST_Contains(");
                } else if (filter instanceof Crosses) {
                    this.out.write("ST_Crosses(");
                } else if (filter instanceof Disjoint) {
                    this.out.write("ST_Disjoint(");
                } else if (filter instanceof Equals) {
                    this.out.write("ST_Equals(");
                } else if (filter instanceof Intersects) {
                    this.out.write("ST_Intersects(");
                } else if (filter instanceof Overlaps) {
                    this.out.write("ST_Overlaps(");
                } else if (filter instanceof Touches) {
                    this.out.write("ST_Touches(");
                } else if (filter instanceof Within) {
                    this.out.write("ST_Within(");
                } else {
                    throw new RuntimeException("Unknown operator: " + filter);
                }
                if (swapped) {
                    geometry.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    property.accept((ExpressionVisitor)this, extraData);
                } else {
                    property.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    geometry.accept((ExpressionVisitor)this, extraData);
                }
                this.out.write(")");
            }
            if (!(filter instanceof Disjoint) && (spatialIndex = (String)this.currentGeometry.getUserData().get(SpatiaLiteDialect.SPATIALITE_SPATIAL_INDEX)) != null) {
                Envelope e = (Envelope)geometry.evaluate(null, Envelope.class);
                this.out.write(" AND ROWID IN (");
                this.out.write("SELECT ROWID FROM SpatialIndex WHERE ");
                this.out.write("f_table_name=\"");
                this.out.write(this.featureType.getTypeName());
                this.out.write("\" and search_frame= BuildMbr(");
                this.out.write(Double.toString(e.getMinX()));
                this.out.write(",");
                this.out.write(Double.toString(e.getMinY()));
                this.out.write(",");
                this.out.write(Double.toString(e.getMaxX()));
                this.out.write(",");
                this.out.write(Double.toString(e.getMaxY()));
                this.out.write("))");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }
}

