/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.spatialite;

import de.riwagis.geotools.data.spatialite.SpatiaLiteFilterToSQL;
import de.riwagis.geotools.data.spatialite.VersionedDialect;
import de.riwagis.geotools.data.spatialite.VersionedDialectV3;
import de.riwagis.geotools.data.spatialite.VersionedDialectV4;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.geometry.jts.Geometries;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatiaLiteDialect
extends BasicSQLDialect {
    private static Map<Integer, VersionedDialect> VERSIONED_DIALECTS = Map.of(3, new VersionedDialectV3(), 4, new VersionedDialectV4());
    public static String SPATIALITE_SPATIAL_INDEX = "org.geotools.data.spatialite.spatialIndex";
    public static final int DEFAULT_VERSION = 4;
    private int version = 4;

    public SpatiaLiteDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initializeConnection(Connection cx) throws SQLException {
        block13: {
            Statement st = cx.createStatement();
            try {
                st = cx.createStatement();
                boolean initSpatialMetaData = false;
                try {
                    st.execute("SELECT count(*) from geometry_columns");
                }
                catch (SQLException e) {
                    initSpatialMetaData = true;
                }
                if (initSpatialMetaData) {
                    st.execute("SELECT InitSpatialMetaData()");
                    st.close();
                    st = cx.createStatement();
                }
                boolean loadSpatialRefSys = false;
                ResultSet rs = st.executeQuery("SELECT * FROM spatial_ref_sys");
                try {
                    loadSpatialRefSys = !rs.next();
                }
                finally {
                    this.dataStore.closeSafe(rs);
                }
                if (!loadSpatialRefSys) break block13;
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("init_spatialite-2.3.sql")));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        st.execute(line);
                    }
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading spatial ref sys file", e);
                }
            }
            finally {
                this.dataStore.closeSafe(st);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        String tbl = columnMetaData.getString("TABLE_NAME");
        String col = columnMetaData.getString("COLUMN_NAME");
        VersionedDialect versionedDialect = VERSIONED_DIALECTS.get(this.version);
        Statement st = cx.createStatement();
        try {
            String tableTypeQuery = versionedDialect.getGeometryTypeForTableQuery(tbl, col);
            Class typeFromTable = this.mapFirstResultToValue(tableTypeQuery, st, versionedDialect::getTypeFromResult);
            if (typeFromTable != null) {
                Class clazz = typeFromTable;
                return clazz;
            }
            String viewTypeQuery = versionedDialect.getGeometryTypeForViewQuery(tbl, col);
            Class clazz = this.mapFirstResultToValue(viewTypeQuery, st, versionedDialect::getTypeFromResult);
            return clazz;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends SQLException> T mapFirstResultToValue(String query, Statement st, ResultSetMapper<T, E> mapper) throws SQLException {
        LOGGER.fine(query);
        ResultSet rs = st.executeQuery(query);
        try {
            if (rs.next()) {
                T t = mapper.apply(rs);
                return t;
            }
        }
        finally {
            this.dataStore.closeSafe(rs);
        }
        return null;
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Geometries.POINT.getBinding(), Geometries.POINT.getSQLType());
        mappings.put(Geometries.LINESTRING.getBinding(), Geometries.LINESTRING.getSQLType());
        mappings.put(Geometries.POLYGON.getBinding(), Geometries.POLYGON.getSQLType());
        mappings.put(Geometries.MULTIPOINT.getBinding(), Geometries.MULTIPOINT.getSQLType());
        mappings.put(Geometries.MULTILINESTRING.getBinding(), Geometries.MULTILINESTRING.getSQLType());
        mappings.put(Geometries.MULTIPOLYGON.getBinding(), Geometries.MULTIPOLYGON.getSQLType());
        mappings.put(Geometries.GEOMETRY.getBinding(), Geometries.GEOMETRY.getSQLType());
        mappings.put(Geometries.GEOMETRYCOLLECTION.getBinding(), Geometries.GEOMETRYCOLLECTION.getSQLType());
        mappings.put(Long.class, 4);
        mappings.put(Double.class, 7);
    }

    public String getGeometryTypeName(Integer type) {
        return Geometries.getForSQLType((int)type).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            VersionedDialect versionedDialect = VERSIONED_DIALECTS.get(this.version);
            String tableSRIDQuery = versionedDialect.getSRIDForTableQuery(tableName, columnName);
            Integer sridFromTable = this.mapFirstResultToValue(tableSRIDQuery, st, rs -> rs.getInt(1));
            if (sridFromTable != null) {
                Integer n = sridFromTable;
                return n;
            }
            String viewSRIDQuery = versionedDialect.getSRIDForViewQuery(tableName, columnName);
            Integer sridFromView = this.mapFirstResultToValue(viewSRIDQuery, st, rs -> rs.getInt(1));
            if (sridFromView != null) {
                Integer n = sridFromView;
                return n;
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return super.getGeometrySRID(schemaName, tableName, columnName, cx);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        sql.append("ST_AsBinary(");
        this.encodeColumnName(prefix, gatt.getLocalName(), sql);
        sql.append(")");
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        byte[] wkb = rs.getBytes(column);
        if (wkb == null) {
            return null;
        }
        try {
            return new WKBReader(factory).read(wkb);
        }
        catch (ParseException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) throws IOException {
        if (value != null) {
            sql.append("ST_GeomFromText('").append(new WKTWriter(dimension).write(value)).append("',").append(srid).append(")");
        } else {
            sql.append("NULL");
        }
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("ST_AsBinary(ST_Envelope(");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append("))");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        byte[] wkb = rs.getBytes(column);
        if (wkb == null) {
            return null;
        }
        try {
            return new WKBReader().read(wkb).getEnvelopeInternal();
        }
        catch (ParseException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            if (!(ad instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd = (GeometryDescriptor)ad;
            StringBuffer sql = new StringBuffer("INSERT INTO geometry_columns VALUES (");
            sql.append("Lower('").append(featureType.getTypeName()).append(")',");
            sql.append("Lower('").append(gd.getLocalName()).append(")',");
            String gType = Geometries.getForBinding((Class)gd.getType().getBinding()).getName();
            if (gType == null) {
                throw new IOException("Unknown geometry type: " + gd.getType().getBinding());
            }
            sql.append("'").append(gType).append("',");
            sql.append(2).append(",");
            Integer epsgCode = null;
            if (gd.getCoordinateReferenceSystem() != null) {
                CoordinateReferenceSystem crs = gd.getCoordinateReferenceSystem();
                try {
                    epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (epsgCode == null) {
                throw new IOException("Unable to find epsg code code.");
            }
            sql.append(epsgCode).append(",");
            sql.append(0).append(")");
            LOGGER.fine(sql.toString());
            Statement st = cx.createStatement();
            try {
                st.executeUpdate(sql.toString());
            }
            finally {
                this.dataStore.closeSafe(st);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateFeatureType(SimpleFeatureType featureType, DatabaseMetaData metadata, String schemaName, Connection cx) throws SQLException {
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            if (!(ad instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd = (GeometryDescriptor)ad;
            String idxTableName = "idx_" + featureType.getTypeName() + "_" + gd.getLocalName();
            ResultSet rs = metadata.getTables(null, schemaName, idxTableName, new String[]{"TABLE"});
            try {
                if (!rs.next()) continue;
                gd.getUserData().put(SPATIALITE_SPATIAL_INDEX, idxTableName);
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            ResultSet rs = st.executeQuery("SELECT last_insert_rowid();");
            try {
                if (rs.next()) {
                    Integer n = rs.getInt(1);
                    return n;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public boolean isLimitOffsetSupported() {
        return false;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit > 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT " + limit);
            if (offset > 0) {
                sql.append(" OFFSET " + offset);
            }
        } else if (offset > 0) {
            sql.append(" OFFSET " + offset);
        }
    }

    public FilterToSQL createFilterToSQL() {
        return new SpatiaLiteFilterToSQL();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @FunctionalInterface
    public static interface ResultSetMapper<R, E extends Exception> {
        public R apply(ResultSet var1) throws E;
    }
}

