/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.spatialite;

import de.riwagis.geotools.data.spatialite.SpatiaLiteDialect;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;
import org.sqlite.SQLiteConfig;

public class SpatiaLiteDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"spatialite");
    public static final DataAccessFactory.Param SPATIALITE_LIB = new DataAccessFactory.Param("spatialite_lib", String.class, "Path to Spatialite library", false, (Object)"mod_spatialite");
    public static final DataAccessFactory.Param VERSION = new DataAccessFactory.Param("version", Integer.class, "Spatialite Version", false, (Object)4);
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param(JDBCDataStoreFactory.USER.key, JDBCDataStoreFactory.USER.type, JDBCDataStoreFactory.USER.description, false, JDBCDataStoreFactory.USER.sample);
    File baseDirectory = null;

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new SpatiaLiteDialect(dataStore);
    }

    protected DataSource createDataSource(Map params, SQLDialect dialect) throws IOException {
        Object version = VERSION.lookUp(params);
        if (version != null) {
            ((SpatiaLiteDialect)dialect).setVersion((Integer)version);
        }
        this.removeKeyIfValueIsBlank(params, SCHEMA);
        return super.createDataSource(params, dialect);
    }

    private void removeKeyIfValueIsBlank(Map parameters, DataAccessFactory.Param parameter) {
        Object schemaValue = parameters.get(parameter.key);
        if (schemaValue != null && schemaValue.toString().isBlank()) {
            parameters.remove(SpatiaLiteDataStoreFactory.SCHEMA.key);
        }
    }

    protected String getDatabaseID() {
        return "spatialite";
    }

    protected String getDriverClassName() {
        return "org.sqlite.JDBC";
    }

    public String getDescription() {
        return "SpatiaLite";
    }

    protected String getValidationQuery() {
        return null;
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.remove(SpatiaLiteDataStoreFactory.HOST.key);
        parameters.remove(SpatiaLiteDataStoreFactory.PORT.key);
        parameters.remove(JDBCDataStoreFactory.USER.key);
        parameters.put(SpatiaLiteDataStoreFactory.USER.key, USER);
        parameters.put(SpatiaLiteDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(SpatiaLiteDataStoreFactory.SPATIALITE_LIB.key, SPATIALITE_LIB);
        parameters.put(SpatiaLiteDataStoreFactory.VERSION.key, VERSION);
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String db = (String)DATABASE.lookUp(params);
        Object location = db;
        if (this.baseDirectory != null && !new File((String)location).isAbsolute()) {
            location = this.baseDirectory.getAbsolutePath() + File.separator + db;
        }
        return "jdbc:sqlite:" + (String)location;
    }

    public BasicDataSource createDataSource(Map params) throws IOException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.getDriverClassName());
        dataSource.setUrl(this.getJDBCUrl(params));
        SpatiaLiteDataStoreFactory.addConnectionProperties(dataSource);
        SpatiaLiteDataStoreFactory.initializeDataSource(dataSource, params);
        return dataSource;
    }

    static void addConnectionProperties(BasicDataSource dataSource) {
        SQLiteConfig config = new SQLiteConfig();
        config.setSharedCache(true);
        config.setTempStore(SQLiteConfig.TempStore.MEMORY);
        config.enableLoadExtension(true);
        for (Map.Entry<Object, Object> e : config.toProperties().entrySet()) {
            dataSource.addConnectionProperty((String)e.getKey(), (String)e.getValue());
        }
    }

    static void initializeDataSource(BasicDataSource dataSource, Map params) throws IOException {
        String strLibPath = (String)SPATIALITE_LIB.lookUp(params);
        if (strLibPath == null || strLibPath.trim().length() == 0) {
            strLibPath = new File("mod_spatialite").getAbsolutePath();
        }
        ArrayList<CallSite> colSQL = new ArrayList<CallSite>(dataSource.getConnectionInitSqls());
        colSQL.add((CallSite)((Object)("SELECT load_extension('" + strLibPath + "')")));
        dataSource.setConnectionInitSqls(colSQL);
    }
}

