/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile.shp.xml;

import de.riwagis.geotools.data.shapefile.FileReader;
import de.riwagis.geotools.data.shapefile.ShpFileType;
import de.riwagis.geotools.data.shapefile.ShpFiles;
import de.riwagis.geotools.data.shapefile.shp.xml.IdInfo;
import de.riwagis.geotools.data.shapefile.shp.xml.Metadata;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.locationtech.jts.geom.Envelope;

public class ShpXmlFileReader
implements FileReader {
    private final Document dom;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShpXmlFileReader(ShpFiles shapefileFiles) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder(false);
        try (InputStream inputStream = shapefileFiles.getInputStream(ShpFileType.SHP_XML, this);){
            this.dom = builder.build(inputStream);
        }
    }

    public Metadata parse() {
        return this.parseMetadata(this.dom.getRootElement());
    }

    protected Metadata parseMetadata(Element root) {
        Metadata meta = new Metadata();
        meta.setIdinfo(this.parseIdInfo(root.getChild("idinfo")));
        return meta;
    }

    protected IdInfo parseIdInfo(Element element) {
        IdInfo idInfo = new IdInfo();
        Element bounding = element.getChild("spdom").getChild("bounding");
        idInfo.setBounding(this.parseBounding(bounding));
        Element lbounding = element.getChild("spdom").getChild("lbounding");
        idInfo.setLbounding(this.parseBounding(lbounding));
        return idInfo;
    }

    protected Envelope parseBounding(Element bounding) {
        if (bounding == null) {
            return new Envelope();
        }
        double minX = Double.parseDouble(bounding.getChildText("westbc"));
        double maxX = Double.parseDouble(bounding.getChildText("eastbc"));
        double minY = Double.parseDouble(bounding.getChildText("southbc"));
        double maxY = Double.parseDouble(bounding.getChildText("northbc"));
        return new Envelope(minX, maxX, minY, maxY);
    }

    @Override
    public String id() {
        return "Shp Xml Reader";
    }
}

