/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile.shp;

import de.riwagis.geotools.data.shapefile.StreamLogging;
import de.riwagis.geotools.data.shapefile.shp.ShapeHandler;
import de.riwagis.geotools.data.shapefile.shp.ShapeType;
import de.riwagis.geotools.data.shapefile.shp.ShapefileException;
import de.riwagis.geotools.data.shapefile.shp.ShapefileHeader;
import de.riwagis.geotools.util.NIOUtilities;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;

public class ShapefileWriter {
    FileChannel shpChannel;
    FileChannel shxChannel;
    ByteBuffer shapeBuffer;
    ByteBuffer indexBuffer;
    ShapeHandler handler;
    ShapeType type;
    int offset;
    int lp;
    int cnt;
    private final StreamLogging shpLogger = new StreamLogging("SHP Channel in ShapefileWriter");
    private final StreamLogging shxLogger = new StreamLogging("SHX Channel in ShapefileWriter");

    public ShapefileWriter(FileChannel shpChannel, FileChannel shxChannel) throws IOException {
        this.shpChannel = shpChannel;
        this.shxChannel = shxChannel;
        this.shpLogger.open();
        this.shxLogger.open();
    }

    private void allocateBuffers() {
        this.shapeBuffer = ByteBuffer.allocateDirect(16384);
        this.indexBuffer = ByteBuffer.allocateDirect(100);
    }

    private void checkShapeBuffer(int size) {
        if (this.shapeBuffer.capacity() < size) {
            if (this.shapeBuffer != null) {
                NIOUtilities.clean(this.shapeBuffer);
            }
            this.shapeBuffer = ByteBuffer.allocateDirect(size);
        }
    }

    private void drain() throws IOException {
        this.shapeBuffer.flip();
        this.indexBuffer.flip();
        while (this.shapeBuffer.remaining() > 0) {
            this.shpChannel.write(this.shapeBuffer);
        }
        while (this.indexBuffer.remaining() > 0) {
            this.shxChannel.write(this.indexBuffer);
        }
        this.shapeBuffer.flip().limit(this.shapeBuffer.capacity());
        this.indexBuffer.flip().limit(this.indexBuffer.capacity());
    }

    private void writeHeaders(GeometryCollection geometries, ShapeType type) throws IOException {
        int fileLength = 100;
        for (int i = geometries.getNumGeometries() - 1; i >= 0; --i) {
            int size = this.handler.getLength(geometries.getGeometryN(i)) + 8;
            fileLength += size;
        }
        this.writeHeaders(geometries.getEnvelopeInternal(), type, geometries.getNumGeometries(), fileLength);
    }

    public void writeHeaders(Envelope bounds, ShapeType type, int numberOfGeometries, int fileLength) throws IOException {
        try {
            this.handler = type.getShapeHandler();
        }
        catch (ShapefileException se) {
            throw new RuntimeException("unexpected Exception", (Throwable)((Object)se));
        }
        if (this.shapeBuffer == null) {
            this.allocateBuffers();
        }
        ShapefileHeader header = new ShapefileHeader();
        header.write(this.shapeBuffer, type, numberOfGeometries, fileLength / 2, bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
        header.write(this.indexBuffer, type, numberOfGeometries, 50 + 4 * numberOfGeometries, bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
        this.offset = 50;
        this.type = type;
        this.cnt = 0;
        this.shpChannel.position(0L);
        this.shxChannel.position(0L);
        this.drain();
    }

    public void skipHeaders() throws IOException {
        if (this.shapeBuffer == null) {
            this.allocateBuffers();
        }
        this.shpChannel.position(100L);
        this.shxChannel.position(100L);
    }

    public void writeGeometry(Geometry g) throws IOException {
        if (this.shapeBuffer == null) {
            throw new IOException("Must write headers first");
        }
        this.lp = this.shapeBuffer.position();
        int length = this.handler.getLength(g);
        this.checkShapeBuffer(length + 8);
        this.shapeBuffer.order(ByteOrder.BIG_ENDIAN);
        this.shapeBuffer.putInt(++this.cnt);
        this.shapeBuffer.putInt(length /= 2);
        this.shapeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (g == null || g.isEmpty()) {
            this.shapeBuffer.putInt(ShapeType.NULL.id);
        } else {
            this.shapeBuffer.putInt(this.type.id);
        }
        this.handler.write(this.shapeBuffer, g);
        assert (length * 2 == this.shapeBuffer.position() - this.lp - 8);
        this.lp = this.shapeBuffer.position();
        this.indexBuffer.putInt(this.offset);
        this.indexBuffer.putInt(length);
        this.offset += length + 4;
        this.drain();
        assert (this.shapeBuffer.position() == 0);
    }

    public void close() throws IOException {
        try {
            if (this.shpChannel != null && this.shpChannel.isOpen()) {
                this.shpChannel.close();
                this.shpLogger.close();
            }
        }
        finally {
            if (this.shxChannel != null && this.shxChannel.isOpen()) {
                this.shxChannel.close();
                this.shxLogger.close();
            }
        }
        this.shpChannel = null;
        this.shxChannel = null;
        this.handler = null;
        if (this.indexBuffer instanceof MappedByteBuffer) {
            NIOUtilities.clean(this.indexBuffer);
        }
        if (this.shapeBuffer instanceof MappedByteBuffer) {
            NIOUtilities.clean(this.shapeBuffer);
        }
        this.indexBuffer = null;
        this.shapeBuffer = null;
    }

    public void write(GeometryCollection geometries, ShapeType type) throws IOException, ShapefileException {
        this.handler = type.getShapeHandler();
        this.writeHeaders(geometries, type);
        this.lp = this.shapeBuffer.position();
        int ii = geometries.getNumGeometries();
        for (int i = 0; i < ii; ++i) {
            Geometry g = geometries.getGeometryN(i);
            this.writeGeometry(g);
        }
        this.close();
    }
}

