/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile.shp;

import de.riwagis.geotools.data.shapefile.shp.MultiLineHandler;
import de.riwagis.geotools.data.shapefile.shp.MultiPointHandler;
import de.riwagis.geotools.data.shapefile.shp.PointHandler;
import de.riwagis.geotools.data.shapefile.shp.PolygonHandler;
import de.riwagis.geotools.data.shapefile.shp.ShapeHandler;
import de.riwagis.geotools.data.shapefile.shp.ShapefileException;

public final class ShapeType {
    public static final ShapeType NULL = new ShapeType(0, "Null");
    public static final ShapeType POINT = new ShapeType(1, "Point");
    public static final ShapeType POINTZ = new ShapeType(11, "PointZ");
    public static final ShapeType POINTM = new ShapeType(21, "PointM");
    public static final ShapeType ARC = new ShapeType(3, "Arc");
    public static final ShapeType ARCZ = new ShapeType(13, "ArcZ");
    public static final ShapeType ARCM = new ShapeType(23, "ArcM");
    public static final ShapeType POLYGON = new ShapeType(5, "Polygon");
    public static final ShapeType POLYGONZ = new ShapeType(15, "PolygonZ");
    public static final ShapeType POLYGONM = new ShapeType(25, "PolygonM");
    public static final ShapeType MULTIPOINT = new ShapeType(8, "MultiPoint");
    public static final ShapeType MULTIPOINTZ = new ShapeType(18, "MultiPointZ");
    public static final ShapeType MULTIPOINTM = new ShapeType(28, "MultiPointM");
    public static final ShapeType UNDEFINED = new ShapeType(-1, "Undefined");
    public final int id;
    public final String name;

    protected ShapeType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isMultiPoint() {
        boolean mp = true;
        if (this == UNDEFINED) {
            mp = false;
        } else if (this == NULL) {
            mp = false;
        } else if (this == POINT) {
            mp = false;
        } else if (this == POINTZ) {
            mp = false;
        } else if (this == POINTM) {
            mp = false;
        }
        return mp;
    }

    public boolean isPointType() {
        return this.id % 10 == 1;
    }

    public boolean isLineType() {
        return this.id % 10 == 3;
    }

    public boolean isPolygonType() {
        return this.id % 10 == 5;
    }

    public boolean isMultiPointType() {
        return this.id % 10 == 8;
    }

    public static ShapeType forID(int id) {
        return switch (id) {
            case 0 -> NULL;
            case 1 -> POINT;
            case 11 -> POINTZ;
            case 21 -> POINTM;
            case 3 -> ARC;
            case 13 -> ARCZ;
            case 23 -> ARCM;
            case 5 -> POLYGON;
            case 15 -> POLYGONZ;
            case 25 -> POLYGONM;
            case 8 -> MULTIPOINT;
            case 18 -> MULTIPOINTZ;
            case 28 -> MULTIPOINTM;
            default -> UNDEFINED;
        };
    }

    public ShapeHandler getShapeHandler() throws ShapefileException {
        return switch (this.id) {
            case 1, 11, 21 -> new PointHandler(this);
            case 3, 13, 23 -> new MultiLineHandler(this);
            case 5, 15, 25 -> new PolygonHandler(this);
            case 8, 18, 28 -> new MultiPointHandler(this);
            default -> null;
        };
    }
}

