/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile.shp;

import de.riwagis.geotools.data.shapefile.shp.JTSUtilities;
import de.riwagis.geotools.data.shapefile.shp.ShapeHandler;
import de.riwagis.geotools.data.shapefile.shp.ShapeType;
import de.riwagis.geotools.data.shapefile.shp.ShapefileException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class PolygonHandler
implements ShapeHandler {
    GeometryFactory geometryFactory = new GeometryFactory();
    CGAlgorithms cga = new CGAlgorithms();
    final ShapeType shapeType;

    public PolygonHandler() {
        this.shapeType = ShapeType.POLYGON;
    }

    public PolygonHandler(ShapeType type) throws ShapefileException {
        if (type != ShapeType.POLYGON && type != ShapeType.POLYGONM && type != ShapeType.POLYGONZ) {
            throw new ShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.shapeType = type;
    }

    boolean pointInList(Coordinate testPoint, Coordinate[] pointList) {
        for (int t = pointList.length - 1; t >= 0; --t) {
            Coordinate p = pointList[t];
            if (testPoint.x != p.x || testPoint.y != p.y || testPoint.z != p.z && testPoint.z == testPoint.z) continue;
            return true;
        }
        return false;
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public int getLength(Object geometry) {
        int length;
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : this.geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)geometry});
        int nrings = 0;
        for (int t = 0; t < multi.getNumGeometries(); ++t) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int npoints = multi.getNumPoints();
        if (this.shapeType == ShapeType.POLYGONZ) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16 + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGONM) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGON) {
            length = 44 + 4 * nrings + 16 * npoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Polygon, got " + this.shapeType);
        }
        return length;
    }

    @Override
    public Object read(ByteBuffer buffer, ShapeType type) {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        ArrayList<LinearRing> shells = new ArrayList<LinearRing>();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        Coordinate[] coords = this.readCoordinates(buffer, numPoints);
        if (this.shapeType == ShapeType.POLYGONZ) {
            buffer.position(buffer.position() + 16);
            for (int t = 0; t < numPoints; ++t) {
                coords[t].z = buffer.getDouble();
            }
        }
        int offset = 0;
        for (int part = 0; part < numParts; ++part) {
            int start = partOffsets[part];
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            Coordinate[] points = new Coordinate[length];
            for (int i = 0; i < length; ++i) {
                points[i] = coords[offset++];
            }
            if (points.length <= 3) continue;
            if (!points[0].equals((Object)points[points.length - 1])) {
                Coordinate[] newpoints = new Coordinate[points.length + 1];
                for (int i = 0; i < points.length; ++i) {
                    newpoints[i] = points[i];
                }
                newpoints[points.length] = (Coordinate)points[0].clone();
                points = newpoints;
            }
            LinearRing ring = this.geometryFactory.createLinearRing(points);
            if (CGAlgorithms.isCCW((Coordinate[])points)) {
                holes.add(ring);
                continue;
            }
            shells.add(ring);
        }
        if (shells.size() == 1) {
            return this.createMulti((LinearRing)shells.get(0), holes);
        }
        if (holes.size() == 1 && shells.isEmpty()) {
            Logging.getLogger((String)"org.geotools.data.shapefile").warning("only one hole in this polygon record");
            return this.createMulti(JTSUtilities.reverseRing((LinearRing)holes.get(0)));
        }
        List holesForShells = this.assignHolesToShells(shells, holes);
        Geometry g = this.buildGeometries(shells, holes, holesForShells);
        return g;
    }

    private Coordinate[] readCoordinates(ByteBuffer buffer, int numPoints) {
        Coordinate[] coords = new Coordinate[numPoints];
        for (int t = 0; t < numPoints; ++t) {
            coords[t] = new Coordinate(buffer.getDouble(), buffer.getDouble());
        }
        return coords;
    }

    private Geometry buildGeometries(List shells, List holes, List holesForShells) {
        int i;
        Polygon[] polygons = shells.size() > 0 ? new Polygon[shells.size()] : new Polygon[holes.size()];
        for (i = 0; i < shells.size(); ++i) {
            polygons[i] = this.geometryFactory.createPolygon((LinearRing)shells.get(i), ((List)holesForShells.get(i)).toArray(new LinearRing[0]));
        }
        if (shells.isEmpty()) {
            int ii = holes.size();
            for (i = 0; i < ii; ++i) {
                LinearRing hole = (LinearRing)holes.get(i);
                polygons[i] = this.geometryFactory.createPolygon(JTSUtilities.reverseRing(hole), new LinearRing[0]);
            }
        }
        MultiPolygon g = this.geometryFactory.createMultiPolygon(polygons);
        return g;
    }

    List assignHolesToShells(List shells, List holes) {
        ArrayList holesForShells = new ArrayList(shells.size());
        for (Object shell : shells) {
            holesForShells.add(new ArrayList());
        }
        for (int i = 0; i < holes.size(); ++i) {
            LinearRing testRing = (LinearRing)holes.get(i);
            LinearRing minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            for (int j = 0; j < shells.size(); ++j) {
                LinearRing tryRing = (LinearRing)shells.get(j);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv) && (CGAlgorithms.isPointInRing((Coordinate)testPt, (Coordinate[])coordList) || this.pointInList(testPt, coordList))) {
                    isContained = true;
                }
                if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                minShell = tryRing;
            }
            if (minShell == null) {
                Logging.getLogger((String)"org.geotools.data.shapefile").warning("polygon found with a hole thats not inside a shell");
                shells.add(JTSUtilities.reverseRing(testRing));
                holesForShells.add(new ArrayList());
                continue;
            }
            ((List)holesForShells.get(shells.indexOf(minShell))).add(testRing);
        }
        return holesForShells;
    }

    private MultiPolygon createMulti(LinearRing single) {
        return this.createMulti(single, Collections.EMPTY_LIST);
    }

    private MultiPolygon createMulti(LinearRing single, List holes) {
        return this.geometryFactory.createMultiPolygon(new Polygon[]{this.geometryFactory.createPolygon(single, holes.toArray(new LinearRing[holes.size()]))});
    }

    private MultiPolygon createNull() {
        return this.geometryFactory.createMultiPolygon(null);
    }

    @Override
    public void write(ByteBuffer buffer, Object geometry) {
        int seqSize;
        CoordinateSequence coords;
        int ringN;
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : this.geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)geometry});
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        ArrayList<CoordinateSequence> allCoords = new ArrayList<CoordinateSequence>();
        for (int t = 0; t < multi.getNumGeometries(); ++t) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            allCoords.add(p.getExteriorRing().getCoordinateSequence());
            for (ringN = 0; ringN < p.getNumInteriorRing(); ++ringN) {
                allCoords.add(p.getInteriorRingN(ringN).getCoordinateSequence());
            }
        }
        CoordinateSequence[] coordinates = allCoords.toArray(new CoordinateSequence[allCoords.size()]);
        int nrings = coordinates.length;
        int npoints = multi.getNumPoints();
        buffer.putInt(nrings);
        buffer.putInt(npoints);
        int count = 0;
        for (int t = 0; t < nrings; ++t) {
            buffer.putInt(count);
            count += coordinates[t].size();
        }
        double[] zExtreame = new double[]{Double.NaN, Double.NaN};
        for (ringN = 0; ringN < nrings; ++ringN) {
            coords = coordinates[ringN];
            JTSUtilities.zMinMax(coords, zExtreame);
            seqSize = coords.size();
            for (int coordN = 0; coordN < seqSize; ++coordN) {
                buffer.putDouble(coords.getOrdinate(coordN, 0));
                buffer.putDouble(coords.getOrdinate(coordN, 1));
            }
        }
        if (this.shapeType == ShapeType.POLYGONZ) {
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (ringN = 0; ringN < nrings; ++ringN) {
                coords = coordinates[ringN];
                seqSize = coords.size();
                for (int coordN = 0; coordN < seqSize; ++coordN) {
                    double z = coords.getOrdinate(coordN, 2);
                    if (Double.isNaN(z)) {
                        buffer.putDouble(0.0);
                        continue;
                    }
                    buffer.putDouble(z);
                }
            }
        }
        if (this.shapeType == ShapeType.POLYGONM || this.shapeType == ShapeType.POLYGONZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (int t = 0; t < npoints; ++t) {
                buffer.putDouble(-1.0E41);
            }
        }
    }
}

