/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile.shp;

import de.riwagis.geotools.data.shapefile.shp.JTSUtilities;
import de.riwagis.geotools.data.shapefile.shp.ShapeHandler;
import de.riwagis.geotools.data.shapefile.shp.ShapeType;
import de.riwagis.geotools.data.shapefile.shp.ShapefileException;
import java.nio.ByteBuffer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;

public class MultiPointHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory = new GeometryFactory();

    public MultiPointHandler() {
        this.shapeType = ShapeType.POINT;
    }

    public MultiPointHandler(ShapeType type) throws ShapefileException {
        if (type != ShapeType.MULTIPOINT && type != ShapeType.MULTIPOINTM && type != ShapeType.MULTIPOINTZ) {
            throw new ShapefileException("Multipointhandler constructor - expected type to be 8, 18, or 28");
        }
        this.shapeType = type;
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public int getLength(Object geometry) {
        int length;
        MultiPoint mp = (MultiPoint)geometry;
        if (this.shapeType == ShapeType.MULTIPOINT) {
            length = mp.getNumGeometries() * 16 + 40;
        } else if (this.shapeType == ShapeType.MULTIPOINTM) {
            length = mp.getNumGeometries() * 16 + 40 + 16 + 8 * mp.getNumGeometries();
        } else if (this.shapeType == ShapeType.MULTIPOINTZ) {
            length = mp.getNumGeometries() * 16 + 40 + 16 + 8 * mp.getNumGeometries() + 16 + 8 * mp.getNumGeometries();
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + this.shapeType);
        }
        return length;
    }

    private Object createNull() {
        Coordinate[] c = null;
        return this.geometryFactory.createMultiPoint(c);
    }

    @Override
    public Object read(ByteBuffer buffer, ShapeType type) {
        int t;
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.position(buffer.position() + 32);
        int numpoints = buffer.getInt();
        Coordinate[] coords = new Coordinate[numpoints];
        for (t = 0; t < numpoints; ++t) {
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            coords[t] = new Coordinate(x, y);
        }
        if (this.shapeType == ShapeType.MULTIPOINTZ) {
            buffer.position(buffer.position() + 16);
            for (t = 0; t < numpoints; ++t) {
                coords[t].z = buffer.getDouble();
            }
        }
        return this.geometryFactory.createMultiPoint(coords);
    }

    @Override
    public void write(ByteBuffer buffer, Object geometry) {
        Coordinate c;
        int t;
        MultiPoint mp = (MultiPoint)geometry;
        Envelope box = mp.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        buffer.putInt(mp.getNumGeometries());
        int tt = mp.getNumGeometries();
        for (t = 0; t < tt; ++t) {
            c = mp.getGeometryN(t).getCoordinate();
            buffer.putDouble(c.x);
            buffer.putDouble(c.y);
        }
        if (this.shapeType == ShapeType.MULTIPOINTZ) {
            double[] zExtreame = JTSUtilities.zMinMax(mp.getCoordinates());
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (int t2 = 0; t2 < mp.getNumGeometries(); ++t2) {
                c = mp.getGeometryN(t2).getCoordinate();
                double z = c.z;
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                    continue;
                }
                buffer.putDouble(z);
            }
        }
        if (this.shapeType == ShapeType.MULTIPOINTM || this.shapeType == ShapeType.MULTIPOINTZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (t = 0; t < mp.getNumGeometries(); ++t) {
                buffer.putDouble(-1.0E41);
            }
        }
    }
}

