/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile.indexed;

import de.riwagis.geotools.data.TransactionStateDiff;
import de.riwagis.geotools.data.shapefile.FileReader;
import de.riwagis.geotools.data.shapefile.FileWriter;
import de.riwagis.geotools.data.shapefile.ShapefileDataStore;
import de.riwagis.geotools.data.shapefile.ShapefileDataStoreFactory;
import de.riwagis.geotools.data.shapefile.ShpFileType;
import de.riwagis.geotools.data.shapefile.dbf.DbaseFileReader;
import de.riwagis.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import de.riwagis.geotools.data.shapefile.indexed.CloseableArrayList;
import de.riwagis.geotools.data.shapefile.indexed.FidIndexer;
import de.riwagis.geotools.data.shapefile.indexed.IndexType;
import de.riwagis.geotools.data.shapefile.indexed.IndexedFidReader;
import de.riwagis.geotools.data.shapefile.indexed.IndexedShapefileAttributeReader;
import de.riwagis.geotools.data.shapefile.indexed.IndexedShapefileFeatureWriter;
import de.riwagis.geotools.data.shapefile.indexed.ShapeFIDReader;
import de.riwagis.geotools.data.shapefile.indexed.ShapeFileIndexer;
import de.riwagis.geotools.data.shapefile.shp.IndexFile;
import de.riwagis.geotools.data.shapefile.shp.ShapefileReader;
import de.riwagis.geotools.index.CloseableCollection;
import de.riwagis.geotools.index.Data;
import de.riwagis.geotools.index.DataDefinition;
import de.riwagis.geotools.index.LockTimeoutException;
import de.riwagis.geotools.index.TreeException;
import de.riwagis.geotools.index.quadtree.QuadTree;
import de.riwagis.geotools.index.quadtree.StoreException;
import de.riwagis.geotools.index.quadtree.fs.FileSystemIndexStore;
import de.riwagis.geotools.index.rtree.RTree;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FIDFeatureReader;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.SchemaException;
import org.geotools.feature.visitor.IdCollectorFilterVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.URLs;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.util.ProgressListener;

public class IndexedShapefileDataStore
extends ShapefileDataStore
implements FileWriter {
    IndexType treeType;
    final boolean useIndex;
    private RTree rtree;
    int maxDepth;

    public IndexedShapefileDataStore(URL url) throws MalformedURLException {
        this(url, null, false, true, IndexType.QIX);
    }

    public IndexedShapefileDataStore(URL url, URI namespace) throws MalformedURLException {
        this(url, namespace, false, true, IndexType.QIX);
    }

    public IndexedShapefileDataStore(URL url, boolean useMemoryMappedBuffer, boolean createIndex) throws MalformedURLException {
        this(url, null, useMemoryMappedBuffer, createIndex, IndexType.QIX);
    }

    public IndexedShapefileDataStore(URL url, URI namespace, boolean useMemoryMappedBuffer, boolean createIndex, IndexType treeType) throws MalformedURLException {
        this(url, namespace, useMemoryMappedBuffer, createIndex, treeType, DEFAULT_STRING_CHARSET);
    }

    public IndexedShapefileDataStore(URL url, URI namespace, boolean useMemoryMappedBuffer, boolean createIndex, IndexType treeType, Charset dbfCharset) throws MalformedURLException {
        super(url, namespace, useMemoryMappedBuffer, dbfCharset);
        this.treeType = treeType;
        this.useIndex = treeType != IndexType.NONE;
        this.maxDepth = 12;
        try {
            if (this.shpFiles.isLocal() && createIndex && this.needsGeneration(treeType.shpFileType)) {
                this.createSpatialIndex();
            }
        }
        catch (IOException e) {
            this.treeType = IndexType.NONE;
            ShapefileDataStoreFactory.LOGGER.log(Level.SEVERE, e.getLocalizedMessage());
        }
        try {
            if (this.shpFiles.isLocal() && this.needsGeneration(ShpFileType.FIX)) {
                this.generateFidIndex();
            }
        }
        catch (IOException e) {
            ShapefileDataStoreFactory.LOGGER.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    public final void createSpatialIndex() throws IOException {
        this.buildQuadTree(this.maxDepth);
    }

    protected void finalize() throws Throwable {
        if (this.rtree != null) {
            try {
                this.rtree.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.severe("org.geotools.data.shapefile.indexed.IndexedShapeFileDataStore#finalize(): Error closing rtree. " + e.getLocalizedMessage());
            }
        }
    }

    @Override
    protected Filter getUnsupportedFilter(String typeName, Filter filter) {
        if (filter instanceof Id && this.isLocal() && this.shpFiles.exists(ShpFileType.FIX)) {
            return Filter.INCLUDE;
        }
        return filter;
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        if (transaction == Transaction.AUTO_COMMIT) {
            return super.getFeatureWriterAppend(typeName, transaction);
        }
        FeatureWriter writer = this.state(transaction).writer(typeName, (Filter)Filter.EXCLUDE);
        if (this.getLockingManager() != null) {
            writer = ((InProcessLockingManager)this.getLockingManager()).checkedWriter(writer, transaction);
        }
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TransactionStateDiff state(Transaction transaction) {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            TransactionStateDiff state = (TransactionStateDiff)transaction.getState((Object)this);
            if (state == null) {
                state = new TransactionStateDiff(this);
                transaction.putState((Object)this, (Transaction.State)state);
            }
            return state;
        }
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName, Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            return new EmptyFeatureReader((FeatureType)this.getSchema());
        }
        String[] propertyNames = query.getPropertyNames() == null ? new String[]{} : query.getPropertyNames();
        String defaultGeomName = this.schema.getGeometryDescriptor().getLocalName();
        FilterAttributeExtractor fae = new FilterAttributeExtractor();
        query.getFilter().accept((FilterVisitor)fae, null);
        HashSet<String> attributes = new HashSet<String>(Arrays.asList(propertyNames));
        attributes.addAll(fae.getAttributeNameSet());
        SimpleFeatureType newSchema = this.schema;
        boolean readDbf = true;
        boolean readGeometry = true;
        propertyNames = attributes.toArray(new String[attributes.size()]);
        try {
            if (query.getPropertyNames() != null && propertyNames.length == 1 && propertyNames[0].equals(defaultGeomName)) {
                readDbf = false;
                newSchema = DataUtilities.createSubType((SimpleFeatureType)this.schema, (String[])propertyNames);
            } else if (query.getPropertyNames() != null && propertyNames.length == 0) {
                readDbf = false;
                readGeometry = false;
                newSchema = DataUtilities.createSubType((SimpleFeatureType)this.schema, (String[])propertyNames);
            }
            return this.createFeatureReader(typeName, this.getAttributesReader(readDbf, readGeometry, query.getFilter()), newSchema);
        }
        catch (SchemaException se) {
            throw new DataSourceException("Error creating schema", (Throwable)se);
        }
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> createFeatureReader(String typeName, IndexedShapefileAttributeReader r, SimpleFeatureType readerSchema) throws SchemaException, IOException {
        Object fidReader = !this.indexUseable(ShpFileType.FIX) ? new ShapeFIDReader(this.getCurrentTypeName(), r) : new IndexedFidReader(this.shpFiles, r);
        return new FIDFeatureReader((AttributeReader)r, (FIDReader)fidReader, readerSchema);
    }

    public void generateFidIndex() throws IOException {
        FidIndexer.generate(this.shpFiles);
    }

    protected IndexedShapefileAttributeReader getAttributesReader(boolean readDbf, boolean readGeometry, Filter filter) throws IOException {
        ReferencedEnvelope bbox = new ReferencedEnvelope();
        CloseableCollection<Data> goodRecs = null;
        if (filter instanceof Id && this.shpFiles.isLocal() && this.shpFiles.exists(ShpFileType.FIX)) {
            Id fidFilter = (Id)filter;
            Set fids = fidFilter.getIDs();
            goodRecs = this.queryFidIndex(fids);
        } else {
            if (filter != null && (bbox = (Envelope)filter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, (Object)bbox)) == null) {
                bbox = new ReferencedEnvelope();
            }
            if (!bbox.isNull() && this.useIndex) {
                try {
                    goodRecs = this.queryQuadTree((Envelope)bbox);
                }
                catch (TreeException e) {
                    throw new IOException("Error querying index: " + e.getMessage());
                }
            }
        }
        ArrayList<Object> atts = this.schema == null ? this.readAttributes() : this.schema.getAttributeDescriptors();
        IndexedDbaseFileReader dbfR = null;
        if (!readDbf) {
            LOGGER.fine("The DBF file won't be opened since no attributes will be read from it");
            atts = new ArrayList<AttributeDescriptor>(1);
            atts.add((AttributeDescriptor)this.schema.getGeometryDescriptor());
            if (!readGeometry) {
                atts = new ArrayList(1);
            }
        } else {
            dbfR = (IndexedDbaseFileReader)this.openDbfReader();
        }
        return new IndexedShapefileAttributeReader(atts, this.openShapeReader(), dbfR, goodRecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableCollection<Data> queryFidIndex(Set<String> idsSet) throws IOException {
        if (!this.indexUseable(ShpFileType.FIX)) {
            return null;
        }
        Object[] fids = idsSet.toArray(new String[idsSet.size()]);
        Arrays.sort(fids);
        CloseableArrayList records = new CloseableArrayList(fids.length);
        try (IndexedFidReader reader = new IndexedFidReader(this.shpFiles);
             IndexFile shx = this.openIndexFile();){
            DataDefinition def = new DataDefinition("US-ASCII");
            def.addField(Integer.class);
            def.addField(Long.class);
            for (Object fid : fids) {
                long recno = reader.findFid((String)fid);
                if (recno == -1L) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.finest("fid " + (String)fid + " not found in index, continuing with next queried fid...");
                    continue;
                }
                try {
                    Data data = new Data(def);
                    data.addValue((int)recno + 1);
                    data.addValue(shx.getOffsetInBytes((int)recno));
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("fid " + (String)fid + " found for record #" + data.getValue(0) + " at index file offset " + data.getValue(1));
                    }
                    records.add(data);
                }
                catch (Exception e) {
                    IOException exception = new IOException();
                    exception.initCause(e);
                    throw exception;
                }
            }
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexUseable(ShpFileType indexType) {
        if (this.isLocal()) {
            if (this.needsGeneration(indexType) || !this.shpFiles.exists(indexType)) {
                return false;
            }
        } else {
            ReadableByteChannel read = null;
            try {
                read = this.shpFiles.getReadChannel(indexType, this);
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (read != null) {
                    try {
                        read.close();
                    }
                    catch (IOException e) {
                        ShapefileDataStoreFactory.LOGGER.log(Level.WARNING, "could not close stream", e);
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean needsGeneration(ShpFileType indexType) {
        if (!this.isLocal()) {
            throw new IllegalStateException("This method only applies if the files are local and the file can be created");
        }
        URL indexURL = this.shpFiles.acquireRead(indexType, this);
        URL shpURL = this.shpFiles.acquireRead(ShpFileType.SHP, this);
        try {
            long shpLastModified;
            if (indexURL == null) {
                boolean bl = true;
                return bl;
            }
            if (!this.shpFiles.exists(ShpFileType.SHX) || !this.shpFiles.exists(ShpFileType.SHP)) {
                boolean bl = false;
                return bl;
            }
            File indexFile = URLs.urlToFile((URL)indexURL);
            File shpFile = URLs.urlToFile((URL)shpURL);
            long indexLastModified = indexFile.lastModified();
            boolean shpChangedMoreRecently = indexLastModified < (shpLastModified = shpFile.lastModified());
            boolean bl = !indexFile.exists() || shpChangedMoreRecently;
            return bl;
        }
        finally {
            if (shpURL != null) {
                this.shpFiles.unlockRead(shpURL, (FileReader)this);
            }
            if (indexURL != null) {
                this.shpFiles.unlockRead(indexURL, (FileReader)this);
            }
        }
    }

    public boolean isIndexed() {
        if (this.shpFiles.isLocal()) {
            return true;
        }
        return !this.needsGeneration(ShpFileType.FIX) && !this.needsGeneration(this.treeType.shpFileType);
    }

    private CloseableCollection<Data> queryQuadTree(Envelope bbox) throws DataSourceException, IOException, TreeException {
        CloseableCollection<Data> tmp = null;
        try {
            QuadTree quadTree = this.openQuadTree();
            if (!(quadTree == null || bbox.contains(quadTree.getRoot().getBounds()) || (tmp = quadTree.search(bbox)) != null && tmp.isEmpty())) {
                return tmp;
            }
            if (quadTree != null) {
                quadTree.close();
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error querying QuadTree", (Throwable)e);
        }
        return null;
    }

    @Override
    protected DbaseFileReader openDbfReader() throws IOException {
        if (this.shpFiles.get(ShpFileType.DBF) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.DBF)) {
            return null;
        }
        return new IndexedDbaseFileReader(this.shpFiles, false, this.dbfCharset);
    }

    protected QuadTree openQuadTree() throws StoreException {
        if (!this.isLocal()) {
            return null;
        }
        URL treeURL = this.shpFiles.acquireRead(ShpFileType.QIX, this);
        try {
            File treeFile = URLs.urlToFile((URL)treeURL);
            if (!treeFile.exists() || treeFile.length() == 0L) {
                this.treeType = IndexType.NONE;
                QuadTree quadTree = null;
                return quadTree;
            }
            FileSystemIndexStore store = new FileSystemIndexStore(treeFile);
            QuadTree quadTree = store.load(this.openIndexFile());
            return quadTree;
        }
        finally {
            this.shpFiles.unlockRead(treeURL, (FileReader)this);
        }
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String typeName, Transaction transaction) throws IOException {
        FeatureReader<SimpleFeatureType, SimpleFeature> featureReader;
        this.typeCheck(typeName);
        IndexedShapefileAttributeReader attReader = this.getAttributesReader(true, true, null);
        try {
            SimpleFeatureType schema = this.getSchema();
            if (schema == null) {
                throw new IOException("To create a shapefile, you must first call createSchema()");
            }
            featureReader = this.createFeatureReader(typeName, attReader, schema);
        }
        catch (Exception e) {
            featureReader = new FeatureReader<SimpleFeatureType, SimpleFeature>((FeatureType)this.schema);
        }
        return new IndexedShapefileFeatureWriter(typeName, this.shpFiles, attReader, featureReader, this, this.dbfCharset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        CloseableCollection<Data> recordsFound;
        ReferencedEnvelope ret = null;
        HashSet<Data> records = new HashSet<Data>();
        Filter filter = query.getFilter();
        if (filter == Filter.INCLUDE || query == Query.ALL) {
            return this.getBounds();
        }
        Set fids = (Set)filter.accept((FilterVisitor)IdCollectorFilterVisitor.ID_COLLECTOR, new HashSet());
        if (!fids.isEmpty() && (recordsFound = this.queryFidIndex(fids)) != null) {
            records.addAll(recordsFound);
        }
        if (records.isEmpty()) {
            return null;
        }
        try (ShapefileReader reader = new ShapefileReader(this.shpFiles, false, false);){
            ret = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
            for (Data data : records) {
                reader.goTo(((Long)data.getValue(1)).intValue());
                ShapefileReader.Record record = reader.nextRecord();
                ret.expandToInclude(new Envelope(record.minX, record.maxX, record.minY, record.maxY));
            }
            ReferencedEnvelope referencedEnvelope = ret;
            return referencedEnvelope;
        }
    }

    public void buildQuadTree(int maxDepth) throws TreeException {
        if (this.isLocal()) {
            LOGGER.fine("Creating spatial index for " + this.shpFiles.get(ShpFileType.SHP));
            ShapeFileIndexer indexer = new ShapeFileIndexer();
            indexer.setIdxType(IndexType.QIX);
            indexer.setShapeFileName(this.shpFiles);
            indexer.setMax(maxDepth);
            try {
                indexer.index(false, (ProgressListener)new NullProgressListener());
            }
            catch (MalformedURLException e) {
                throw new TreeException(e);
            }
            catch (LockTimeoutException e) {
                throw new TreeException(e);
            }
            catch (Exception e) {
                if (e instanceof TreeException) {
                    throw (TreeException)e;
                }
                throw new TreeException(e);
            }
        }
    }

    public boolean isMemoryMapped() {
        return this.useMemoryMappedBuffer;
    }

    @Override
    public String id() {
        return this.getClass().getName() + ": " + this.getCurrentTypeName();
    }
}

