/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile.dbf;

import de.riwagis.geotools.data.shapefile.FileReader;
import de.riwagis.geotools.data.shapefile.ShpFileType;
import de.riwagis.geotools.data.shapefile.ShpFiles;
import de.riwagis.geotools.data.shapefile.StreamLogging;
import de.riwagis.geotools.data.shapefile.dbf.DbaseFileHeader;
import de.riwagis.geotools.data.shapefile.dbf.DbaseFileWriter;
import de.riwagis.geotools.util.NIOUtilities;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbaseFileReader
implements FileReader {
    private static final Logger LOG = LoggerFactory.getLogger(DbaseFileReader.class);
    DbaseFileHeader header;
    ByteBuffer buffer;
    byte[] record = null;
    ReadableByteChannel channel;
    Charset charset;
    CharsetDecoder decoder;
    char[] fieldTypes;
    int[] fieldLengths;
    int cnt = 1;
    Row row;
    protected boolean useMemoryMappedBuffer;
    protected boolean randomAccessEnabled;
    protected int currentOffset = 0;
    private StreamLogging streamLogger = new StreamLogging("Dbase File Reader");
    private Charset stringCharset;

    public DbaseFileReader(ShpFiles shapefileFiles, boolean useMemoryMappedBuffer, Charset charset) throws IOException {
        ReadableByteChannel dbfChannel = shapefileFiles.getReadChannel(ShpFileType.DBF, this);
        this.init(dbfChannel, useMemoryMappedBuffer, charset);
    }

    public DbaseFileReader(ReadableByteChannel readChannel, boolean useMemoryMappedBuffer, Charset charset) throws IOException {
        this.init(readChannel, useMemoryMappedBuffer, charset);
    }

    private void init(ReadableByteChannel dbfChannel, boolean useMemoryMappedBuffer, Charset charset) throws IOException {
        this.channel = dbfChannel;
        this.stringCharset = charset;
        this.charset = charset;
        this.useMemoryMappedBuffer = useMemoryMappedBuffer;
        this.randomAccessEnabled = this.channel instanceof FileChannel;
        this.streamLogger.open();
        this.header = new DbaseFileHeader(this.stringCharset);
        this.header.readHeader(this.channel);
        if (this.channel instanceof FileChannel && this.useMemoryMappedBuffer) {
            FileChannel fc = (FileChannel)this.channel;
            this.buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            this.buffer.position((int)fc.position());
            this.currentOffset = 0;
        } else {
            this.useMemoryMappedBuffer = false;
            int size = 8192;
            size = this.header.getRecordLength() > size ? this.header.getRecordLength() : size;
            this.buffer = ByteBuffer.allocateDirect(size);
            this.fill(this.buffer, this.channel);
            this.buffer.flip();
            this.currentOffset = this.header.getHeaderLength();
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.fieldTypes = new char[this.header.getNumFields()];
        this.fieldLengths = new int[this.header.getNumFields()];
        int ii = this.header.getNumFields();
        for (int i = 0; i < ii; ++i) {
            this.fieldTypes[i] = this.header.getFieldType(i);
            this.fieldLengths[i] = this.header.getFieldLength(i);
        }
        this.record = new byte[this.header.getRecordLength() - 1];
        this.decoder = charset.newDecoder();
        this.row = new Row();
    }

    protected int fill(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        int r = buffer.remaining();
        while (buffer.remaining() > 0 && r != -1) {
            r = channel.read(buffer);
        }
        if (r == -1) {
            buffer.limit(buffer.position());
        }
        return r;
    }

    private void bufferCheck() throws IOException {
        if (!this.buffer.isReadOnly() && this.buffer.remaining() < this.header.getRecordLength()) {
            this.currentOffset += this.buffer.position();
            this.buffer.compact();
            this.fill(this.buffer, this.channel);
            this.buffer.position(0);
        }
    }

    private int getOffset(int column) {
        int offset = 0;
        int ii = column;
        for (int i = 0; i < ii; ++i) {
            offset += this.fieldLengths[i];
        }
        return offset;
    }

    public DbaseFileHeader getHeader() {
        return this.header;
    }

    public void close() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
        }
        if (this.buffer instanceof MappedByteBuffer) {
            NIOUtilities.clean(this.buffer);
        }
        this.buffer = null;
        this.channel = null;
        this.decoder = null;
        this.header = null;
        this.row = null;
    }

    public boolean hasNext() {
        return this.cnt < this.header.getNumRecords() + 1;
    }

    public Object[] readEntry() throws IOException {
        return this.readEntry(new Object[this.header.getNumFields()]);
    }

    public Row readRow() throws IOException {
        this.read();
        return this.row;
    }

    public void skip() throws IOException {
        boolean foundRecord = false;
        while (!foundRecord) {
            this.bufferCheck();
            char tempDeleted = (char)this.buffer.get();
            this.buffer.position(this.buffer.position() + this.header.getRecordLength() - 1);
            if (tempDeleted == '*') continue;
            foundRecord = true;
        }
    }

    public Object[] readEntry(Object[] entry, int offset) throws IOException {
        if (entry.length - offset < this.header.getNumFields()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.read();
        int numFields = this.header.getNumFields();
        int fieldOffset = 0;
        for (int j = 0; j < numFields; ++j) {
            entry[j + offset] = this.readObject(fieldOffset, j);
            fieldOffset += this.fieldLengths[j];
        }
        return entry;
    }

    public Object readField(int fieldNum) throws IOException {
        int fieldOffset = 0;
        for (int j = 0; j < fieldNum; ++j) {
            fieldOffset += this.fieldLengths[j];
        }
        return this.readObject(fieldOffset, fieldNum);
    }

    public void transferTo(DbaseFileWriter writer) throws IOException {
        this.bufferCheck();
        this.buffer.limit(this.buffer.position() + this.header.getRecordLength());
        writer.channel.write(this.buffer);
        this.buffer.limit(this.buffer.capacity());
        ++this.cnt;
    }

    public void read() throws IOException {
        boolean foundRecord = false;
        while (!foundRecord) {
            this.bufferCheck();
            char deleted = (char)this.buffer.get();
            if (deleted == '*') continue;
            int pos = this.buffer.position();
            this.buffer.get(this.record);
            this.buffer.limit(this.buffer.capacity());
            foundRecord = true;
        }
        ++this.cnt;
    }

    public Object[] readEntry(Object[] entry) throws IOException {
        return this.readEntry(entry, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readObject(int fieldOffset, int fieldNum) throws IOException {
        char type = this.fieldTypes[fieldNum];
        int fieldLen = this.fieldLengths[fieldNum];
        String object = null;
        byte[] dataset = Arrays.copyOfRange(this.record, fieldOffset, fieldOffset + fieldLen);
        String strData = new String(dataset, this.charset);
        if (fieldLen <= 0) return object;
        switch (type) {
            case 'L': 
            case 'l': {
                switch (strData.charAt(0)) {
                    case 't': {
                        return Boolean.TRUE;
                    }
                    case 'T': {
                        return Boolean.TRUE;
                    }
                    case 'Y': {
                        return Boolean.TRUE;
                    }
                    case 'y': {
                        return Boolean.TRUE;
                    }
                    case '+': {
                        return Boolean.TRUE;
                    }
                    case 'f': {
                        return Boolean.FALSE;
                    }
                    case 'F': {
                        return Boolean.FALSE;
                    }
                    case 'N': {
                        return Boolean.FALSE;
                    }
                    case 'n': {
                        return Boolean.FALSE;
                    }
                    case ' ': {
                        return Boolean.FALSE;
                    }
                    case '-': {
                        return Boolean.FALSE;
                    }
                }
                LOG.error("Unknown logical value : '" + strData.charAt(0) + "'");
                return Boolean.FALSE;
            }
            case 'C': 
            case 'c': {
                return strData.trim();
            }
            case 'D': 
            case 'd': {
                try {
                    if (strData == null) return null;
                    if (strData.trim().length() == 0) {
                        return null;
                    }
                    int tempYear = Integer.parseInt(strData.substring(0, 4));
                    int tempMonth = Integer.parseInt(strData.substring(4, 6)) - 1;
                    int tempDay = Integer.parseInt(strData.substring(6, 8));
                    Calendar cal = Calendar.getInstance();
                    cal.clear();
                    cal.set(1, tempYear);
                    cal.set(2, tempMonth);
                    cal.set(5, tempDay);
                    return cal.getTime();
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("Error reading dbf at formatting '" + strData + "' to date.", (Throwable)nfe);
                    return null;
                }
            }
            case 'N': 
            case 'n': {
                try {
                    if (strData == null) return null;
                    if (strData.trim().length() == 0) {
                        return null;
                    }
                    Class clazz = this.header.getFieldClass(fieldNum);
                    if (clazz == Integer.class) {
                        try {
                            return new Integer(strData.trim());
                        }
                        catch (NumberFormatException e) {
                            return new Long(strData.trim());
                        }
                    }
                    if (clazz == Long.class) {
                        return new Long(strData.trim());
                    }
                }
                catch (NumberFormatException e) {
                    LOG.warn("Error reading dbf at formatting '" + strData + "' to number.", (Throwable)e);
                    return null;
                }
            }
            case 'F': 
            case 'f': {
                try {
                    if (strData == null) return null;
                    if (strData.trim().length() != 0) return new Double(strData.trim());
                    return null;
                }
                catch (NumberFormatException e) {
                    LOG.warn("Error reading dbf at formatting '" + strData + "' to floating point number.", (Throwable)e);
                    return null;
                }
            }
            default: {
                throw new IOException("Invalid field type : " + type);
            }
        }
    }

    private final String extractNumberString(CharBuffer charBuffer2, int fieldOffset, int fieldLen) {
        String thing = charBuffer2.subSequence(fieldOffset, fieldOffset + fieldLen).toString().trim();
        return thing;
    }

    public static void main(String[] args) throws Exception {
        DbaseFileReader reader = new DbaseFileReader(new ShpFiles(args[0]), false, Charset.forName("ISO-8859-1"));
        System.out.println(reader.getHeader());
        int r = 0;
        while (reader.hasNext()) {
            System.out.println(++r + "," + Arrays.asList(reader.readEntry()));
        }
        reader.close();
    }

    @Override
    public String id() {
        return this.getClass().getName();
    }

    public final class Row {
        public Object read(int column) throws IOException {
            int offset = DbaseFileReader.this.getOffset(column);
            return DbaseFileReader.this.readObject(offset, column);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer("DBF Row - ");
            for (int i = 0; i < DbaseFileReader.this.header.getNumFields(); ++i) {
                ret.append(DbaseFileReader.this.header.getFieldName(i)).append(": \"");
                try {
                    ret.append(this.read(i));
                }
                catch (IOException ioe) {
                    ret.append(ioe.getMessage());
                }
                ret.append("\" ");
            }
            return ret.toString();
        }
    }
}

