/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile.cpg;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.Iterator;
import java.util.Map;

public class DBaseCharsetProvider
extends CharsetProvider {
    private final Map<String, Charset> charsetAliases = Map.of("ansi", new WrappedCharset(Charset.forName("Cp1252")));

    @Override
    public Iterator<Charset> charsets() {
        return this.charsetAliases.values().iterator();
    }

    @Override
    public Charset charsetForName(String charsetName) {
        if (charsetName == null) {
            return null;
        }
        String lookupKey = charsetName.trim().toLowerCase();
        Charset charset = this.charsetAliases.get(lookupKey);
        if (charset != null) {
            return charset;
        }
        return this.tryMappingToSystemCharset(lookupKey);
    }

    private Charset tryMappingToSystemCharset(String lookupKey) {
        try {
            int charsetNumber = Integer.parseInt(lookupKey);
            Charset ibmCharset = this.tryCharset("ibm" + charsetNumber);
            if (ibmCharset != null) {
                return ibmCharset;
            }
            return this.tryCharset("cp" + charsetNumber);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private Charset tryCharset(String charset) {
        try {
            return Charset.forName(charset);
        }
        catch (UnsupportedCharsetException e) {
            return null;
        }
    }

    private static class WrappedCharset
    extends Charset {
        private final Charset wrappedCharset;

        public WrappedCharset(Charset wrappedCharset) {
            super(wrappedCharset.name(), wrappedCharset.aliases().toArray(new String[0]));
            this.wrappedCharset = wrappedCharset;
        }

        @Override
        public boolean contains(Charset cs) {
            return this.wrappedCharset.contains(cs);
        }

        @Override
        public CharsetDecoder newDecoder() {
            return this.wrappedCharset.newDecoder();
        }

        @Override
        public CharsetEncoder newEncoder() {
            return this.wrappedCharset.newEncoder();
        }
    }
}

