/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile.cpg;

import de.riwagis.geotools.data.shapefile.StreamLogging;
import de.riwagis.geotools.util.NIOUtilities;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;

public class CpgFileWriter {
    WritableByteChannel channel;
    private ByteBuffer buffer;
    private final StreamLogging streamLogger = new StreamLogging("CPG File Writer");
    private final Charset charset;

    public CpgFileWriter(WritableByteChannel out, Charset charset) throws IOException {
        this.channel = out;
        this.charset = charset == null ? Charset.defaultCharset() : charset;
        this.streamLogger.open();
        this.init();
    }

    private void init() throws IOException {
        this.buffer = ByteBuffer.allocateDirect(this.charset.name().length());
    }

    public void write() throws IOException {
        this.buffer.put(this.charset.name().getBytes(this.charset.name()));
        this.buffer.position(0);
        int r = this.buffer.remaining();
        while ((r -= this.channel.write(this.buffer)) > 0) {
        }
    }

    public void close() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
        }
        if (this.buffer instanceof MappedByteBuffer) {
            NIOUtilities.clean(this.buffer);
        }
        this.buffer = null;
        this.channel = null;
    }
}

