/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile;

import java.util.Date;
import org.geotools.data.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShapefileUtilities {
    private static final Logger LOG = LoggerFactory.getLogger(ShapefileUtilities.class);

    private ShapefileUtilities() {
    }

    public static Object forAttribute(Object attributeValue, Class<?> colType) {
        Object resValue;
        if (colType == Integer.class) {
            resValue = attributeValue;
        } else if (colType == Short.class || colType == Byte.class) {
            resValue = ((Number)attributeValue).intValue();
        } else if (colType == Double.class) {
            resValue = attributeValue;
        } else if (colType == Float.class) {
            resValue = ((Number)attributeValue).doubleValue();
        } else if (Number.class.isAssignableFrom(colType)) {
            resValue = attributeValue;
        } else if (colType == String.class) {
            resValue = attributeValue == null ? attributeValue : attributeValue.toString();
        } else if (colType == Boolean.class) {
            resValue = attributeValue;
        } else if (Date.class.isAssignableFrom(colType)) {
            resValue = attributeValue;
        } else {
            if (colType != null) {
                throw new RuntimeException(String.format("Cannot convert '%s'", colType.getName()));
            }
            throw new RuntimeException("Null Class for conversion");
        }
        return resValue;
    }

    public static void closeQuietly(Transaction t) {
        try {
            if (t != null) {
                t.close();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("transaction (%s) finished", t));
                }
            }
        }
        catch (Throwable ioex) {
            LOG.warn("Error closing transaction", ioex);
        }
    }

    public static void rollbackQuietly(Transaction t) {
        try {
            if (t != null) {
                t.rollback();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("transaction (%s) rolled back", t));
                }
            }
        }
        catch (Throwable e2) {
            LOG.warn("Error rolling back transaction", e2);
        }
    }
}

