/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile;

import de.riwagis.geotools.data.shapefile.ShapefileDataStore;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.DataSourceException;
import org.geotools.data.ResourceInfo;
import org.geotools.feature.FeatureTypes;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapefileURLResourceInfo
implements ResourceInfo {
    private final ShapefileDataStore shapefile;

    public ShapefileURLResourceInfo(ShapefileDataStore shapefile) {
        this.shapefile = shapefile;
    }

    public ReferencedEnvelope getBounds() {
        try {
            return this.shapefile.getBounds();
        }
        catch (DataSourceException e) {
            return new ReferencedEnvelope(this.getCRS());
        }
    }

    public CoordinateReferenceSystem getCRS() {
        return this.shapefile.schema.getCoordinateReferenceSystem();
    }

    public String getDescription() {
        return "Contents of shapefile";
    }

    public Set<String> getKeywords() {
        HashSet<String> words = new HashSet<String>();
        words.add(this.shapefile.getCurrentTypeName());
        words.add("features");
        return words;
    }

    public String getName() {
        return this.shapefile.getCurrentTypeName();
    }

    public URI getSchema() {
        return FeatureTypes.DEFAULT_NAMESPACE;
    }

    public String getTitle() {
        return this.shapefile.getCurrentTypeName();
    }
}

