/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile;

import de.riwagis.geotools.data.shapefile.ShapefileDataStore;
import de.riwagis.geotools.data.shapefile.ShpFileType;
import de.riwagis.geotools.data.shapefile.ShpFiles;
import de.riwagis.geotools.data.shapefile.indexed.IndexType;
import de.riwagis.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class ShapefileDataStoreFactory
implements DataStoreFactorySpi {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.shapefile");
    public static final Map<RenderingHints.Key, ?> SHAPEFILE_RENDERINGHINTS = Collections.unmodifiableMap(new HashMap());
    public static final DataAccessFactory.Param URLP = new DataAccessFactory.Param("url", URL.class, "url to a .shp file");
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false);
    public static final DataAccessFactory.Param MEMORY_MAPPED = new DataAccessFactory.Param("memory mapped buffer", Boolean.class, "enable/disable the use of memory-mapped io", false);
    public static final DataAccessFactory.Param CREATE_SPATIAL_INDEX = new DataAccessFactory.Param("create spatial index", Boolean.class, "enable/disable the automatic creation of spatial index", false);
    public static final DataAccessFactory.Param DBFCHARSET = new DataAccessFactory.Param("charset", Charset.class, "character used to decode strings from the DBF file", false, Charset.forName("ISO-8859-1")){

        public Object parse(String text) throws IOException {
            return Charset.forName(text);
        }

        public String text(Object value) {
            return ((Charset)value).name();
        }
    };
    private static final Map<Map<String, ?>, DataStore> liveStores = Collections.synchronizedMap(new HashMap());

    public boolean canProcess(Map<String, ?> params) {
        boolean accept = false;
        if (params.containsKey(ShapefileDataStoreFactory.URLP.key)) {
            try {
                URL url = (URL)URLP.lookUp(params);
                accept = this.canProcess(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return accept;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShapefileDataStore createDataStore(Map<String, ?> params) throws IOException {
        DataStore ds = null;
        Map<Map<String, ?>, DataStore> map = liveStores;
        synchronized (map) {
            if (!liveStores.containsKey(params)) {
                URL url = null;
                try {
                    ds = this.createDataStoreInstance(params);
                    liveStores.put(params, ds);
                }
                catch (MalformedURLException mue) {
                    throw new DataSourceException("Unable to attatch datastore to " + url, (Throwable)mue);
                }
            } else {
                ds = liveStores.get(params);
            }
        }
        return (ShapefileDataStore)ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        DataStore ds = null;
        Map<Map<String, ?>, DataStore> map = liveStores;
        synchronized (map) {
            if (!liveStores.containsKey(params)) {
                URL url = null;
                try {
                    ds = this.createNewShapefile(params);
                    liveStores.put(params, ds);
                }
                catch (MalformedURLException mue) {
                    throw new DataSourceException("Unable to attatch datastore to " + url, (Throwable)mue);
                }
            } else {
                ds = liveStores.get(params);
            }
        }
        return ds;
    }

    DataStore createNewShapefile(Map<String, ?> params) throws IOException {
        ShpFiles shpFiles;
        boolean isLocal;
        URL url = (URL)URLP.lookUp(params);
        Boolean isMemoryMapped = (Boolean)MEMORY_MAPPED.lookUp(params);
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        Charset dbfCharset = (Charset)DBFCHARSET.lookUp(params);
        Boolean isCreateSpatialIndex = (Boolean)CREATE_SPATIAL_INDEX.lookUp(params);
        if (isCreateSpatialIndex == null) {
            isCreateSpatialIndex = Boolean.TRUE;
        }
        if (dbfCharset == null) {
            dbfCharset = Charset.forName("ISO-8859-1");
        }
        if (isMemoryMapped == null) {
            isMemoryMapped = Boolean.FALSE;
        }
        if (!(isLocal = (shpFiles = new ShpFiles(url)).isLocal()) || shpFiles.exists(ShpFileType.SHP)) {
            LOGGER.log(Level.WARNING, "File already exists: {0}", shpFiles.get(ShpFileType.SHP));
        }
        boolean useMemoryMappedBuffer = isLocal && isMemoryMapped != false;
        boolean createIndex = isCreateSpatialIndex != false && isLocal;
        try {
            if (createIndex) {
                return new IndexedShapefileDataStore(url, namespace, useMemoryMappedBuffer, true, IndexType.QIX, dbfCharset);
            }
            return new ShapefileDataStore(url, namespace, useMemoryMappedBuffer, dbfCharset);
        }
        catch (MalformedURLException mue) {
            throw new DataSourceException("Url for shapefile malformed: " + url, (Throwable)mue);
        }
    }

    DataStore createDataStoreInstance(Map<String, ?> params) throws IOException {
        ShpFiles shpFiles;
        boolean isLocal;
        URL url = (URL)URLP.lookUp(params);
        Boolean isMemoryMapped = (Boolean)MEMORY_MAPPED.lookUp(params);
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        Charset dbfCharset = (Charset)DBFCHARSET.lookUp(params);
        Boolean isCreateSpatialIndex = (Boolean)CREATE_SPATIAL_INDEX.lookUp(params);
        if (isCreateSpatialIndex == null) {
            isCreateSpatialIndex = Boolean.TRUE;
        }
        if (dbfCharset == null) {
            dbfCharset = Charset.forName("ISO-8859-1");
        }
        if (isMemoryMapped == null) {
            isMemoryMapped = Boolean.FALSE;
        }
        if ((isLocal = (shpFiles = new ShpFiles(url)).isLocal()) && !shpFiles.exists(ShpFileType.SHP)) {
            throw new FileNotFoundException("Shapefile not found:" + shpFiles.get(ShpFileType.SHP));
        }
        boolean useMemoryMappedBuffer = isLocal && shpFiles.exists(ShpFileType.SHP) && isMemoryMapped != false;
        boolean createIndex = isLocal && isCreateSpatialIndex != false;
        IndexType treeIndex = IndexType.NONE;
        if (isLocal) {
            if (createIndex) {
                treeIndex = IndexType.QIX;
            } else if (shpFiles.exists(ShpFileType.QIX)) {
                treeIndex = IndexType.QIX;
            }
        }
        try {
            if (createIndex) {
                return new IndexedShapefileDataStore(url, namespace, useMemoryMappedBuffer, createIndex, IndexType.QIX, dbfCharset);
            }
            if (treeIndex != IndexType.NONE) {
                return new IndexedShapefileDataStore(url, namespace, useMemoryMappedBuffer, false, treeIndex, dbfCharset);
            }
            return new ShapefileDataStore(url, namespace, useMemoryMappedBuffer, dbfCharset);
        }
        catch (MalformedURLException mue) {
            throw new DataSourceException("Url for shapefile malformed: " + url, (Throwable)mue);
        }
    }

    public String getDisplayName() {
        return "Shapefile";
    }

    public String getDescription() {
        return "ESRI(tm) Shapefiles (*.shp)";
    }

    public boolean isAvailable() {
        try {
            ShapefileDataStore.class.getName();
            IndexedShapefileDataStore.class.getName();
            Geometry.class.getName();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URLP, NAMESPACEP, CREATE_SPATIAL_INDEX, DBFCHARSET, MEMORY_MAPPED};
    }

    public String[] getFileExtensions() {
        return new String[]{".shp"};
    }

    public boolean canProcess(URL f) {
        return f.getFile().toUpperCase().endsWith("SHP");
    }

    public DataStore createDataStore(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(ShapefileDataStoreFactory.URLP.key, url);
        boolean isLocal = url.getProtocol().equalsIgnoreCase("file");
        if (isLocal && !new File(url.getFile()).exists()) {
            return this.createNewDataStore(params);
        }
        return this.createDataStore(params);
    }

    public DataStore createDataStore(URL url, boolean memorymapped) throws IOException {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(ShapefileDataStoreFactory.URLP.key, url);
        params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, Boolean.valueOf(memorymapped));
        return this.createDataStore(params);
    }

    public String getTypeName(URL url) throws IOException {
        DataStore ds = this.createDataStore(url);
        String[] names = ds.getTypeNames();
        return names == null || names.length == 0 ? null : names[0];
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return SHAPEFILE_RENDERINGHINTS;
    }
}

