/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.shapefile;

import de.riwagis.geotools.data.AbstractAttributeIO;
import de.riwagis.geotools.data.shapefile.dbf.DbaseFileReader;
import de.riwagis.geotools.data.shapefile.shp.ShapefileReader;
import java.io.IOException;
import java.util.List;
import org.geotools.data.AttributeReader;
import org.opengis.feature.type.AttributeDescriptor;

public class ShapefileAttributeReader
extends AbstractAttributeIO
implements AttributeReader {
    protected ShapefileReader shp;
    protected DbaseFileReader dbf;
    protected DbaseFileReader.Row row;
    protected ShapefileReader.Record record;
    int cnt;

    public ShapefileAttributeReader(List<AttributeDescriptor> atts, ShapefileReader shp, DbaseFileReader dbf) {
        this(atts.toArray(new AttributeDescriptor[atts.size()]), shp, dbf);
    }

    public ShapefileAttributeReader(AttributeDescriptor[] atts, ShapefileReader shp, DbaseFileReader dbf) {
        super(atts);
        this.shp = shp;
        this.dbf = dbf;
    }

    public void close() throws IOException {
        try {
            if (this.shp != null) {
                this.shp.close();
            }
            if (this.dbf != null) {
                this.dbf.close();
            }
        }
        finally {
            this.row = null;
            this.record = null;
            this.shp = null;
            this.dbf = null;
        }
    }

    public boolean hasNext() throws IOException {
        int n;
        int n2 = n = this.shp.hasNext() ? 1 : 0;
        if (this.dbf != null) {
            n += this.dbf.hasNext() ? 2 : 0;
        }
        if (n == 3 || n == 1 && this.dbf == null) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        throw new IOException((n == 1 ? "Shp" : "Dbf") + " has extra record");
    }

    public void next() throws IOException {
        this.record = this.shp.nextRecord();
        if (this.dbf != null) {
            this.row = this.dbf.readRow();
        }
    }

    public Object read(int param) throws IOException, ArrayIndexOutOfBoundsException {
        switch (param) {
            case 0: {
                return this.record.shape();
            }
        }
        if (this.row != null) {
            return this.row.read(param - 1);
        }
        return null;
    }
}

