/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv.filter.legacyxml;

import de.riwagis.geotools.data.riwasrv.filter.FilterEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.geotools.filter.v1_0.OGC;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyXMLFilterEncoder
implements FilterEncoder {
    private static final Logger log = LoggerFactory.getLogger(LegacyXMLFilterEncoder.class);
    static final String FLTR_EXCLUDE = "EXCLUDE";
    static final String FLTR_FILTER = "FILTER";
    static final String FLTR_INCLUDE = "INCLUDE";
    static final String FLTR_SPECIAL = "SPECIAL";
    static final String FLTR_ST_AND = "AND";
    static final String FLTR_ST_NOT = "NOT";
    static final String FLTR_ST_OR = "OR";
    private static final ThreadLocal<SAXBuilder> saxBuilder = ThreadLocal.withInitial(() -> new SAXBuilder());

    @Override
    public Object encode(Filter filter) {
        log.debug("Encoding XML Filter {}", (Object)filter);
        Element root = new Element("root");
        this.addFilter(root, filter);
        Document doc = new Document(((Element)root.getChildren().get(0)).clone());
        return this.buildXMLText(doc);
    }

    private void addFilter(Element elem, Filter filter) throws IOException, JDOMException {
        if (filter == Filter.INCLUDE) {
            this.addSpecialElement(elem, FLTR_INCLUDE);
        } else if (filter == Filter.EXCLUDE) {
            this.addSpecialElement(elem, FLTR_EXCLUDE);
        } else if (filter instanceof Id) {
            StringBuilder sbId = new StringBuilder();
            sbId.append("ID");
            for (Object currID : ((Id)filter).getIDs()) {
                sbId.append("|").append(currID.toString());
            }
            this.addSpecialElement(elem, sbId.toString());
        } else if (filter instanceof PropertyIsLike) {
            PropertyIsLike likeFilt = (PropertyIsLike)filter;
            String strLiteral = likeFilt.getLiteral();
            String strExp = likeFilt.getExpression().toString();
            StringBuilder sbLike = new StringBuilder();
            sbLike.append("LIKE");
            sbLike.append("|").append(strExp);
            sbLike.append("|").append(strLiteral);
            this.addSpecialElement(elem, sbLike.toString());
        } else if (filter instanceof And) {
            Element elemRoot = this.addSpecialElement(elem, FLTR_ST_AND);
            for (Filter tmpFilt : ((And)filter).getChildren()) {
                Element elemFilter = new Element(FLTR_FILTER);
                this.addFilter(elemFilter, tmpFilt);
                elemRoot.addContent((Content)elemFilter);
            }
        } else if (filter instanceof Or) {
            Element elemRoot = this.addSpecialElement(elem, FLTR_ST_OR);
            for (Filter tmpFilt : ((Or)filter).getChildren()) {
                Element elemFilter = new Element(FLTR_FILTER);
                this.addFilter(elemFilter, tmpFilt);
                elemRoot.addContent((Content)elemFilter);
            }
        } else if (filter instanceof Not) {
            Element elemRoot = this.addSpecialElement(elem, FLTR_ST_NOT);
            Filter tmpFilt = ((Not)filter).getFilter();
            Element elemFilter = new Element(FLTR_FILTER);
            this.addFilter(elemFilter, tmpFilt);
            elemRoot.addContent((Content)elemFilter);
        } else if (filter instanceof BBOX) {
            BBOX bboxFilter = (BBOX)filter;
            StringBuilder sbBBOX = new StringBuilder();
            sbBBOX.append("BBOX");
            sbBBOX.append("|").append(bboxFilter.getExpression1().toString());
            BoundingBox bounds = bboxFilter.getBounds();
            sbBBOX.append("|").append(bounds.getMinX());
            sbBBOX.append("|").append(bounds.getMinY());
            sbBBOX.append("|").append(bounds.getMaxX());
            sbBBOX.append("|").append(bounds.getMaxY());
            this.addSpecialElement(elem, sbBBOX.toString());
        } else {
            Charset charset = StandardCharsets.UTF_8;
            ByteArrayOutputStream xml = new ByteArrayOutputStream();
            Encoder enc = new Encoder((Configuration)new OGCConfiguration());
            enc.setEncoding(charset);
            enc.encode((Object)filter, OGC.Filter, (OutputStream)xml);
            String encodedXML = xml.toString(charset.name());
            Document jdomDoc = saxBuilder.get().build((Reader)new StringReader(encodedXML));
            elem.addContent((Content)jdomDoc.getRootElement().clone());
        }
    }

    private Element addSpecialElement(Element elem, String specialText) {
        Element elemRoot = new Element(FLTR_SPECIAL);
        elem.addContent((Content)elemRoot);
        elemRoot.setText(specialText);
        return elemRoot;
    }

    private String buildXMLText(Document doc) throws IOException {
        try (StringWriter sw = new StringWriter();){
            XMLOutputter out = new XMLOutputter();
            out.getFormat().setEncoding("UTF-8");
            out.output(doc, (Writer)sw);
            String string = ((Object)sw).toString();
            return string;
        }
    }
}

