/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv.filter.legacyxml;

import de.riwagis.geotools.data.riwasrv.filter.FilterDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.ObjectUtils;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class LegacyXMLFilterDecoder
implements FilterDecoder {
    private static final Logger log = LoggerFactory.getLogger(LegacyXMLFilterDecoder.class);
    private static final FilterFactory2 FILTER_FACTORY = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private static final ThreadLocal<SAXBuilder> threadBuilders = ThreadLocal.withInitial(SAXBuilder::new);
    private final Supplier<SAXBuilder> builderSupplier;
    private final Consumer<SAXBuilder> builderReleaser;
    private String typeName;

    public LegacyXMLFilterDecoder() {
        this.builderSupplier = () -> threadBuilders.get();
        this.builderReleaser = builder -> {};
    }

    public LegacyXMLFilterDecoder(Supplier<SAXBuilder> builderSupplier, Consumer<SAXBuilder> builderReleaser) {
        this.builderSupplier = builderSupplier;
        this.builderReleaser = builderReleaser;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter decode(Object rawFilter) {
        Objects.requireNonNull(this.typeName);
        log.debug("Decoding XML Filter {}", rawFilter);
        String strFilterText = (String)rawFilter;
        if (!ObjectUtils.toString((Object)strFilterText).trim().isEmpty()) {
            if (strFilterText.trim().startsWith("<")) {
                Document xmlDoc;
                ByteArrayInputStream bin = new ByteArrayInputStream(strFilterText.getBytes(StandardCharsets.UTF_8));
                SAXBuilder saxBuilder = this.builderSupplier.get();
                try {
                    xmlDoc = saxBuilder.build((InputStream)bin);
                }
                finally {
                    this.builderReleaser.accept(saxBuilder);
                }
                if (xmlDoc.getRootElement().getName().equals("SPECIAL")) {
                    return this.getSpecialFilter(this.typeName, xmlDoc.getRootElement());
                }
                return this.getXmlFilter(strFilterText);
            }
            return CQL.toFilter((String)strFilterText);
        }
        return null;
    }

    private Filter getSpecialFilter(String strTypeName, Element elemRoot) throws Exception {
        String strSpecialType = elemRoot.getText();
        if (strSpecialType.equals("EXCLUDE")) {
            return Filter.EXCLUDE;
        }
        if (strSpecialType.equals("INCLUDE")) {
            return Filter.INCLUDE;
        }
        if (strSpecialType.startsWith("ID|")) {
            String[] arrID = strSpecialType.split("\\|");
            HashSet<FeatureId> set = new HashSet<FeatureId>();
            for (int i = 1; i < arrID.length; ++i) {
                if (arrID[i].indexOf(46) == -1) {
                    arrID[i] = strTypeName + "." + arrID[i];
                }
                set.add(FILTER_FACTORY.featureId(arrID[i]));
            }
            return FILTER_FACTORY.id(set);
        }
        if (strSpecialType.startsWith("LIKE|")) {
            String[] arrLike = strSpecialType.split("\\|");
            PropertyName exp = FILTER_FACTORY.property(arrLike[1]);
            return FILTER_FACTORY.like((Expression)exp, arrLike[2]);
        }
        if (strSpecialType.startsWith("BBOX|")) {
            String[] arrBBOX = strSpecialType.split("\\|");
            String geometryPropertyName = arrBBOX[1];
            ReferencedEnvelope bbox = new ReferencedEnvelope();
            bbox.expandToInclude(Double.parseDouble(arrBBOX[2]), Double.parseDouble(arrBBOX[3]));
            bbox.expandToInclude(Double.parseDouble(arrBBOX[4]), Double.parseDouble(arrBBOX[5]));
            return FILTER_FACTORY.bbox((Expression)FILTER_FACTORY.property(geometryPropertyName), (BoundingBox)bbox);
        }
        if (strSpecialType.equals("NOT")) {
            Element fElem = elemRoot.getChild("FILTER");
            Filter filterObj = null;
            for (Object elemSubObj : fElem.getChildren()) {
                Element elemSub = (Element)elemSubObj;
                if (elemSub.getName().equals("SPECIAL")) {
                    filterObj = this.getSpecialFilter(strTypeName, elemSub);
                    continue;
                }
                Document docSubFilt = new Document();
                docSubFilt.addContent((Content)elemSub.clone());
                XMLOutputter out = new XMLOutputter();
                StringWriter sw = new StringWriter();
                out.output(docSubFilt, (Writer)sw);
                filterObj = this.getXmlFilter(sw.toString());
            }
            return FILTER_FACTORY.not(filterObj);
        }
        if (strSpecialType.equals("AND")) {
            List lstFilters = elemRoot.getChildren("FILTER");
            ArrayList<Filter> lstFilterObj = new ArrayList<Filter>();
            for (Element fElem : lstFilters) {
                for (Object elemSubObj : fElem.getChildren()) {
                    Element elemSub = (Element)elemSubObj;
                    if (elemSub.getName().equals("SPECIAL")) {
                        lstFilterObj.add(this.getSpecialFilter(strTypeName, elemSub));
                        continue;
                    }
                    Document docSubFilt = new Document();
                    docSubFilt.addContent((Content)elemSub.clone());
                    XMLOutputter out = new XMLOutputter();
                    StringWriter sw = new StringWriter();
                    out.output(docSubFilt, (Writer)sw);
                    lstFilterObj.add(this.getXmlFilter(sw.toString()));
                }
            }
            return FILTER_FACTORY.and(lstFilterObj);
        }
        if (strSpecialType.equals("OR")) {
            List lstFilters = elemRoot.getChildren("FILTER");
            ArrayList<Filter> lstFilterObj = new ArrayList<Filter>();
            for (Element fElem : lstFilters) {
                Element elemSub = (Element)fElem.getChildren().get(0);
                if (elemSub.getName().equals("SPECIAL")) {
                    lstFilterObj.add(this.getSpecialFilter(strTypeName, elemSub));
                    continue;
                }
                Document docSubFilt = new Document();
                docSubFilt.addContent((Content)elemSub.clone());
                XMLOutputter out = new XMLOutputter();
                StringWriter sw = new StringWriter();
                out.output(docSubFilt, (Writer)sw);
                lstFilterObj.add(this.getXmlFilter(sw.toString()));
            }
            return FILTER_FACTORY.or(lstFilterObj);
        }
        throw new Exception("Error parsing special filter");
    }

    private Filter getXmlFilter(String strFilterText) throws IOException, ParserConfigurationException, SAXException {
        try (StringReader read = new StringReader(strFilterText);){
            Parser filtParser = new Parser((Configuration)new OGCConfiguration());
            Filter filter = (Filter)filtParser.parse((Reader)read);
            return filter;
        }
    }
}

