/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv.filter.binary;

import de.riwagis.geotools.data.riwasrv.filter.binary.model.FilterNodeType;
import de.riwagis.geotools.data.riwasrv.filter.binary.model.FilterNodeValue;
import de.riwagis.geotools.data.riwasrv.filter.binary.model.FilterNodeValueType;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.filter.identity.FeatureIdVersionedImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelValueMapper {
    private static final Logger log = LoggerFactory.getLogger(ModelValueMapper.class);
    private final FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private final WKBReader wkbReader = new WKBReader();
    private final WKBWriter wkbWriter = new WKBWriter();
    private Map<Class<?>, BiFunction<FilterNodeType, Object, FilterNodeValue<?>>> valueCreators = new HashMap();
    private Map<Integer, FilterNodeValueType> typeIdMap = new HashMap<Integer, FilterNodeValueType>();
    private Map<FilterNodeValueType, SerializerFunction<?, ?>> serializers = new HashMap();
    private Map<FilterNodeValueType, DeserializerFunction<?, ?>> deserializers = new HashMap();

    public ModelValueMapper() {
        this.registerValueType(String.class, 0, DataOutputStream::writeUTF, DataInput::readUTF, new Class[0]);
        this.registerValueType(Long.class, 1, DataOutputStream::writeLong, DataInputStream::readLong, new Class[0]);
        this.registerValueType(Integer.class, 2, DataOutputStream::writeInt, DataInputStream::readInt, new Class[0]);
        this.registerValueType(Short.class, 3, (dos, v) -> dos.writeShort(v.shortValue()), DataInputStream::readShort, new Class[0]);
        this.registerValueType(Byte.class, 4, (dos, v) -> dos.writeByte(v.byteValue()), DataInputStream::readByte, new Class[0]);
        this.registerValueType(Boolean.class, 5, DataOutputStream::writeBoolean, DataInputStream::readBoolean, new Class[0]);
        this.registerValueType(Float.class, 6, DataOutputStream::writeFloat, DataInputStream::readFloat, new Class[0]);
        this.registerValueType(Double.class, 7, DataOutputStream::writeDouble, DataInputStream::readDouble, new Class[0]);
        this.registerValueType(Date.class, 8, (dos, v) -> {
            java.time.Instant instant = v.toInstant();
            String format = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.systemDefault()).format(instant);
            dos.writeUTF(format);
        }, dis -> {
            String isoDate = dis.readUTF();
            TemporalAccessor date = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.systemDefault()).parse(isoDate);
            return Timestamp.from(java.time.Instant.from(date));
        }, Timestamp.class);
        this.registerValueType(Geometry.class, 9, (dos, v) -> {
            byte[] wkbData = this.wkbWriter.write(v);
            dos.writeInt(wkbData.length);
            dos.write(wkbData);
        }, dis -> {
            int wkbLength = dis.readInt();
            byte[] wkbData = new byte[wkbLength];
            dis.read(wkbData);
            try {
                return this.wkbReader.read(wkbData);
            }
            catch (ParseException e) {
                throw new IOException("Could not parse WKB", e);
            }
        }, Point.class, MultiPoint.class, Polygon.class, MultiPolygon.class, LineString.class, MultiLineString.class, GeometryCollection.class);
        this.registerValueType(FeatureId.class, 10, (dos, featureId) -> {
            dos.writeUTF(featureId.getID());
            boolean isVersioned = featureId.getFeatureVersion() != null;
            dos.writeBoolean(isVersioned);
            if (isVersioned) {
                dos.writeUTF(featureId.getFeatureVersion());
            }
        }, dis -> {
            String fid = dis.readUTF();
            boolean isVersioned = dis.readBoolean();
            if (isVersioned) {
                String version = dis.readUTF();
                return this.filterFactory.featureId(fid, version);
            }
            return this.filterFactory.featureId(fid);
        }, FeatureIdVersionedImpl.class, FeatureIdImpl.class);
        MultiValuedFilter.MatchAction[] matchActions = MultiValuedFilter.MatchAction.values();
        this.registerValueType(MultiValuedFilter.MatchAction.class, 11, (dos, matchAction) -> dos.writeByte(matchAction.ordinal()), dis -> matchActions[dis.readByte()], new Class[0]);
        this.registerValueType(ReferencedEnvelope.class, 12, (dos, env) -> {
            dos.writeDouble(env.getMinX());
            dos.writeDouble(env.getMinY());
            dos.writeDouble(env.getMaxX());
            dos.writeDouble(env.getMaxY());
            boolean hasCRS = env.getCoordinateReferenceSystem() != null;
            dos.writeBoolean(hasCRS);
            if (hasCRS) {
                dos.writeUTF(CRS.toSRS((CoordinateReferenceSystem)env.getCoordinateReferenceSystem()));
            }
        }, dis -> {
            double minX = dis.readDouble();
            double minY = dis.readDouble();
            double maxX = dis.readDouble();
            double maxY = dis.readDouble();
            boolean hasCRS = dis.readBoolean();
            CoordinateReferenceSystem crs = null;
            if (hasCRS) {
                try {
                    crs = CRS.decode((String)dis.readUTF());
                }
                catch (FactoryException e) {
                    log.error("Could not parse CRS from binary filter", (Throwable)e);
                }
            }
            return new ReferencedEnvelope(minX, maxX, minY, maxY, crs);
        }, new Class[0]);
        this.registerValueType(DefaultPeriod.class, 13, (dos, v) -> {
            java.time.Instant begin = v.getBeginning().getPosition().getDate().toInstant();
            java.time.Instant end = v.getEnding().getPosition().getDate().toInstant();
            DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.systemDefault());
            dos.writeUTF(formatter.format(begin));
            dos.writeUTF(formatter.format(end));
        }, dis -> {
            String begin = dis.readUTF();
            String end = dis.readUTF();
            DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.systemDefault());
            return new DefaultPeriod((Instant)new DefaultInstant((Position)new DefaultPosition(Date.from(java.time.Instant.from(formatter.parse(begin))))), (Instant)new DefaultInstant((Position)new DefaultPosition(Date.from(java.time.Instant.from(formatter.parse(end))))));
        }, new Class[0]);
        this.registerValueType(BigInteger.class, 14, (dos, v) -> {
            byte[] data = v.toByteArray();
            dos.writeInt(data.length);
            dos.write(data);
        }, dis -> {
            int length = dis.readInt();
            byte[] data = dis.readNBytes(length);
            return new BigInteger(data);
        }, new Class[0]);
        this.registerValueType(BigDecimal.class, 15, (dos, v) -> {
            byte[] intValueData = v.unscaledValue().toByteArray();
            dos.writeInt(intValueData.length);
            dos.write(intValueData);
            dos.writeInt(v.scale());
        }, dis -> {
            int intValueLength = dis.readInt();
            byte[] intValueData = dis.readNBytes(intValueLength);
            BigInteger intVal = new BigInteger(intValueData);
            int scale = dis.readInt();
            return new BigDecimal(intVal, scale);
        }, new Class[0]);
    }

    public <T> FilterNodeValue<T> getTypeForObject(FilterNodeType modelNodeType, Object value) {
        BiFunction<FilterNodeType, Object, FilterNodeValue<?>> typeSupplier = this.valueCreators.get(value.getClass());
        if (typeSupplier == null) {
            throw new IllegalStateException("Unsupported literal type '" + value.getClass().getSimpleName() + "'");
        }
        return typeSupplier.apply(modelNodeType, value);
    }

    private <T, U extends T, E extends Throwable> void registerValueType(Class<T> clazz, int identifier, SerializerFunction<T, E> serializer, DeserializerFunction<T, E> deserializer, Class<?> ... superTypes) {
        String valueTypeName = clazz.getSimpleName();
        FilterNodeValueType valueType = new FilterNodeValueType(identifier, valueTypeName);
        BiFunction<FilterNodeType, Object, FilterNodeValue> mapper = (type, value) -> new FilterNodeValue<Object>((FilterNodeType)((Object)type), value, valueType);
        this.valueCreators.put(clazz, mapper);
        this.typeIdMap.put(valueType.getIdentifier(), valueType);
        for (Class<?> superType : superTypes) {
            this.valueCreators.put(superType, mapper);
        }
        this.serializers.put(valueType, serializer);
        this.deserializers.put(valueType, deserializer);
    }

    public FilterNodeValue<?> deserialize(DataInputStream dis, FilterNodeType modelNodeType) throws IOException {
        int valueType = dis.readInt();
        FilterNodeValueType type = this.typeIdMap.get(valueType);
        if (type == null) {
            throw new IllegalStateException("Value Type '" + valueType + "' is unknown");
        }
        DeserializerFunction<?, ?> deserializer = this.deserializers.get(type);
        if (deserializer == null) {
            throw new IllegalStateException("ModelValue type '" + type.getName() + "' not supported");
        }
        return this.getTypeForObject(modelNodeType, deserializer.deserialize(dis));
    }

    public void serialize(DataOutputStream dos, FilterNodeValue modelValue) throws IOException {
        FilterNodeValueType type = modelValue.type;
        dos.writeInt(type.getIdentifier());
        SerializerFunction<?, ?> serializerFunction = this.serializers.get(type);
        if (serializerFunction == null) {
            throw new IllegalStateException("ModelValue type '" + type.getName() + "' not supported");
        }
        serializerFunction.serializeInteral(dos, modelValue.value);
    }

    @FunctionalInterface
    private static interface SerializerFunction<T, E extends Throwable> {
        public void serialize(DataOutputStream var1, T var2) throws IOException;

        default public void serializeInteral(DataOutputStream dos, Object value) throws IOException {
            this.serialize(dos, value);
        }
    }

    @FunctionalInterface
    private static interface DeserializerFunction<T, E extends Throwable> {
        public T deserialize(DataInputStream var1) throws IOException;
    }
}

