/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv.filter.binary;

import de.riwagis.geotools.data.riwasrv.filter.binary.model.FilterNode;
import de.riwagis.geotools.data.riwasrv.filter.binary.model.FilterNodeFunction;
import de.riwagis.geotools.data.riwasrv.filter.binary.model.FilterNodeType;
import de.riwagis.geotools.data.riwasrv.filter.binary.model.FilterNodeValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class ModelFunctionMapper {
    private final FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private final Map<FilterNodeType, Function<FilterNode, Filter>> filterMappings = Map.ofEntries(Map.entry(FilterNodeType.EXCLUDE, functionNode -> Filter.EXCLUDE), Map.entry(FilterNodeType.INCLUDE, functionNode -> Filter.INCLUDE), Map.entry(FilterNodeType.NOT, functionNode -> this.filterFactory.not(this.mapToFilter(((FilterNodeFunction)functionNode).getParameters().iterator().next()))), Map.entry(FilterNodeType.ID, functionNode -> this.filterFactory.id(this.getParametersAsIds((FilterNodeFunction)functionNode))), Map.entry(FilterNodeType.OR, functionNode -> this.filterFactory.or(this.mapToFilters((FilterNodeFunction)functionNode))), Map.entry(FilterNodeType.AND, functionNode -> this.filterFactory.and(this.mapToFilters((FilterNodeFunction)functionNode))), Map.entry(FilterNodeType.NATIVE, functionNode -> this.filterFactory.nativeFilter((String)((FilterNodeValue)functionNode).getValue())), Map.entry(FilterNodeType.PROPERTY_EQUALS, functionNode -> this.binaryFilter((FilterNode)functionNode, (arg_0, arg_1) -> ((FilterFactory2)this.filterFactory).equals(arg_0, arg_1))), Map.entry(FilterNodeType.PROPERTY_NOT_EQUALS, functionNode -> this.binaryFilter((FilterNode)functionNode, (arg_0, arg_1) -> ((FilterFactory2)this.filterFactory).notEqual(arg_0, arg_1))), Map.entry(FilterNodeType.PROPERTY_IS_NULL, functionNode -> this.filterFactory.isNull(this.mapToExpression(((FilterNodeFunction)functionNode).getParameters().iterator().next()))), Map.entry(FilterNodeType.PROPERTY_LIKE, functionNode -> {
        FilterNodeFunction modelFunction = (FilterNodeFunction)functionNode;
        List<FilterNode> parameters = modelFunction.getParameters();
        Expression expr = this.mapToExpression(parameters.get(0));
        String literal = (String)((FilterNodeValue)parameters.get(1)).getValue();
        String wildcard = (String)((FilterNodeValue)parameters.get(2)).getValue();
        String singleChar = (String)((FilterNodeValue)parameters.get(3)).getValue();
        String escape = (String)((FilterNodeValue)parameters.get(4)).getValue();
        Boolean matchCase = (Boolean)((FilterNodeValue)parameters.get(5)).getValue();
        MultiValuedFilter.MatchAction matchAction = (MultiValuedFilter.MatchAction)((FilterNodeValue)parameters.get(6)).getValue();
        return this.filterFactory.like(expr, literal, wildcard, singleChar, escape, matchCase.booleanValue(), matchAction);
    }), Map.entry(FilterNodeType.PROPERTY_IS_NIL, functionNode -> this.binaryFilter((FilterNode)functionNode, (arg_0, arg_1) -> ((FilterFactory2)this.filterFactory).isNil(arg_0, arg_1))), Map.entry(FilterNodeType.PROPERTY_BETWEEN, functionNode -> {
        List<Expression> expressions = this.mapToExpressions((FilterNodeFunction)functionNode);
        return this.filterFactory.between(expressions.get(1), expressions.get(0), expressions.get(2));
    }), Map.entry(FilterNodeType.PROPERTY_GREATER_THAN, functionNode -> this.binaryFilter((FilterNode)functionNode, (arg_0, arg_1) -> ((FilterFactory2)this.filterFactory).greater(arg_0, arg_1))), Map.entry(FilterNodeType.PROPERTY_GREATER_OR_EQUALS, functionNode -> this.binaryFilter((FilterNode)functionNode, (arg_0, arg_1) -> ((FilterFactory2)this.filterFactory).greaterOrEqual(arg_0, arg_1))), Map.entry(FilterNodeType.PROPERTY_LESS_THAN, functionNode -> this.binaryFilter((FilterNode)functionNode, (arg_0, arg_1) -> ((FilterFactory2)this.filterFactory).less(arg_0, arg_1))), Map.entry(FilterNodeType.PROPERTY_LESS_OR_EQUALS, functionNode -> this.binaryFilter((FilterNode)functionNode, (arg_0, arg_1) -> ((FilterFactory2)this.filterFactory).lessOrEqual(arg_0, arg_1))), Map.entry(FilterNodeType.EQUALS, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).equal(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.AFTER, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).after(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.BEYOND, functionNode -> {
        FilterNodeFunction modelFunction = (FilterNodeFunction)functionNode;
        List<FilterNode> parameters = modelFunction.getParameters();
        Expression expr1 = this.mapToExpression(parameters.get(0));
        Expression expr2 = this.mapToExpression(parameters.get(1));
        Double distance = (Double)((FilterNodeValue)parameters.get(2)).getValue();
        String units = (String)((FilterNodeValue)parameters.get(3)).getValue();
        MultiValuedFilter.MatchAction matchAction = (MultiValuedFilter.MatchAction)((FilterNodeValue)parameters.get(4)).getValue();
        return this.filterFactory.beyond(expr1, expr2, distance.doubleValue(), units, matchAction);
    }), Map.entry(FilterNodeType.BEFORE, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).before(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.BEGINS, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).begins(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.ANY_INTERACTS, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).anyInteracts(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.BEGUN_BY, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).begunBy(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.ENDED_BY, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).endedBy(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.MET_BY, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).metBy(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.OVERLAPPED_BY, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).overlappedBy(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.DURING, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).during(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.ENDS, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).ends(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.MEETS, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).meets(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.TCONTAINS, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).tcontains(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.TOVERLAPS, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).toverlaps(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.TEQUALS, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).tequals(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.CONTAINS, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).contains(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.CROSSES, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).crosses(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.DISJOINT, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).disjoint(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.DWITHIN, functionNode -> {
        FilterNodeFunction modelFunction = (FilterNodeFunction)functionNode;
        List<FilterNode> parameters = modelFunction.getParameters();
        Expression expr1 = this.mapToExpression(parameters.get(0));
        Expression expr2 = this.mapToExpression(parameters.get(1));
        Double distance = (Double)((FilterNodeValue)parameters.get(2)).getValue();
        String units = (String)((FilterNodeValue)parameters.get(3)).getValue();
        MultiValuedFilter.MatchAction matchAction = (MultiValuedFilter.MatchAction)((FilterNodeValue)parameters.get(4)).getValue();
        return this.filterFactory.dwithin(expr1, expr2, distance.doubleValue(), units, matchAction);
    }), Map.entry(FilterNodeType.INTERSECTS, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).intersects(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.OVERLAPS, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).overlaps(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.TOUCHES, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).touches(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.WITHIN, functionNode -> this.binaryFilterWithMatchAction((FilterNode)functionNode, (arg_0, arg_1, arg_2) -> ((FilterFactory2)this.filterFactory).within(arg_0, arg_1, arg_2))), Map.entry(FilterNodeType.BBOX, functionNode -> this.binaryFilter((FilterNode)functionNode, (geomProp, bbox) -> {
        if (bbox instanceof LiteralExpressionImpl) {
            Object value = ((LiteralExpressionImpl)bbox).getValue();
            if (value instanceof ReferencedEnvelope) {
                ReferencedEnvelope e = (ReferencedEnvelope)value;
                return this.filterFactory.bbox(geomProp, e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY(), CRS.toSRS((CoordinateReferenceSystem)e.getCoordinateReferenceSystem()));
            }
            if (value instanceof Geometry) {
                Envelope e = ((Geometry)value).getEnvelopeInternal();
                return this.filterFactory.bbox(geomProp, e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY(), null);
            }
        }
        return null;
    })));
    private final Map<FilterNodeType, Function<FilterNode, Expression>> expressionMappings = Map.ofEntries(Map.entry(FilterNodeType.LITERAL, modelNode -> this.filterFactory.literal(((FilterNodeValue)modelNode).value)), Map.entry(FilterNodeType.PROPERTY, modelNode -> this.filterFactory.property(((FilterNodeValue)modelNode).value.toString())), Map.entry(FilterNodeType.ADD, modelNode -> this.binaryExpression((FilterNode)modelNode, (arg_0, arg_1) -> ((FilterFactory2)this.filterFactory).add(arg_0, arg_1))), Map.entry(FilterNodeType.SUBTRACT, modelNode -> this.binaryExpression((FilterNode)modelNode, (arg_0, arg_1) -> ((FilterFactory2)this.filterFactory).subtract(arg_0, arg_1))), Map.entry(FilterNodeType.MULTIPLY, modelNode -> this.binaryExpression((FilterNode)modelNode, (arg_0, arg_1) -> ((FilterFactory2)this.filterFactory).multiply(arg_0, arg_1))), Map.entry(FilterNodeType.DIVIDE, modelNode -> this.binaryExpression((FilterNode)modelNode, (arg_0, arg_1) -> ((FilterFactory2)this.filterFactory).divide(arg_0, arg_1))), Map.entry(FilterNodeType.FUNCTION, modelNode -> {
        List<FilterNode> parameters = ((FilterNodeFunction)modelNode).getParameters();
        ArrayList<Expression> expressions = new ArrayList<Expression>(parameters.size() - 1);
        Iterator iterator = parameters.iterator();
        String functionName = (String)((FilterNodeValue)iterator.next()).getValue();
        while (iterator.hasNext()) {
            expressions.add(this.mapToExpression((FilterNode)iterator.next()));
        }
        return this.filterFactory.function(functionName, (Expression[])expressions.toArray(Expression[]::new));
    }));

    ModelFunctionMapper() {
    }

    Filter mapToFilter(FilterNode modelNode) {
        Function<FilterNode, Filter> filterMapping = this.filterMappings.get((Object)modelNode.getType());
        if (filterMapping == null) {
            throw new IllegalStateException("ModelFunction type '" + modelNode.getType() + "' not supported");
        }
        return filterMapping.apply(modelNode);
    }

    private Filter binaryFilter(FilterNode modelNode, BiFunction<Expression, Expression, Filter> mapping) {
        List<Expression> expressions = this.mapToExpressions((FilterNodeFunction)modelNode);
        return mapping.apply(expressions.get(0), expressions.get(1));
    }

    private Filter binaryFilterWithMatchAction(FilterNode modelNode, BinaryWithMatchFunction mapping) {
        List<FilterNode> parameters = ((FilterNodeFunction)modelNode).getParameters();
        Expression expr1 = this.mapToExpression(parameters.get(0));
        Expression expr2 = this.mapToExpression(parameters.get(1));
        MultiValuedFilter.MatchAction matchAction = (MultiValuedFilter.MatchAction)((FilterNodeValue)parameters.get(2)).getValue();
        return mapping.apply(expr1, expr2, matchAction);
    }

    private Expression binaryExpression(FilterNode modelNode, BiFunction<Expression, Expression, Expression> mapping) {
        List<Expression> expressions = this.mapToExpressions((FilterNodeFunction)modelNode);
        return mapping.apply(expressions.get(0), expressions.get(1));
    }

    private List<Filter> mapToFilters(FilterNodeFunction functionNode) {
        return functionNode.getParameters().stream().map(p -> this.mapToFilter((FilterNode)p)).collect(Collectors.toUnmodifiableList());
    }

    private List<Expression> mapToExpressions(FilterNodeFunction functionNode) {
        return functionNode.getParameters().stream().map(p -> this.mapToExpression((FilterNode)p)).collect(Collectors.toUnmodifiableList());
    }

    private Set<FeatureId> getParametersAsIds(FilterNodeFunction functionNode) {
        return functionNode.getParameters().stream().map(p -> (FeatureId)((FilterNodeValue)p).getValue()).collect(Collectors.toUnmodifiableSet());
    }

    private Expression mapToExpression(FilterNode modelNode) {
        Function<FilterNode, Expression> expressionMapping = this.expressionMappings.get((Object)modelNode.getType());
        if (expressionMapping == null) {
            throw new IllegalStateException("ModelFunction type '" + modelNode.getType() + "' not supported");
        }
        return expressionMapping.apply(modelNode);
    }

    @FunctionalInterface
    private static interface BinaryWithMatchFunction {
        public Filter apply(Expression var1, Expression var2, MultiValuedFilter.MatchAction var3);
    }
}

