/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv.filter.binary;

import de.riwagis.geotools.data.riwasrv.filter.binary.ModelValueMapper;
import de.riwagis.geotools.data.riwasrv.filter.binary.model.FilterNode;
import de.riwagis.geotools.data.riwasrv.filter.binary.model.FilterNodeFunction;
import de.riwagis.geotools.data.riwasrv.filter.binary.model.FilterNodeType;
import de.riwagis.geotools.data.riwasrv.filter.binary.model.FilterNodeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.NativeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

class BinaryTransformerVisitor
extends DefaultFilterVisitor {
    private final ModelValueMapper modelValueMapper = new ModelValueMapper();

    public Object visit(ExcludeFilter filter, Object data) {
        return this.mapFunction(FilterNodeType.EXCLUDE, data, new Consumer[0]);
    }

    public Object visit(IncludeFilter filter, Object data) {
        return this.mapFunction(FilterNodeType.INCLUDE, data, new Consumer[0]);
    }

    public Object visit(And filter, Object data) {
        return this.mapFunction(FilterNodeType.AND, data, d -> super.visit(filter, d));
    }

    public Object visit(Id filter, Object data) {
        List mappedIds = filter.getIdentifiers().stream().map(id -> this.modelValueMapper.getTypeForObject(FilterNodeType.LITERAL, id)).collect(Collectors.toList());
        return this.mapFunction(FilterNodeType.ID, data, d -> d.addAll(mappedIds));
    }

    public Object visit(Not filter, Object data) {
        return this.mapFunction(FilterNodeType.NOT, data, d -> super.visit(filter, d));
    }

    public Object visit(Or filter, Object data) {
        return this.mapFunction(FilterNodeType.OR, data, d -> super.visit(filter, d));
    }

    public Object visit(PropertyIsBetween filter, Object data) {
        return this.mapFunction(FilterNodeType.PROPERTY_BETWEEN, data, args -> super.visit(filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(PropertyIsEqualTo filter, Object data) {
        return this.mapFunction(FilterNodeType.PROPERTY_EQUALS, data, args -> super.visit(filter, args), args -> this.addBinaryComparisonOperator((BinaryComparisonOperator)filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        return this.mapFunction(FilterNodeType.PROPERTY_NOT_EQUALS, data, args -> super.visit(filter, args), args -> this.addBinaryComparisonOperator((BinaryComparisonOperator)filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(PropertyIsGreaterThan filter, Object data) {
        return this.mapFunction(FilterNodeType.PROPERTY_GREATER_THAN, data, args -> super.visit(filter, args), args -> this.addBinaryComparisonOperator((BinaryComparisonOperator)filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        return this.mapFunction(FilterNodeType.PROPERTY_GREATER_OR_EQUALS, data, args -> super.visit(filter, args), args -> this.addBinaryComparisonOperator((BinaryComparisonOperator)filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(PropertyIsLessThan filter, Object data) {
        return this.mapFunction(FilterNodeType.PROPERTY_LESS_THAN, data, args -> super.visit(filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        return this.mapFunction(FilterNodeType.PROPERTY_LESS_OR_EQUALS, data, d -> super.visit(filter, d), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(PropertyIsLike filter, Object data) {
        return this.mapFunction(FilterNodeType.PROPERTY_LIKE, data, args -> super.visit(filter, args), args -> {
            args.add(this.modelValueMapper.getTypeForObject(FilterNodeType.LITERAL, filter.getLiteral()));
            args.add(this.modelValueMapper.getTypeForObject(FilterNodeType.LITERAL, filter.getWildCard()));
            args.add(this.modelValueMapper.getTypeForObject(FilterNodeType.LITERAL, filter.getSingleChar()));
            args.add(this.modelValueMapper.getTypeForObject(FilterNodeType.LITERAL, filter.getEscape()));
            args.add(this.modelValueMapper.getTypeForObject(FilterNodeType.LITERAL, filter.isMatchingCase()));
        }, args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(PropertyIsNull filter, Object data) {
        return this.mapFunction(FilterNodeType.PROPERTY_IS_NULL, data, args -> super.visit(filter, args));
    }

    public Object visit(PropertyIsNil filter, Object data) {
        return this.mapFunction(FilterNodeType.PROPERTY_IS_NIL, data, args -> super.visit(filter, args), args -> args.add(this.modelValueMapper.getTypeForObject(FilterNodeType.LITERAL, filter.getNilReason())));
    }

    public Object visit(BBOX filter, Object data) {
        return this.mapFunction(FilterNodeType.BBOX, data, args -> filter.getExpression1().accept((ExpressionVisitor)this, args), args -> args.add(this.modelValueMapper.getTypeForObject(FilterNodeType.LITERAL, filter.getBounds())), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(Beyond filter, Object data) {
        return this.mapFunction(FilterNodeType.BEYOND, data, args -> super.visit(filter, args), args -> this.addDistanceBufferOperator((DistanceBufferOperator)filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(Contains filter, Object data) {
        return this.mapFunction(FilterNodeType.CONTAINS, data, args -> super.visit(filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(Crosses filter, Object data) {
        return this.mapFunction(FilterNodeType.CROSSES, data, args -> super.visit(filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(Disjoint filter, Object data) {
        return this.mapFunction(FilterNodeType.DISJOINT, data, args -> super.visit(filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(DWithin filter, Object data) {
        return this.mapFunction(FilterNodeType.DWITHIN, data, args -> super.visit(filter, args), args -> this.addDistanceBufferOperator((DistanceBufferOperator)filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(Equals filter, Object data) {
        return this.mapFunction(FilterNodeType.EQUALS, data, args -> super.visit(filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(Intersects filter, Object data) {
        return this.mapFunction(FilterNodeType.INTERSECTS, data, args -> super.visit(filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(Overlaps filter, Object data) {
        return this.mapFunction(FilterNodeType.OVERLAPS, data, args -> super.visit(filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(Touches filter, Object data) {
        return this.mapFunction(FilterNodeType.TOUCHES, data, args -> super.visit(filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visit(Within filter, Object data) {
        return this.mapFunction(FilterNodeType.WITHIN, data, args -> super.visit(filter, args), args -> this.addMultiValuedFilter((MultiValuedFilter)filter, args));
    }

    public Object visitNullFilter(Object data) {
        return this.mapFunction(FilterNodeType.NULL, data, new Consumer[0]);
    }

    public Object visit(NilExpression expression, Object data) {
        return this.mapFunction(FilterNodeType.NIL, data, new Consumer[0]);
    }

    public Object visit(Add expression, Object data) {
        return this.mapFunction(FilterNodeType.ADD, data, args -> super.visit(expression, args));
    }

    public Object visit(Divide expression, Object data) {
        return this.mapFunction(FilterNodeType.DIVIDE, data, args -> super.visit(expression, args));
    }

    public Object visit(Function expression, Object data) {
        return this.mapFunction(FilterNodeType.FUNCTION, data, args -> args.add(this.modelValueMapper.getTypeForObject(FilterNodeType.LITERAL, expression.getName())), d -> super.visit(expression, d));
    }

    public Object visit(Literal expression, Object data) {
        return this.mapValue(FilterNodeType.LITERAL, expression, data);
    }

    public Object visit(Multiply expression, Object data) {
        return this.mapFunction(FilterNodeType.MULTIPLY, data, args -> super.visit(expression, args));
    }

    public Object visit(PropertyName expression, Object data) {
        if (expression.getNamespaceContext() != null) {
            throw new IllegalStateException("Property with Namespace Declaration is not supported by binary serialization.");
        }
        return this.mapValue(FilterNodeType.PROPERTY, expression.getPropertyName(), data);
    }

    public Object visit(Subtract expression, Object data) {
        return this.mapFunction(FilterNodeType.SUBTRACT, data, args -> super.visit(expression, args));
    }

    public Object visit(After after, Object data) {
        return this.mapFunction(FilterNodeType.AFTER, data, args -> super.visit(after, args), args -> this.addMultiValuedFilter((MultiValuedFilter)after, args));
    }

    public Object visit(AnyInteracts anyInteracts, Object data) {
        return this.mapFunction(FilterNodeType.ANY_INTERACTS, data, args -> super.visit(anyInteracts, args), args -> this.addMultiValuedFilter((MultiValuedFilter)anyInteracts, args));
    }

    public Object visit(Before before, Object data) {
        return this.mapFunction(FilterNodeType.BEFORE, data, args -> super.visit(before, args), args -> this.addMultiValuedFilter((MultiValuedFilter)before, args));
    }

    public Object visit(Begins begins, Object data) {
        return this.mapFunction(FilterNodeType.BEGINS, data, args -> super.visit(begins, args), args -> this.addMultiValuedFilter((MultiValuedFilter)begins, args));
    }

    public Object visit(BegunBy begunBy, Object data) {
        return this.mapFunction(FilterNodeType.BEGUN_BY, data, args -> super.visit(begunBy, args), args -> this.addMultiValuedFilter((MultiValuedFilter)begunBy, args));
    }

    public Object visit(During during, Object data) {
        return this.mapFunction(FilterNodeType.DURING, data, args -> super.visit(during, args), args -> this.addMultiValuedFilter((MultiValuedFilter)during, args));
    }

    public Object visit(EndedBy endedBy, Object data) {
        return this.mapFunction(FilterNodeType.ENDED_BY, data, args -> super.visit(endedBy, args), args -> this.addMultiValuedFilter((MultiValuedFilter)endedBy, args));
    }

    public Object visit(Ends ends, Object data) {
        return this.mapFunction(FilterNodeType.ENDS, data, args -> super.visit(ends, args), args -> this.addMultiValuedFilter((MultiValuedFilter)ends, args));
    }

    public Object visit(Meets meets, Object data) {
        return this.mapFunction(FilterNodeType.MEETS, data, args -> super.visit(meets, args), args -> this.addMultiValuedFilter((MultiValuedFilter)meets, args));
    }

    public Object visit(MetBy metBy, Object data) {
        return this.mapFunction(FilterNodeType.MET_BY, data, args -> super.visit(metBy, args), args -> this.addMultiValuedFilter((MultiValuedFilter)metBy, args));
    }

    public Object visit(OverlappedBy overlappedBy, Object data) {
        return this.mapFunction(FilterNodeType.OVERLAPPED_BY, data, args -> super.visit(overlappedBy, args), args -> this.addMultiValuedFilter((MultiValuedFilter)overlappedBy, args));
    }

    public Object visit(TContains contains, Object data) {
        return this.mapFunction(FilterNodeType.TCONTAINS, data, args -> super.visit(contains, args), args -> this.addMultiValuedFilter((MultiValuedFilter)contains, args));
    }

    public Object visit(TEquals equals, Object data) {
        return this.mapFunction(FilterNodeType.TEQUALS, data, args -> super.visit(equals, args), args -> this.addMultiValuedFilter((MultiValuedFilter)equals, args));
    }

    public Object visit(TOverlaps contains, Object data) {
        return this.mapFunction(FilterNodeType.TOVERLAPS, data, args -> super.visit(contains, args), args -> this.addMultiValuedFilter((MultiValuedFilter)contains, args));
    }

    public Object visit(NativeFilter filter, Object data) {
        return this.mapValue(FilterNodeType.NATIVE, filter.getNative(), data);
    }

    private List<FilterNode> mapFunction(FilterNodeType modelNodeType, Object data, Consumer<ArrayList<FilterNode>> ... argumentSuppliers) {
        List parentArguments = (List)data;
        ArrayList<FilterNode> arguments = new ArrayList<FilterNode>();
        for (Consumer<ArrayList<FilterNode>> argumentSupplier : argumentSuppliers) {
            argumentSupplier.accept(arguments);
        }
        Collections.reverse(arguments);
        FilterNodeFunction function = new FilterNodeFunction(modelNodeType, arguments);
        parentArguments.add(function);
        return parentArguments;
    }

    private List<FilterNode> mapValue(FilterNodeType modelNodeType, Object v, Object data) {
        FilterNodeValue value = this.modelValueMapper.getTypeForObject(modelNodeType, v);
        List parameterList = (List)data;
        parameterList.add(value);
        return parameterList;
    }

    private List<FilterNode> mapValue(FilterNodeType modelNodeType, Literal expression, Object data) {
        return this.mapValue(modelNodeType, expression.getValue(), data);
    }

    private void addMultiValuedFilter(MultiValuedFilter filter, Object visit) {
        this.addValue(visit, filter.getMatchAction());
    }

    private void addBinaryComparisonOperator(BinaryComparisonOperator filter, Object visit) {
        this.addValue(visit, filter.isMatchingCase());
    }

    private void addDistanceBufferOperator(DistanceBufferOperator filter, Object visit) {
        this.addValue(visit, filter.getDistance());
        this.addValue(visit, filter.getDistanceUnits());
    }

    private void addValue(Object visit, Object value) {
        ((List)visit).add(this.modelValueMapper.getTypeForObject(FilterNodeType.LITERAL, value));
    }
}

