/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv;

import de.riwagis.geotools.data.riwasrv.RiwaSrvFeatureStore;
import de.riwagis.geotools.data.riwasrv.TiledFeatureStreamReader;
import de.riwagis.geotools.data.riwasrv.TiledRiwaSrvDataStore;
import de.riwagis.geotools.envelope.EnvelopeUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.store.ContentEntry;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TiledRiwaSrvFeatureStore
extends RiwaSrvFeatureStore {
    private static final Logger LOG = LoggerFactory.getLogger(TiledRiwaSrvFeatureStore.class);
    private final String idCol;
    private final int tileSize;
    private final List<String> properties;
    private final ReferencedEnvelope bounds;
    private final int filterHashCode;

    public TiledRiwaSrvFeatureStore(ContentEntry entry, Query query) {
        super(entry, query);
        try {
            Map<String, Object> metaData = this.getTableMetadata();
            String boundsString = Objects.toString(metaData.get("bounds"), null);
            this.idCol = StringUtils.defaultIfEmpty((String)((String)metaData.get("id-attribute")), null);
            Map zoomLevels = (Map)metaData.get("zoom-levels");
            this.tileSize = Double.valueOf(Objects.toString(zoomLevels.get("0"), "1000")).intValue();
            this.properties = (List)metaData.get("attributes");
            this.filterHashCode = Double.valueOf(Objects.toString(metaData.get("filter-hashcode"), "0")).intValue();
            this.bounds = EnvelopeUtil.readReferencedEnvelope((String)boundsString);
        }
        catch (Exception ex) {
            LOG.error("error initializing tiled feature source", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            return this.getBoundsInternal();
        }
        return super.getBoundsInternal(query);
    }

    public ReferencedEnvelope getBoundsInternal() {
        return this.bounds;
    }

    @Override
    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureType originalType = super.buildFeatureType();
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        if (this.properties == null && this.idCol == null) {
            sftb.init(originalType);
        } else {
            sftb.setName(this.getEntry().getName());
            AttributeTypeBuilder atb = new AttributeTypeBuilder(sftb.getFeatureTypeFactory());
            List<String> usedTypeNames = this.properties == null ? Arrays.asList(DataUtilities.attributeNames((SimpleFeatureType)originalType)) : this.properties;
            for (String property : usedTypeNames) {
                atb.init(originalType.getDescriptor(property));
                if (this.idCol != null) {
                    atb.setIdentifiable(StringUtils.equals((String)property, (String)this.idCol));
                }
                sftb.add(atb.buildDescriptor(property));
            }
        }
        return sftb.buildFeatureType();
    }

    @Override
    protected boolean canFilter() {
        return false;
    }

    @Override
    protected boolean canRetype() {
        return false;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        String typeName = this.entry.getTypeName();
        Envelope bbox = (Envelope)query.getFilter().accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, null);
        if (bbox == null || bbox.isNull() || bbox.getMinX() == Double.NEGATIVE_INFINITY || bbox.getWidth() > (double)(10 * this.tileSize) || bbox.getHeight() > (double)(10 * this.tileSize)) {
            LOG.debug("filter can not be used for vector tiles, fallback to default server feature reader: " + typeName + " - " + query.getFilter());
            return super.getReaderInternal(query);
        }
        if (!this.bounds.intersects(bbox)) {
            return new EmptyFeatureReader((FeatureType)this.getSchema());
        }
        return new TiledFeatureStreamReader(bbox, typeName, this);
    }

    public Map<String, Object> getTableMetadata() {
        Map jsonTables = (Map)this.getDataStore().getJsonMetadata().get("tables");
        return (Map)jsonTables.get(this.getEntry().getTypeName());
    }

    @Override
    public TiledRiwaSrvDataStore getDataStore() {
        return (TiledRiwaSrvDataStore)super.getDataStore();
    }

    public String getIdCol() {
        return this.idCol;
    }

    public int getFilterHashCode() {
        return this.filterHashCode;
    }

    public int getTileSize() {
        return this.tileSize;
    }
}

