/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv;

import de.riwagis.geotools.data.riwasrv.RiwaSrvDataStore;
import de.riwagis.geotools.data.riwasrv.TiledRiwaSrvFeatureStore;
import de.riwagis.service.MethodMData;
import de.riwagis.service.ParameterMData;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceProvider;
import de.riwagis.service.ServiceRequest;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.Query;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiledRiwaSrvDataStore
extends RiwaSrvDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(TiledRiwaSrvDataStore.class);
    public static final String SVC_VECTOR_TILES = "vector_tiles";
    public static final String VECTOR_TILE_ENDING = ".rvt";
    private static final ParameterMData pModKey = new ParameterMData("module_key", Integer.class);
    private static final ParameterMData pStructKey = new ParameterMData("structure_key", Integer.class);
    private static final ParameterMData pTypeName = new ParameterMData("type_name", String.class);
    private static final ParameterMData pVersion = new ParameterMData("version", Integer.class);
    private static final ParameterMData pRow = new ParameterMData("int", Integer.class);
    private static final ParameterMData pCol = new ParameterMData("int", Integer.class);
    private static final ParameterMData pScale = new ParameterMData("scale", Integer.class);
    private static final MethodMData methGetTile = new MethodMData("get_tile", new ParameterMData[]{pModKey, pStructKey, pTypeName, pVersion, pRow, pCol, pScale}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_STREAM);
    private static final MethodMData methGetMetaData = new MethodMData("get_metadata", new ParameterMData[]{pModKey, pStructKey}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_OBJECT);
    public static final ServiceMData vectorTilesService = new ServiceMData("vector_tiles", 0, new MethodMData[]{methGetTile, methGetMetaData});
    private File cacheDirectory;
    private Map<String, Object> jsonMetadata = null;

    public TiledRiwaSrvDataStore(ServiceProvider svProv, int moduleKey, int structureKey, String cacheDirectoryPath) throws IOException {
        super(svProv, moduleKey, structureKey);
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("module_key", this.getModuleKey());
            params.put("structure_key", this.getStructureKey());
            ServiceRequest req = vectorTilesService.createRequest(methGetMetaData.getName(), params);
            ServiceRequest request = this.getServiceProvider().execRequest(req);
            if (request.hasError()) {
                throw new ServiceException(request.getError());
            }
            this.jsonMetadata = (Map)request.getResult();
            this.buildCacheDirectory(cacheDirectoryPath);
            if (!this.cacheDirectory.exists()) {
                this.cacheDirectory.mkdirs();
            }
        }
        catch (Exception e) {
            LOG.error("Error getting metadata from vector tiles service, cannot initialize datastore", (Throwable)e);
            this.jsonMetadata = new HashMap<String, Object>();
            this.jsonMetadata.put("connection_id", -1);
            this.jsonMetadata.put("version", -1);
            this.jsonMetadata.put("tables", new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        try {
            this.dataStoreLock.lock();
            if (this.cachedFeatureSources.containsKey(entry)) {
                ContentFeatureSource contentFeatureSource = (ContentFeatureSource)this.cachedFeatureSources.get(entry);
                return contentFeatureSource;
            }
            String typeName = entry.getTypeName();
            Map jsonTables = (Map)this.jsonMetadata.get("tables");
            if (jsonTables.containsKey(typeName)) {
                TiledRiwaSrvFeatureStore featureSource = new TiledRiwaSrvFeatureStore(entry, Query.ALL);
                this.cachedFeatureSources.put(entry, featureSource);
                TiledRiwaSrvFeatureStore tiledRiwaSrvFeatureStore = featureSource;
                return tiledRiwaSrvFeatureStore;
            }
            LOG.debug("vector tiles not enabled for feature source " + typeName + ", use feature service");
            ContentFeatureSource contentFeatureSource = super.createFeatureSource(entry);
            return contentFeatureSource;
        }
        finally {
            this.dataStoreLock.unlock();
        }
    }

    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public Map<String, Object> getJsonMetadata() {
        return this.jsonMetadata;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    private void buildCacheDirectory(String rootCacheDirectory) throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append(rootCacheDirectory);
        if (sb.charAt(sb.length() - 1) != File.separatorChar) {
            sb.append(File.separator);
        }
        sb.append("vectortiles").append(File.separator);
        sb.append(this.getServiceProvider().getURL().hashCode()).append(File.separator);
        int connectionID = ((Number)this.jsonMetadata.get("connection_id")).intValue();
        sb.append(connectionID).append(File.separator);
        int version = ((Number)this.jsonMetadata.get("version")).intValue();
        sb.append(version).append(File.separator);
        this.cacheDirectory = new File(sb.toString());
    }
}

