/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv;

import de.riwagis.geotools.data.io.FeatureInputStream;
import de.riwagis.geotools.data.io.FeatureOutputStream;
import de.riwagis.geotools.data.riwasrv.FeatureStreamReader;
import de.riwagis.geotools.data.riwasrv.RiwaSrvDataStore;
import de.riwagis.geotools.data.riwasrv.TiledRiwaSrvDataStore;
import de.riwagis.geotools.data.riwasrv.TiledRiwaSrvFeatureStore;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.vectortiles.VectorTilesUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TiledFeatureStreamReader
implements SimpleFeatureReader {
    private static final Logger LOG = LoggerFactory.getLogger(TiledFeatureStreamReader.class);
    private final int zoomLevel = 0;
    private int col = 0;
    private int row = 0;
    private double x = 0.0;
    private double y = 0.0;
    private final Envelope bbox;
    private final String typeName;
    private final TiledRiwaSrvFeatureStore tiledFeatureSource;
    private final Collection<String> readFeatures = new HashSet<String>();
    private SimpleFeature currentFeature = null;
    private FeatureInputStream currentFIS = null;
    private boolean needsClipping = true;
    private boolean closed = false;
    private boolean hasNextCalled = false;

    public TiledFeatureStreamReader(Envelope bbox, String typeName, TiledRiwaSrvFeatureStore tiledFeatureSource) throws IOException {
        this.tiledFeatureSource = tiledFeatureSource;
        this.bbox = bbox;
        this.typeName = typeName;
        this.x = tiledFeatureSource.getBoundsInternal().getMinX();
        this.y = tiledFeatureSource.getBoundsInternal().getMinY();
    }

    public SimpleFeatureType getFeatureType() {
        return this.tiledFeatureSource.getSchema();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (this.closed) {
            throw new IOException("reader already closed");
        }
        if (!this.hasNextCalled) {
            this.hasNext();
        }
        this.hasNextCalled = false;
        return this.currentFeature;
    }

    public boolean hasNext() throws IOException {
        if (this.closed) {
            throw new IOException("reader already closed");
        }
        if (this.hasNextCalled) {
            return this.currentFeature != null;
        }
        this.hasNextCalled = true;
        this.currentFeature = null;
        while (!this.closed) {
            if (this.currentFIS == null) {
                FeatureInputStream fis = this.getNextTile();
                if (fis == null) {
                    return false;
                }
                this.currentFIS = fis;
            }
            if (this.currentFIS.hasNextFeature()) {
                Geometry geom;
                this.currentFeature = this.currentFIS.readFeature();
                if (this.needsClipping && !this.bbox.intersects((geom = (Geometry)this.currentFeature.getDefaultGeometry()).getEnvelopeInternal())) {
                    this.currentFeature = null;
                    continue;
                }
                String key = this.tiledFeatureSource.getIdCol() == null ? FeatureUtil.getFeatureIDWithoutTable((SimpleFeature)this.currentFeature) : Objects.toString(FeatureUtil.getAttribute((SimpleFeature)this.currentFeature, (String)this.tiledFeatureSource.getIdCol()), null);
                if (key == null) {
                    throw new IllegalArgumentException("Error reading Vector Tile, feature key column should not be null for vector tile key index");
                }
                boolean added = this.readFeatures.add(key);
                if (!added) {
                    this.currentFeature = null;
                    continue;
                }
                return true;
            }
            IOUtils.closeQuietly((InputStream)this.currentFIS);
            this.currentFIS = null;
            this.currentFeature = null;
        }
        return false;
    }

    public void close() throws IOException {
        this.closed = true;
        IOUtils.closeQuietly((InputStream)this.currentFIS);
        this.currentFIS = null;
        this.currentFeature = null;
        this.hasNextCalled = false;
        this.readFeatures.clear();
    }

    public FeatureInputStream readTile(File tile) throws IOException {
        FeatureInputStream fis = new FeatureInputStream((InputStream)new GZIPInputStream(new FileInputStream(tile)));
        return fis;
    }

    public FeatureInputStream getNextTile() throws IOException {
        while (this.x <= this.tiledFeatureSource.getBoundsInternal().getMaxX()) {
            while (this.y <= this.tiledFeatureSource.getBoundsInternal().getMaxY()) {
                ReferencedEnvelope tileBounds = new ReferencedEnvelope(this.x, this.x + (double)this.tiledFeatureSource.getTileSize(), this.y, this.y + (double)this.tiledFeatureSource.getTileSize(), this.tiledFeatureSource.getBoundsInternal().getCoordinateReferenceSystem());
                if (this.bbox.intersects((Envelope)tileBounds)) {
                    File tile = new File(VectorTilesUtil.buildTilePath((String)this.typeName, (File)this.tiledFeatureSource.getDataStore().getCacheDirectory(), (int)this.tiledFeatureSource.getFilterHashCode(), (int)0, (int)this.row, (int)this.col));
                    if (tile.exists()) {
                        FileUtils.touch((File)tile);
                    } else {
                        try {
                            this.createTile(tile, 0, this.row, this.col);
                        }
                        catch (Exception ex) {
                            LOG.error("cant create tile " + tile.getAbsolutePath(), (Throwable)ex);
                        }
                    }
                    FeatureInputStream fis = this.readTile(tile);
                    ++this.row;
                    this.y += (double)this.tiledFeatureSource.getTileSize();
                    this.needsClipping = !this.bbox.contains((Envelope)tileBounds);
                    return fis;
                }
                ++this.row;
                this.y += (double)this.tiledFeatureSource.getTileSize();
            }
            ++this.col;
            this.x += (double)this.tiledFeatureSource.getTileSize();
            this.row = 0;
            this.y = this.tiledFeatureSource.getBoundsInternal().getMinY();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTile(File tile, int zoomLevel, int row, int col) throws ServiceException, Exception {
        block12: {
            File tmpTile = new File(tile.getAbsolutePath() + ".tmp");
            tmpTile.getParentFile().mkdirs();
            boolean tmpTileCreated = tmpTile.createNewFile();
            if (!tmpTileCreated) {
                while (!tile.exists() && tmpTile.exists()) {
                    long lastModified = tmpTile.lastModified();
                    if (System.currentTimeMillis() - lastModified > 60000L) {
                        boolean deleted = tmpTile.delete();
                        if (deleted) break;
                        LOG.error("cant delete temporary vector tile: " + tmpTile.getAbsolutePath());
                        break;
                    }
                    Thread.sleep(100L);
                }
                if (tile.exists()) {
                    return;
                }
            }
            FeatureOutputStream fout = null;
            FeatureStreamReader reader = null;
            try {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("module_key", this.tiledFeatureSource.getDataStore().getModuleKey());
                params.put("structure_key", this.tiledFeatureSource.getDataStore().getStructureKey());
                params.put("type_name", this.typeName);
                int version = ((Number)this.tiledFeatureSource.getDataStore().getJsonMetadata().get("version")).intValue();
                params.put("version", version);
                params.put("row", row);
                params.put("col", col);
                params.put("zoom-level", zoomLevel);
                ServiceRequest req = TiledRiwaSrvDataStore.vectorTilesService.createRequest("get_tile", params);
                req.setStreamProcessor((StreamProcessor)RiwaSrvDataStore.FSP);
                List resultList = (List)this.tiledFeatureSource.getDataStore().getServiceProvider().execRequest(req).getResult();
                reader = new FeatureStreamReader(resultList, this.getFeatureType());
                fout = new FeatureOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(tmpTile)), this.getFeatureType(), 1);
                while (reader.hasNext()) {
                    fout.writeFeature(reader.next());
                }
                IOUtils.closeQuietly((Closeable)((Object)reader));
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                tmpTile.delete();
                break block12;
            }
            finally {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(fout);
                tmpTile.renameTo(tile);
                if (tmpTile.exists()) {
                    tmpTile.delete();
                }
            }
            IOUtils.closeQuietly((OutputStream)fout);
            tmpTile.renameTo(tile);
            if (tmpTile.exists()) {
                tmpTile.delete();
            }
        }
    }
}

