/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv;

import de.riwagis.geotools.data.riwasrv.ServiceProviderSupplier;
import de.riwagis.service.ServiceProvider;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceProviderSingleton {
    private static final Logger log = LoggerFactory.getLogger(ServiceProviderSingleton.class);
    private static ServiceProviderSupplier SUPPLIER;

    ServiceProviderSingleton() {
    }

    static ServiceProvider getServiceProvider() {
        return ServiceProviderSingleton.getSupplierInstance().getServiceProvider();
    }

    static boolean isAvailable() {
        return ServiceProviderSingleton.getSupplierInstance().isAvailable();
    }

    static String getServerVersion() {
        return ServiceProviderSingleton.getSupplierInstance().getServerVersion();
    }

    private static ServiceProviderSupplier getSupplierInstance() {
        if (SUPPLIER == null) {
            SUPPLIER = ServiceLoader.load(ServiceProviderSupplier.class).findFirst().orElseGet(() -> {
                log.warn("Missing Service Provider. RIWA Server Data Store will not be available.");
                return new FallbackNotAvailableSupplier();
            });
        }
        return SUPPLIER;
    }

    private static class FallbackNotAvailableSupplier
    implements ServiceProviderSupplier {
        private FallbackNotAvailableSupplier() {
        }

        @Override
        public ServiceProvider getServiceProvider() {
            throw new UnsupportedOperationException("Not available.");
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public String getServerVersion() {
            throw new UnsupportedOperationException("Not available.");
        }
    }
}

