/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv;

import de.riwagis.geotools.data.io.FeatureOutputStream;
import de.riwagis.geotools.data.riwasrv.RiwaSrvFeatureStore;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.service.ServiceProvider;
import de.riwagis.service.ServiceRequest;
import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.time.StopWatch;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.MismatchedDimensionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiwaSrvFeatureWriter
implements SimpleFeatureWriter {
    private static final Logger log = LoggerFactory.getLogger(RiwaSrvFeatureWriter.class);
    private static final int FEATURE_UPDATE = 1;
    private static final int FEATURE_INSERT = 2;
    private static final int FEATURE_DELETE = 3;
    private static final int NUM_FEATURE_BATCH_SIZE = 250;
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.geotools.data.i18n.i18n");
    private final FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    private final RiwaSrvFeatureStore featureStore;
    private final SimpleFeatureType featureType;
    private final ServiceProvider svProv;
    private final int intModule;
    private final int intStructure;
    private final Collection<SimpleFeature> bufferedInserts = new HashSet<SimpleFeature>();
    private final Collection<SimpleFeature> bufferedUpdates = new HashSet<SimpleFeature>();
    private final Collection<SimpleFeature> bufferedDeletes = new HashSet<SimpleFeature>();
    private final StopWatch stopWatch = new StopWatch();
    private SimpleFeature live;
    private SimpleFeature current;
    private boolean closed = false;
    private int featureCount = 0;

    public RiwaSrvFeatureWriter(RiwaSrvFeatureStore featureStore, FeatureReader<SimpleFeatureType, SimpleFeature> reader, ServiceProvider svProv, int intModule, int intStructure) {
        this.featureStore = featureStore;
        this.reader = reader;
        this.featureType = (SimpleFeatureType)this.reader.getFeatureType();
        this.svProv = svProv;
        this.intModule = intModule;
        this.intStructure = intStructure;
        this.stopWatch.start();
        log.info("New Feature Writer!");
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public SimpleFeature next() throws IOException {
        if (this.closed) {
            throw new IOException(i18n.get("geotools.data.riwasrv.fw-closed"));
        }
        if (this.hasNext()) {
            this.live = (SimpleFeature)this.reader.next();
            this.current = SimpleFeatureBuilder.copy((SimpleFeature)this.live);
        } else {
            this.live = null;
            this.current = FeatureUtil.createFeature((SimpleFeatureType)this.featureType);
        }
        return this.current;
    }

    public boolean hasNext() throws IOException {
        if (this.closed) {
            throw new IOException(i18n.get("geotools.data.riwasrv.fw-closed"));
        }
        return this.reader.hasNext();
    }

    public void write() throws IOException {
        if (this.closed) {
            throw new IOException(i18n.get("geotools.data.riwasrv.fw-closed"));
        }
        if (this.current == null) {
            throw new IOException(i18n.get("geotools.data.riwasrv.no-feature-available-to-write"));
        }
        if (this.live != null) {
            if (this.featureEquals(this.live, this.current)) {
                this.live = null;
                this.current = null;
            } else {
                try {
                    this.doEditFeature(this.current, 1);
                    this.featureStore.getState().fireFeatureUpdated((FeatureSource)this.featureStore, (Feature)this.current, new ReferencedEnvelope(this.live.getBounds()));
                }
                catch (IOException | MismatchedDimensionException e) {
                    throw new DataSourceException(i18n.fmt("geotools.data.riwasrv.error-update", new Object[]{e.getMessage()}), e);
                }
                this.live = null;
                this.current = null;
            }
        } else {
            try {
                this.doEditFeature(this.current, 2);
                this.featureStore.getState().fireFeatureAdded((FeatureSource)this.featureStore, (Feature)this.current);
            }
            catch (IOException e) {
                throw new DataSourceException(i18n.fmt("geotools.data.riwasrv.error-insert", new Object[]{e.getMessage()}), (Throwable)e);
            }
            this.current = null;
        }
    }

    private boolean featureEquals(SimpleFeature live, SimpleFeature current) {
        Objects.requireNonNull(live);
        Geometry geomLive = (Geometry)live.getDefaultGeometry();
        Geometry geomCand = (Geometry)current.getDefaultGeometry();
        Class<GeometryCollection> collectionClass = GeometryCollection.class;
        if (geomLive != geomCand && geomLive != null && geomCand != null && (collectionClass.equals(geomLive.getClass()) || collectionClass.equals(geomCand.getClass()))) {
            return false;
        }
        return live.equals(current);
    }

    public void remove() throws IOException {
        if (this.closed) {
            throw new IOException(i18n.get("geotools.data.riwasrv.fw-closed"));
        }
        if (this.current == null) {
            throw new IOException(i18n.get("geotools.data.riwasrv.no-feature-available-to-remove"));
        }
        if (this.live != null) {
            this.doEditFeature(this.current, 3);
            this.featureStore.getState().fireFeatureRemoved((FeatureSource)this.featureStore, (Feature)this.current);
            this.live = null;
            this.current = null;
        } else {
            this.current = null;
        }
    }

    public void close() throws IOException {
        this.flushBuffer(this.bufferedInserts, 2);
        this.flushBuffer(this.bufferedUpdates, 1);
        this.flushBuffer(this.bufferedDeletes, 3);
        log.info("Iterated {} features", (Object)this.featureCount);
        try {
            this.reader.close();
        }
        catch (IOException e) {
            log.warn(String.format("Error closing FeatureReader to '%s' in RiwaSrvFeatureWriter. Should never reach here.", this.featureType.getTypeName()), (Throwable)e);
        }
        this.stopWatch.stop();
        log.info("Time to finish: {}", (Object)this.stopWatch.toString());
        this.live = null;
        this.current = null;
        this.closed = true;
    }

    private void flushBuffer(Collection<SimpleFeature> buffer, int operation) throws DataSourceException {
        if (!buffer.isEmpty() && !this.batchExecution(buffer, operation)) {
            throw new DataSourceException("Could not flush batched feature operation to server");
        }
    }

    private boolean doEditFeature(SimpleFeature current, Integer intOperation) throws IOException {
        ++this.featureCount;
        switch (intOperation) {
            case 2: {
                return this.bufferFeature(current, 2, this.bufferedInserts);
            }
            case 1: {
                return this.bufferFeature(current, 1, this.bufferedUpdates);
            }
            case 3: {
                return this.bufferFeature(current, 3, this.bufferedDeletes);
            }
        }
        throw new IllegalStateException("Unexpected value: " + intOperation);
    }

    private boolean bufferFeature(SimpleFeature current, Integer intOperation, Collection<SimpleFeature> buffer) throws DataSourceException {
        buffer.add(current);
        if (buffer.size() >= 250) {
            return this.batchExecution(buffer, intOperation);
        }
        return true;
    }

    private boolean batchExecution(Collection<SimpleFeature> features, Integer intOperation) throws DataSourceException {
        boolean bl;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            this.createFeatureStream(features, byteStream);
            ByteArrayInputStream featuresForRequest = new ByteArrayInputStream(byteStream.toByteArray());
            features.clear();
            Map<String, ByteArrayInputStream> params = Map.of("module_key", this.intModule, "structure_key", this.intStructure, "operation", intOperation, "features", featuresForRequest);
            ServiceRequest req = this.featureStore.getDataStore().getFeatureService().createRequest("edit_features", params);
            bl = (Boolean)this.svProv.execRequest(req).getResult();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DataSourceException(i18n.fmt("geotools.data.riwasrv.error-edit-server", new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        byteStream.close();
        return bl;
    }

    private void createFeatureStream(Collection<SimpleFeature> features, ByteArrayOutputStream byteStream) throws IOException {
        try (GZIPOutputStream gzipStream = new GZIPOutputStream(byteStream);
             FeatureOutputStream featureStream = new FeatureOutputStream((OutputStream)gzipStream, this.featureType);){
            for (SimpleFeature f : features) {
                featureStream.writeFeature(f);
            }
        }
        catch (Exception e) {
            log.warn("Unable to write edited features: {}", (Object)e.getMessage());
            throw e;
        }
    }
}

