/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv;

import de.riwagis.geotools.data.riwasrv.FeatureStreamReader;
import de.riwagis.geotools.data.riwasrv.RiwaSrvDataStore;
import de.riwagis.geotools.data.riwasrv.RiwaSrvFeatureWriter;
import de.riwagis.geotools.data.riwasrv.ServiceProviderSingleton;
import de.riwagis.geotools.data.riwasrv.filter.binary.BinaryFilterEncoder;
import de.riwagis.geotools.data.riwasrv.filter.legacyxml.LegacyXMLFilterEncoder;
import de.riwagis.geotools.envelope.EnvelopeUtil;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.util.lang.VersionComparator;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RiwaSrvFeatureStore
extends ContentFeatureStore {
    private static final Logger LOG = LoggerFactory.getLogger(RiwaSrvFeatureStore.class);
    private static final LegacyXMLFilterEncoder ENCODER_LEGACY_XML = new LegacyXMLFilterEncoder();
    private static final String VERSION_MIN_FOR_SERVERSIDE_BOUNDARY_COMPUTATION = "1.0.22";
    private static final String VERSION_MIN_FOR_BINARY_FILTERS = "1.0.23.12";
    private final BiConsumer<Filter, Map<String, Object>> filterApplier;
    private final BoundaryCalculation boundaryComputation;

    public RiwaSrvFeatureStore(ContentEntry entry, Query query) {
        super(entry, query);
        boolean useBinaryFilterEncoding;
        String serverVersion = ServiceProviderSingleton.getServerVersion();
        VersionComparator versionComparator = VersionComparator.DEFAULT_VERSIONCOMPARATOR;
        boolean useServerSideBoundaryComputation = versionComparator.compare(serverVersion, VERSION_MIN_FOR_SERVERSIDE_BOUNDARY_COMPUTATION) >= 0;
        this.boundaryComputation = useServerSideBoundaryComputation ? this::getBoundsFromServer : this::downloadFeaturesAndComputeBounds;
        boolean bl = useBinaryFilterEncoding = versionComparator.compare(serverVersion, VERSION_MIN_FOR_BINARY_FILTERS) >= 0;
        if (useBinaryFilterEncoding) {
            BinaryFilterEncoder binaryFilterEncoder = new BinaryFilterEncoder();
            this.filterApplier = (filter, params) -> params.put("binary_filter", binaryFilterEncoder.encode((Filter)filter));
        } else {
            this.filterApplier = (filter, params) -> params.put("filter", ENCODER_LEGACY_XML.encode((Filter)filter));
        }
    }

    public RiwaSrvDataStore getDataStore() {
        return (RiwaSrvDataStore)super.getDataStore();
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
        if (!this.getDataStore().isEditable()) {
            throw new IOException("Datastore is not editable");
        }
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("module_key", this.getDataStore().getModuleKey());
            params.put("structure_key", this.getDataStore().getStructureKey());
            ServiceRequest req = RiwaSrvDataStore.featureService.createRequest("is_readonly", params);
            boolean bolReadonly = (Boolean)this.getDataStore().getServiceProvider().execRequest(req).getResult();
            if (bolReadonly) {
                throw new IOException("You have insufficient rights for editing data.");
            }
        }
        catch (ServiceException e) {
            throw new IOException(e.getMessage());
        }
        Filter filter = query.getFilter();
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.NONE?");
        }
        if (this.transaction == null) {
            throw new NullPointerException("getFeatureReader requires Transaction: did you mean Transaction.AUTO_COMMIT");
        }
        SimpleFeatureType fType = this.getSchema();
        String[] arrProperties = new String[fType.getAttributeCount()];
        for (int i = 0; i < arrProperties.length; ++i) {
            arrProperties[i] = fType.getDescriptor(i).getLocalName();
        }
        if (flags == 1) {
            filter = Filter.EXCLUDE;
        }
        Query readQuery = new Query(query.getTypeName(), filter, arrProperties);
        FeatureReader reader = this.getDataStore().getFeatureReader(readQuery, this.transaction);
        RiwaSrvFeatureWriter writer = this.createFeatureWriter((FeatureReader<SimpleFeatureType, SimpleFeature>)reader);
        return writer;
    }

    protected RiwaSrvFeatureWriter createFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> reader) {
        return new RiwaSrvFeatureWriter(this, reader, this.getDataStore().getServiceProvider(), this.getDataStore().getModuleKey(), this.getDataStore().getStructureKey());
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        try {
            return this.boundaryComputation.calculateBoundaries(query);
        }
        catch (Exception e) {
            LOG.error("Error getting Bounds", (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
    }

    private ReferencedEnvelope getBoundsFromServer(Query query) throws Exception {
        Filter filter = query.getFilter();
        StringBuilder sbType = new StringBuilder();
        sbType.append(query.getTypeName());
        String[] arrProp = query.getPropertyNames();
        if (arrProp == null) {
            throw new Exception("No properties for query.");
        }
        for (String prop : arrProp) {
            sbType.append("|");
            sbType.append(prop);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("module_key", this.getDataStore().getModuleKey());
        params.put("structure_key", this.getDataStore().getStructureKey());
        params.put("type_name", sbType.toString());
        this.encodeAndSetFilter(filter, params);
        ServiceRequest req = RiwaSrvDataStore.featureService.createRequest("get_bounds", params);
        String strBBox = (String)this.getDataStore().getServiceProvider().execRequest(req).getResult();
        ReferencedEnvelope bbox = EnvelopeUtil.readReferencedEnvelope((String)strBBox);
        if (bbox.isNull()) {
            return null;
        }
        return bbox;
    }

    private ReferencedEnvelope downloadFeaturesAndComputeBounds(Query query) throws Exception {
        int count = this.getCount(query);
        if (count > 50000 || count == -1) {
            return null;
        }
        FeatureReader<SimpleFeatureType, SimpleFeature> fread = this.getReaderInternal(query);
        if (((SimpleFeatureType)fread.getFeatureType()).getGeometryDescriptor() == null) {
            return null;
        }
        ReferencedEnvelope env = new ReferencedEnvelope();
        while (fread.hasNext()) {
            Geometry geom = (Geometry)((SimpleFeature)fread.next()).getDefaultGeometry();
            if (geom == null) continue;
            env.expandToInclude(geom.getEnvelopeInternal());
        }
        if (env.isNull()) {
            return null;
        }
        return env;
    }

    private void encodeAndSetFilter(Filter filter, Map<String, Object> params) {
        this.filterApplier.accept(filter, params);
    }

    protected int getCountInternal(Query query) throws IOException {
        try {
            Filter filter = query.getFilter();
            StringBuilder sbType = new StringBuilder();
            sbType.append(query.getTypeName());
            String[] arrProp = query.getPropertyNames();
            if (arrProp == null) {
                throw new Exception("No properties for query.");
            }
            for (String arrProp1 : arrProp) {
                sbType.append("|");
                sbType.append(arrProp1);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("module_key", this.getDataStore().getModuleKey());
            params.put("structure_key", this.getDataStore().getStructureKey());
            params.put("type_name", sbType.toString());
            this.encodeAndSetFilter(filter, params);
            ServiceRequest req = RiwaSrvDataStore.featureService.createRequest("get_count", params);
            return (Integer)this.getDataStore().getServiceProvider().execRequest(req).getResult();
        }
        catch (Exception e) {
            LOG.error("Error getting Count", (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        try {
            List resultList;
            if (query == Query.ALL) {
                String typeName = this.entry.getTypeName();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("module_key", this.getDataStore().getModuleKey());
                params.put("structure_key", this.getDataStore().getStructureKey());
                params.put("type_name", typeName);
                this.encodeAndSetFilter((Filter)Filter.INCLUDE, params);
                ServiceRequest req = RiwaSrvDataStore.featureService.createRequest("get_feature_reader", params);
                req.setStreamProcessor((StreamProcessor)RiwaSrvDataStore.FSP);
                resultList = (List)this.getDataStore().getServiceProvider().execRequest(req).getResult();
            } else {
                Filter filter = query.getFilter();
                if (filter == Filter.EXCLUDE) {
                    return new EmptyFeatureReader((FeatureType)this.getSchema());
                }
                StringBuilder sbType = new StringBuilder();
                sbType.append(query.getTypeName());
                String[] arrProp = query.getPropertyNames();
                if (arrProp == null) {
                    LOG.warn("No properties for query.");
                    arrProp = new String[]{};
                }
                for (String arrProp1 : arrProp) {
                    sbType.append("|");
                    sbType.append(arrProp1);
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("module_key", this.getDataStore().getModuleKey());
                params.put("structure_key", this.getDataStore().getStructureKey());
                params.put("type_name", sbType.toString());
                this.encodeAndSetFilter(filter, params);
                ServiceRequest req = RiwaSrvDataStore.featureService.createRequest("get_feature_reader", params);
                req.setStreamProcessor((StreamProcessor)RiwaSrvDataStore.FSP);
                resultList = (List)this.getDataStore().getServiceProvider().execRequest(req).getResult();
            }
            return new FeatureStreamReader(resultList, this.getSchema());
        }
        catch (Exception e) {
            LOG.error("Error getting FeatureReader", (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        try {
            String typeName = this.entry.getTypeName();
            long time = System.currentTimeMillis();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("module_key", this.getDataStore().getModuleKey());
            params.put("structure_key", this.getDataStore().getStructureKey());
            params.put("type_name", typeName);
            ServiceRequest req = RiwaSrvDataStore.featureService.createRequest("get_feature_type", params);
            req.setStreamProcessor((StreamProcessor)RiwaSrvDataStore.FSP);
            List lstFeature = (List)this.getDataStore().getServiceProvider().execRequest(req).getResult();
            SimpleFeatureType fType = (SimpleFeatureType)lstFeature.get(0);
            LOG.trace("Schema {} retrieved in {} ms from server.", (Object)typeName, (Object)(System.currentTimeMillis() - time));
            return fType;
        }
        catch (Exception e) {
            LOG.error("error getSchema", (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
    }

    protected boolean canFilter() {
        return true;
    }

    protected boolean canRetype() {
        return true;
    }

    @FunctionalInterface
    private static interface BoundaryCalculation {
        public ReferencedEnvelope calculateBoundaries(Query var1) throws Exception;
    }
}

