/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv;

import de.riwagis.geotools.data.riwasrv.RiwaSrvDataStore;
import de.riwagis.geotools.data.riwasrv.ServiceProviderSingleton;
import de.riwagis.geotools.data.riwasrv.TiledRiwaSrvDataStore;
import de.riwagis.service.ServiceProvider;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiwaSrvDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOG = LoggerFactory.getLogger((String)RiwaSrvDataStoreFactory.class.getName());
    public static final String PARAM_MODULE = "module";
    public static final String PARAM_STRUCTURE = "structure";
    public static final String STR_MODULEID = "module-id";
    public static final String STR_STRUCTUREID = "structure-id";
    public static final String STR_ZERO = "0";
    public static final DataAccessFactory.Param MODULE = new DataAccessFactory.Param("module", String.class, "module-id", true, (Object)"0");
    public static final DataAccessFactory.Param STRUCTURE = new DataAccessFactory.Param("structure", String.class, "structure-id", true, (Object)"0");
    public static final DataAccessFactory.Param TILED = new DataAccessFactory.Param("tiled", Boolean.class, "use riwa vector tiles", false, (Object)true);
    public static final DataAccessFactory.Param TILE_CACHE_DIRECTORY_PATH = new DataAccessFactory.Param("tile_cache_directory_path", String.class, "tile cache directory path", false, (Object)FileUtils.getTempDirectoryPath());
    static final DataAccessFactory.Param[] arrayParameters = new DataAccessFactory.Param[]{MODULE, STRUCTURE, TILED, TILE_CACHE_DIRECTORY_PATH};
    private ServiceProvider svProv;

    public RiwaSrvDataStoreFactory(ServiceProvider svProv) {
        this.svProv = svProv;
    }

    public RiwaSrvDataStoreFactory() {
        this(null);
    }

    public boolean canProcess(Map<String, ?> params) {
        if (params != null) {
            for (DataAccessFactory.Param arrayParameter : arrayParameters) {
                Object value = params.get(arrayParameter.key);
                if (value != null && arrayParameter.type.isInstance(value) || !arrayParameter.required) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Failed on : " + arrayParameter.key + ", full params= " + params.toString());
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        String strModule = (String)MODULE.lookUp(params);
        String strStructure = (String)STRUCTURE.lookUp(params);
        Boolean tiled = (Boolean)TILED.lookUp(params);
        try {
            if (ServiceProviderSingleton.isAvailable()) {
                this.svProv = ServiceProviderSingleton.getServiceProvider();
            }
            if (this.svProv == null) {
                throw new Exception("No service provider found in module application.");
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        if (BooleanUtils.isTrue((Boolean)tiled)) {
            String cacheDirectoryPath = (String)TILE_CACHE_DIRECTORY_PATH.lookUp(params);
            cacheDirectoryPath = StringUtils.defaultIfEmpty((String)cacheDirectoryPath, (String)FileUtils.getTempDirectoryPath());
            return new TiledRiwaSrvDataStore(this.svProv, Integer.parseInt(strModule), Integer.parseInt(strStructure), cacheDirectoryPath);
        }
        return new RiwaSrvDataStore(this.svProv, Integer.parseInt(strModule), Integer.parseInt(strStructure));
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        throw new UnsupportedOperationException("RiwaGIS Service cannot create a new Datastore");
    }

    public String getDisplayName() {
        return "RiwaGIS Service";
    }

    public String getDescription() {
        return "RiwaGIS Service DataStore";
    }

    public boolean isAvailable() {
        if (!ServiceProviderSingleton.isAvailable()) {
            LOG.warn("RiwaSrv ({}) data sources are not available. Maybe GisContext is not initialized.", (Object)this.getDisplayName());
            return false;
        }
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return Arrays.copyOf(arrayParameters, arrayParameters.length);
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

