/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv;

import de.riwagis.geotools.EditableStore;
import de.riwagis.geotools.data.riwasrv.FeatureStreamProcessor;
import de.riwagis.geotools.data.riwasrv.RiwaSrvFeatureStore;
import de.riwagis.service.MethodMData;
import de.riwagis.service.ParameterMData;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceProvider;
import de.riwagis.service.ServiceRequest;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.geotools.data.Query;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiwaSrvDataStore
extends ContentDataStore
implements EditableStore {
    private static final Logger LOG = LoggerFactory.getLogger(RiwaSrvDataStore.class);
    public static final FeatureStreamProcessor FSP = new FeatureStreamProcessor();
    private static final String PARAM_EDITABLE = "editable";
    private static final String PARAM_MODULE_KEY = "module_key";
    private static final String PARAM_STRUCTURE_KEY = "structure_key";
    private static final ParameterMData pModKey = new ParameterMData("module_key", Integer.class);
    private static final ParameterMData pStructKey = new ParameterMData("structure_key", Integer.class);
    private static final ParameterMData pTypeName = new ParameterMData("type_name", String.class);
    private static final ParameterMData pFilter = new ParameterMData("filter", String.class);
    private static final ParameterMData pBinaryFilter = new ParameterMData("binary_filter", InputStream.class);
    private static final ParameterMData pFeatures = new ParameterMData("features", InputStream.class);
    private static final ParameterMData pOperation = new ParameterMData("operation", Integer.class);
    private static final MethodMData methGetFeatureType = new MethodMData("get_feature_type", new ParameterMData[]{pModKey, pStructKey, pTypeName}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_STREAM);
    private static final MethodMData methGetTypeNames = new MethodMData("get_type_names", new ParameterMData[]{pModKey, pStructKey}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_OBJECT);
    private static final MethodMData methGetFeatureReader = new MethodMData("get_feature_reader", new ParameterMData[]{pModKey, pStructKey, pTypeName, pFilter, pBinaryFilter}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_STREAM);
    private static final MethodMData methEditData = new MethodMData("edit_features", new ParameterMData[]{pModKey, pStructKey, pOperation, pFeatures}, MethodMData.MethodHTTPType.HTTP_MULTIPART_REQUEST, MethodMData.MethodResponseType.RETURN_OBJECT);
    private static final MethodMData methIsReadonly = new MethodMData("is_readonly", new ParameterMData[]{pModKey, pStructKey}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_OBJECT);
    private static final MethodMData methGetCount = new MethodMData("get_count", new ParameterMData[]{pModKey, pStructKey, pTypeName, pFilter, pBinaryFilter}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_OBJECT);
    private static final MethodMData methGetMetaData = new MethodMData("get_metadata", new ParameterMData[]{pModKey, pStructKey}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_OBJECT);
    private static final MethodMData methGetMetaDataAll = new MethodMData("get_metadata_all", new ParameterMData[0], MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_OBJECT);
    private static final MethodMData methGetBounds = new MethodMData("get_bounds", new ParameterMData[]{pModKey, pStructKey, pTypeName, pFilter, pBinaryFilter}, MethodMData.MethodHTTPType.HTTP_POST_REQUEST, MethodMData.MethodResponseType.RETURN_OBJECT);
    public static final ServiceMData featureService = new ServiceMData("feature", 0, new MethodMData[]{methGetFeatureType, methGetTypeNames, methGetFeatureReader, methEditData, methIsReadonly, methGetCount, methGetMetaData, methGetMetaDataAll, methGetBounds});
    private final ServiceProvider svProv;
    private final int moduleKey;
    private final int structureKey;
    private String[] arrTypeNames = null;
    private Map<?, ?> mapMeta = null;
    private static Map<?, ?> mapMetaAll = null;
    private static final Lock lockMapMeta = new ReentrantLock();
    private static final ActionListener logoutListener = e -> RiwaSrvDataStore.clearMetaDataCache();
    protected final Lock dataStoreLock = new ReentrantLock();
    protected final Map<ContentEntry, ContentFeatureSource> cachedFeatureSources = new HashMap<ContentEntry, ContentFeatureSource>();

    public RiwaSrvDataStore(ServiceProvider svProv, int moduleKey, int structureKey) throws IOException {
        try {
            this.svProv = svProv;
            this.moduleKey = moduleKey;
            this.structureKey = structureKey;
            this.fillMapMeta();
        }
        catch (Exception e) {
            LOG.error("error RiwaSrvDataStore constructor", (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
    }

    public static final void clearMetaDataCache() {
        lockMapMeta.lock();
        try {
            mapMetaAll = null;
        }
        finally {
            lockMapMeta.unlock();
        }
    }

    private void fillMapMeta() throws Exception {
        try {
            lockMapMeta.lock();
            try {
                if (mapMetaAll == null) {
                    HashMap params = new HashMap();
                    ServiceRequest req = featureService.createRequest("get_metadata_all", params);
                    mapMetaAll = (Map)this.svProv.execRequest(req).getResult();
                    this.svProv.addLogoutListener(logoutListener);
                }
            }
            finally {
                lockMapMeta.unlock();
            }
            String strKey = this.moduleKey + "_" + this.structureKey;
            Boolean bolEditable = (Boolean)mapMetaAll.get(strKey);
            HashMap oMapMeta = new HashMap();
            oMapMeta.put(PARAM_EDITABLE, bolEditable);
            this.mapMeta = oMapMeta;
        }
        catch (Exception e) {
            LOG.error("Error fill mapMetaAll - maybe server version is too old. Trying to request mapMeta directly.", (Throwable)e);
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put(PARAM_MODULE_KEY, this.moduleKey);
            params.put(PARAM_STRUCTURE_KEY, this.structureKey);
            ServiceRequest req = featureService.createRequest("get_metadata", params);
            this.mapMeta = (Map)this.svProv.execRequest(req).getResult();
        }
    }

    public int getFeatureCount(Query query) throws IOException {
        return this.getFeatureSource(query.getTypeName()).getCount(query);
    }

    @Override
    public boolean isEditable() {
        if (!this.mapMeta.containsKey(PARAM_EDITABLE)) {
            return false;
        }
        return (Boolean)this.mapMeta.get(PARAM_EDITABLE);
    }

    protected List<Name> createTypeNames() throws IOException {
        ArrayList<NameImpl> lstNames = new ArrayList<NameImpl>();
        try {
            if (this.arrTypeNames == null) {
                HashMap params = new HashMap();
                params.put(PARAM_MODULE_KEY, this.moduleKey);
                params.put(PARAM_STRUCTURE_KEY, this.structureKey);
                ServiceRequest req = featureService.createRequest("get_type_names", (Map)params);
                this.arrTypeNames = (String[])this.svProv.execRequest(req).getResult();
            }
            for (String typeName : this.arrTypeNames) {
                lstNames.add(new NameImpl(typeName));
            }
        }
        catch (Exception e) {
            LOG.error("Error getting typeNames", (Throwable)e);
            lstNames.add(new NameImpl("error"));
        }
        return Collections.unmodifiableList(lstNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        try {
            this.dataStoreLock.lock();
            if (this.cachedFeatureSources.containsKey(entry)) {
                ContentFeatureSource contentFeatureSource = this.cachedFeatureSources.get(entry);
                return contentFeatureSource;
            }
            RiwaSrvFeatureStore featureSource = new RiwaSrvFeatureStore(entry, Query.ALL);
            this.cachedFeatureSources.put(entry, (ContentFeatureSource)featureSource);
            RiwaSrvFeatureStore riwaSrvFeatureStore = featureSource;
            return riwaSrvFeatureStore;
        }
        finally {
            this.dataStoreLock.unlock();
        }
    }

    public int getModuleKey() {
        return this.moduleKey;
    }

    public int getStructureKey() {
        return this.structureKey;
    }

    public ServiceProvider getServiceProvider() {
        return this.svProv;
    }

    public ServiceMData getFeatureService() {
        return featureService;
    }
}

