/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwasrv;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.geotools.gml.producer.GeometryTransformer;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FilterTransformer
extends TransformerBase {
    private static final String defaultNamespace = "http://www.opengis.net/ogc";
    private static final Map comparisions = new HashMap();
    private static final Map spatial = new HashMap();
    private static final Map logical = new HashMap();
    private static final Map expressions = new HashMap();

    public Translator createTranslator(ContentHandler handler) {
        return new FilterTranslator(handler);
    }

    static {
        comparisions.put(14, "PropertyIsEqualTo");
        comparisions.put(23, "PropertyIsNotEqualTo");
        comparisions.put(16, "PropertyIsGreaterThan");
        comparisions.put(18, "PropertyIsGreaterThanOrEqualTo");
        comparisions.put(15, "PropertyIsLessThan");
        comparisions.put(17, "PropertyIsLessThanOrEqualTo");
        comparisions.put(20, "PropertyIsLike");
        comparisions.put(21, "PropertyIsNull");
        comparisions.put(19, "PropertyIsBetween");
        expressions.put(105, "Add");
        expressions.put(108, "Div");
        expressions.put(107, "Mul");
        expressions.put(106, "Sub");
        expressions.put(114, "Function");
        spatial.put(5, "Equals");
        spatial.put(6, "Disjoint");
        spatial.put(7, "Intersects");
        spatial.put(8, "Touches");
        spatial.put(9, "Crosses");
        spatial.put(10, "Within");
        spatial.put(11, "Contains");
        spatial.put(12, "Overlaps");
        spatial.put(13, "Beyond");
        spatial.put(4, "BBOX");
        logical.put(2, "And");
        logical.put(1, "Or");
        logical.put(3, "Not");
    }

    public static class FilterTranslator
    extends TransformerBase.TranslatorSupport
    implements FilterVisitor,
    ExpressionVisitor {
        GeometryTransformer.GeometryTranslator geometryEncoder;

        public FilterTranslator(ContentHandler handler) {
            super(handler, "ogc", FilterTransformer.defaultNamespace);
            this.geometryEncoder = new GeometryTransformer.GeometryTranslator(handler);
            this.addNamespaceDeclarations((TransformerBase.TranslatorSupport)this.geometryEncoder);
        }

        public void visit(Filter filter) {
            try {
                this.contentHandler.startElement("", "!--", "!--", this.NULL_ATTS);
                this.chars("Unidentified Filter " + filter.getClass());
                this.contentHandler.endElement("", "--", "--");
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public void visit(Expression expression) {
        }

        public void encode(Expression e) {
            e.accept((ExpressionVisitor)this, null);
        }

        public void encode(Filter f) {
            this.start("Filter");
            f.accept((FilterVisitor)this, null);
            this.end("Filter");
        }

        public void encode(Object o) {
            if (o instanceof Filter) {
                this.encode((Filter)o);
            } else if (o instanceof Expression) {
                this.encode((Expression)o);
            } else {
                throw new IllegalArgumentException("Cannot encode " + (o == null ? "null" : o.getClass().getName()));
            }
        }

        public Object visitNullFilter(Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(ExcludeFilter filter, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(IncludeFilter filter, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private void visitLogicFilter(BinaryLogicOperator filter, short filterType, Object extraData) {
            String type = (String)logical.get(new Integer(filterType));
            this.start(type);
            for (Filter child : filter.getChildren()) {
                child.accept((FilterVisitor)this, extraData);
            }
            this.end(type);
        }

        public Object visit(And filter, Object extraData) {
            this.visitLogicFilter((BinaryLogicOperator)filter, (short)2, extraData);
            return null;
        }

        public Object visit(Id filter, Object extraData) {
            for (Object id : filter.getIDs()) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "fid", "fid", "", Objects.toString(id, null));
                this.element("FeatureId", null, atts);
            }
            return null;
        }

        public Object visit(Not filter, Object extraData) {
            String type = (String)logical.get(new Integer(3));
            this.start(type);
            filter.getFilter().accept((FilterVisitor)this, extraData);
            this.end(type);
            return null;
        }

        public Object visit(Or filter, Object extraData) {
            this.visitLogicFilter((BinaryLogicOperator)filter, (short)1, extraData);
            return null;
        }

        public Object visit(PropertyIsBetween filter, Object extraData) {
            Expression left = filter.getLowerBoundary();
            Expression right = filter.getUpperBoundary();
            Expression mid = filter.getExpression();
            String type = (String)comparisions.get(new Integer(19));
            this.start(type);
            mid.accept((ExpressionVisitor)this, extraData);
            this.start("LowerBoundary");
            left.accept((ExpressionVisitor)this, extraData);
            this.end("LowerBoundary");
            this.start("UpperBoundary");
            right.accept((ExpressionVisitor)this, extraData);
            this.end("UpperBoundary");
            this.end(type);
            return null;
        }

        private void visitCompareFilter(BinaryComparisonOperator filter, short filterType, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = (String)comparisions.get(new Integer(filterType));
            this.start(type);
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end(type);
        }

        public Object visit(PropertyIsEqualTo filter, Object extraData) {
            this.visitCompareFilter((BinaryComparisonOperator)filter, (short)14, extraData);
            return null;
        }

        public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
            this.visitCompareFilter((BinaryComparisonOperator)filter, (short)23, extraData);
            return null;
        }

        public Object visit(PropertyIsGreaterThan filter, Object extraData) {
            this.visitCompareFilter((BinaryComparisonOperator)filter, (short)16, extraData);
            return null;
        }

        public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
            this.visitCompareFilter((BinaryComparisonOperator)filter, (short)18, extraData);
            return null;
        }

        public Object visit(PropertyIsLessThan filter, Object extraData) {
            this.visitCompareFilter((BinaryComparisonOperator)filter, (short)15, extraData);
            return null;
        }

        public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
            this.visitCompareFilter((BinaryComparisonOperator)filter, (short)17, extraData);
            return null;
        }

        public Object visit(PropertyIsLike filter, Object extraData) {
            String wcm = filter.getWildCard();
            String wcs = filter.getSingleChar();
            String esc = filter.getEscape();
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "wildCard", "wildCard", "", wcm);
            atts.addAttribute("", "singleChar", "singleChar", "", wcs);
            atts.addAttribute("", "escape", "escape", "", esc);
            this.start("PropertyIsLike", atts);
            this.encode((Filter)filter);
            this.element("Literal", filter.getLiteral());
            this.end("PropertyIsLike");
            return null;
        }

        public Object visit(PropertyIsNull filter, Object extraData) {
            Expression expr = filter.getExpression();
            String type = (String)comparisions.get(new Integer(21));
            this.start(type);
            expr.accept((ExpressionVisitor)this, extraData);
            this.end(type);
            return null;
        }

        public Object visit(PropertyIsNil filter, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private void visitSpatialFilter(BinarySpatialOperator filter, short filterType, Object extraData) {
            Expression left = filter.getExpression1();
            Expression right = filter.getExpression2();
            String type = (String)spatial.get(new Integer(filterType));
            this.start(type);
            left.accept((ExpressionVisitor)this, extraData);
            right.accept((ExpressionVisitor)this, extraData);
            this.end(type);
        }

        public Object visit(BBOX filter, Object extraData) {
            this.visitSpatialFilter((BinarySpatialOperator)filter, (short)4, extraData);
            return null;
        }

        public Object visit(Beyond filter, Object extraData) {
            this.visitSpatialFilter((BinarySpatialOperator)filter, (short)13, extraData);
            return null;
        }

        public Object visit(Contains filter, Object extraData) {
            this.visitSpatialFilter((BinarySpatialOperator)filter, (short)11, extraData);
            return null;
        }

        public Object visit(Crosses filter, Object extraData) {
            this.visitSpatialFilter((BinarySpatialOperator)filter, (short)9, extraData);
            return null;
        }

        public Object visit(Disjoint filter, Object extraData) {
            this.visitSpatialFilter((BinarySpatialOperator)filter, (short)6, extraData);
            return null;
        }

        public Object visit(DWithin filter, Object extraData) {
            this.visitSpatialFilter((BinarySpatialOperator)filter, (short)24, extraData);
            return null;
        }

        public Object visit(Equals filter, Object extraData) {
            this.visitSpatialFilter((BinarySpatialOperator)filter, (short)5, extraData);
            return null;
        }

        public Object visit(Intersects filter, Object extraData) {
            this.visitSpatialFilter((BinarySpatialOperator)filter, (short)7, extraData);
            return null;
        }

        public Object visit(Overlaps filter, Object extraData) {
            this.visitSpatialFilter((BinarySpatialOperator)filter, (short)12, extraData);
            return null;
        }

        public Object visit(Touches filter, Object extraData) {
            this.visitSpatialFilter((BinarySpatialOperator)filter, (short)8, extraData);
            return null;
        }

        public Object visit(Within filter, Object extraData) {
            this.visitSpatialFilter((BinarySpatialOperator)filter, (short)10, extraData);
            return null;
        }

        public Object visit(After after, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(AnyInteracts anyInteracts, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(Before before, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(Begins begins, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(BegunBy begunBy, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(During during, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(EndedBy endedBy, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(Ends ends, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(Meets meets, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(MetBy metBy, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(OverlappedBy overlappedBy, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(TContains contains, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(TEquals equals, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(TOverlaps contains, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(NilExpression expression, Object extraData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object visit(Add expression, Object extraData) {
            this.visitMathExpression((BinaryExpression)expression, (short)105, extraData);
            return null;
        }

        private void visitMathExpression(BinaryExpression expression, short expressionType, Object extraData) {
            String type = (String)expressions.get(new Integer(expressionType));
            this.start(type);
            this.encode(expression.getExpression1());
            this.encode(expression.getExpression2());
            this.end(type);
        }

        public Object visit(Divide expression, Object extraData) {
            this.visitMathExpression((BinaryExpression)expression, (short)108, extraData);
            return null;
        }

        public Object visit(Function expression, Object extraData) {
            String type = (String)expressions.get(new Integer(114));
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", expression.getName());
            this.start(type, atts);
            for (Expression param : expression.getParameters()) {
                param.accept((ExpressionVisitor)this, extraData);
            }
            this.end(type);
            return null;
        }

        public Object visit(Literal expression, Object extraData) {
            Object value = expression.getValue();
            if (Geometry.class.isAssignableFrom(value.getClass())) {
                this.geometryEncoder.encode((Geometry)value);
            } else {
                this.element("Literal", value.toString());
            }
            return null;
        }

        public Object visit(Multiply expression, Object extraData) {
            this.visitMathExpression((BinaryExpression)expression, (short)107, extraData);
            return null;
        }

        public Object visit(PropertyName expression, Object extraData) {
            this.element("PropertyName", expression.getPropertyName());
            return null;
        }

        public Object visit(Subtract expression, Object extraData) {
            this.visitMathExpression((BinaryExpression)expression, (short)106, extraData);
            return null;
        }
    }
}

