/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwadatatable;

import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwadatatable.filter.DataTableFilterUtil;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.geotools.FeatureDbTable;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.i18n.I18N;
import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RiwaDataTableFeatureStore
extends ContentFeatureStore {
    private static final Logger LOG = LoggerFactory.getLogger(RiwaDataTableFeatureStore.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.geotools.data.i18n.i18n");
    private final FeatureDbTable dbt;

    public RiwaDataTableFeatureStore(ContentEntry entry, FeatureDbTable dbt) {
        super(entry, Query.ALL);
        this.dbt = dbt;
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(final Query query, int flags) throws IOException {
        if ((flags & 1) == 1 && !this.dbt.getInsertable()) {
            throw new IOException("insufficient rights: datatable is not insertable");
        }
        if ((flags & 2) == 2 && !this.dbt.getUpdateable() && !this.dbt.getDeleteable()) {
            throw new IOException("insufficient rights: datatable is not updateable or deleteable");
        }
        Object writer = flags == 1 ? new SimpleFeatureWriter(){
            private SimpleFeature current;
            private boolean closed = false;

            public SimpleFeatureType getFeatureType() {
                return RiwaDataTableFeatureStore.this.getSchema();
            }

            public SimpleFeature next() throws IOException {
                if (this.closed) {
                    throw new IOException(i18n.get("geotools.data.riwasrv.fw-closed"));
                }
                this.current = FeatureUtil.createFeature((SimpleFeatureType)this.getFeatureType());
                return this.current;
            }

            public void remove() throws IOException {
                throw new UnsupportedOperationException("remove is not supported.");
            }

            public void write() throws IOException {
                if (this.closed) {
                    throw new IOException(i18n.get("geotools.data.riwasrv.fw-closed"));
                }
                if (this.current == null) {
                    throw new IOException(i18n.get("geotools.data.riwasrv.no-feature-available-to-write"));
                }
                try {
                    String newFID = RiwaDataTableFeatureStore.this.dbt.insertFeature(this.current);
                    if (this.current instanceof SimpleFeatureImpl) {
                        FeatureUtil.setAttribute((SimpleFeature)this.current, (String)RiwaDataTableFeatureStore.this.dbt.getIDColumn().getColumnName(), (Object)newFID);
                    }
                    if (this.current.getIdentifier() instanceof FeatureIdImpl) {
                        ((FeatureIdImpl)this.current.getIdentifier()).setID(newFID);
                    }
                    RiwaDataTableFeatureStore.this.getState().fireFeatureAdded((FeatureSource)RiwaDataTableFeatureStore.this, (Feature)this.current);
                }
                catch (Exception e) {
                    throw new IOException(i18n.fmt("geotools.data.riwasrv.error-insert", new Object[]{e.getMessage()}), e);
                }
                this.current = null;
            }

            public boolean hasNext() throws IOException {
                if (this.closed) {
                    throw new IOException(i18n.get("geotools.data.riwasrv.fw-closed"));
                }
                return false;
            }

            public void close() throws IOException {
                this.current = null;
                this.closed = true;
            }
        } : new SimpleFeatureWriter(){
            private SimpleFeature live;
            private SimpleFeature current;
            private boolean closed = false;
            private FeatureReader<SimpleFeatureType, SimpleFeature> reader = RiwaDataTableFeatureStore.this.getReaderInternal(query);

            public SimpleFeatureType getFeatureType() {
                return RiwaDataTableFeatureStore.this.getSchema();
            }

            public SimpleFeature next() throws IOException {
                if (this.closed) {
                    throw new IOException(i18n.get("geotools.data.riwasrv.fw-closed"));
                }
                if (this.reader.hasNext()) {
                    this.live = (SimpleFeature)this.reader.next();
                    this.current = SimpleFeatureBuilder.copy((SimpleFeature)this.live);
                } else {
                    this.live = null;
                    this.current = FeatureUtil.createFeature((SimpleFeatureType)this.getFeatureType());
                }
                return this.current;
            }

            public void remove() throws IOException {
                if (this.closed) {
                    throw new IOException(i18n.get("geotools.data.riwasrv.fw-closed"));
                }
                if (this.current == null) {
                    throw new IOException(i18n.get("geotools.data.riwasrv.no-feature-available-to-remove"));
                }
                if (this.live != null) {
                    try {
                        RiwaDataTableFeatureStore.this.dbt.deleteFeature(this.live);
                        RiwaDataTableFeatureStore.this.getState().fireFeatureRemoved((FeatureSource)RiwaDataTableFeatureStore.this, (Feature)this.current);
                    }
                    catch (SystemException ex) {
                        throw new IOException("error deleting feature", ex);
                    }
                    this.live = null;
                    this.current = null;
                } else {
                    this.current = null;
                }
            }

            public void write() throws IOException {
                Geometry geomCand;
                Geometry geomLive;
                if (this.closed) {
                    throw new IOException(i18n.get("geotools.data.riwasrv.fw-closed"));
                }
                if (this.current == null) {
                    throw new IOException(i18n.get("geotools.data.riwasrv.no-feature-available-to-write"));
                }
                boolean featureEqualsBug = false;
                if (this.live != null && (geomLive = (Geometry)this.live.getDefaultGeometry()) != (geomCand = (Geometry)this.current.getDefaultGeometry()) && geomLive != null && geomCand != null && (geomLive.getClass().equals(GeometryCollection.class) || geomCand.getClass().equals(GeometryCollection.class))) {
                    featureEqualsBug = true;
                }
                if (this.live != null) {
                    if (!featureEqualsBug && this.live.equals(this.current)) {
                        this.live = null;
                        this.current = null;
                    } else {
                        try {
                            RiwaDataTableFeatureStore.this.dbt.updateFeature(this.current);
                            RiwaDataTableFeatureStore.this.getState().fireFeatureUpdated((FeatureSource)RiwaDataTableFeatureStore.this, (Feature)this.current, new ReferencedEnvelope(this.live.getBounds()));
                        }
                        catch (Exception e) {
                            throw new IOException(i18n.fmt("geotools.data.riwasrv.error-update", new Object[]{e.getMessage()}), e);
                        }
                        this.live = null;
                        this.current = null;
                    }
                } else {
                    try {
                        String newFID = RiwaDataTableFeatureStore.this.dbt.insertFeature(this.current);
                        if (this.current instanceof SimpleFeatureImpl) {
                            FeatureUtil.setAttribute((SimpleFeature)this.current, (String)RiwaDataTableFeatureStore.this.dbt.getIDColumn().getColumnName(), (Object)newFID);
                        }
                        if (this.current.getIdentifier() instanceof FeatureIdImpl) {
                            ((FeatureIdImpl)this.current.getIdentifier()).setID(newFID);
                        }
                        RiwaDataTableFeatureStore.this.getState().fireFeatureAdded((FeatureSource)RiwaDataTableFeatureStore.this, (Feature)this.current);
                    }
                    catch (Exception e) {
                        throw new IOException(i18n.fmt("geotools.data.riwasrv.error-insert", new Object[]{e.getMessage()}), e);
                    }
                    this.current = null;
                }
            }

            public boolean hasNext() throws IOException {
                if (this.closed) {
                    throw new IOException(i18n.get("geotools.data.riwasrv.fw-closed"));
                }
                return this.reader.hasNext();
            }

            public void close() throws IOException {
                this.reader.close();
                this.reader = null;
                this.live = null;
                this.current = null;
                this.closed = true;
            }
        };
        return writer;
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        try {
            return this.dbt.getBounds(DataTableFilterUtil.convertQuery((DbTable)this.dbt, (Query)query));
        }
        catch (SystemException ex) {
            throw new IOException(ex);
        }
    }

    protected int getCountInternal(Query query) throws IOException {
        try {
            return this.dbt.getCount(DataTableFilterUtil.convertQuery((DbTable)this.dbt, (Query)query));
        }
        catch (SystemException ex) {
            throw new IOException(ex);
        }
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        try {
            String[] propertyNames = query.getPropertyNames();
            if (propertyNames == Query.ALL_NAMES) {
                return this.dbt.getFeatureReader(DataTableFilterUtil.convertQuery((DbTable)this.dbt, (Query)query));
            }
            return this.dbt.getFeatureReader(DataTableFilterUtil.convertQuery((DbTable)this.dbt, (Query)query), propertyNames);
        }
        catch (SystemException ex) {
            throw new IOException(ex);
        }
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureType fTypeAll = this.dbt.getFeatureType();
        return fTypeAll;
    }

    protected boolean canFilter() {
        return true;
    }

    protected boolean canRetype() {
        return true;
    }

    protected boolean canEvent() {
        return true;
    }

    protected boolean canLimit() {
        return true;
    }

    protected boolean canSort() {
        return true;
    }

    protected boolean canTransact() {
        return true;
    }

    protected QueryCapabilities buildQueryCapabilities() {
        return new QueryCapabilities(){

            public boolean isUseProvidedFIDSupported() {
                return true;
            }
        };
    }
}

