/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwadatatable;

import de.riwagis.riwadatatable.filter.DataTableFilterUtil;
import de.riwagis.riwadatatable.table.DbTable;
import de.riwagis.riwadatatable.table.geotools.FeatureDbTable;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.i18n.I18N;
import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RiwaDataTableFeatureSource
extends ContentFeatureSource {
    private static final Logger LOG = LoggerFactory.getLogger(RiwaDataTableFeatureSource.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.geotools.data.i18n.i18n");
    private final FeatureDbTable dbt;

    public RiwaDataTableFeatureSource(ContentEntry entry, FeatureDbTable dbt) {
        super(entry, Query.ALL);
        this.dbt = dbt;
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        try {
            return this.dbt.getBounds(DataTableFilterUtil.convertQuery((DbTable)this.dbt, (Query)query));
        }
        catch (SystemException ex) {
            throw new IOException(ex);
        }
    }

    protected int getCountInternal(Query query) throws IOException {
        try {
            return this.dbt.getCount(DataTableFilterUtil.convertQuery((DbTable)this.dbt, (Query)query));
        }
        catch (SystemException ex) {
            throw new IOException(ex);
        }
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        try {
            String[] propertyNames = query.getPropertyNames();
            if (propertyNames == Query.ALL_NAMES) {
                return this.dbt.getFeatureReader(DataTableFilterUtil.convertQuery((DbTable)this.dbt, (Query)query));
            }
            return this.dbt.getFeatureReader(DataTableFilterUtil.convertQuery((DbTable)this.dbt, (Query)query), propertyNames);
        }
        catch (SystemException ex) {
            throw new IOException(ex);
        }
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureType fTypeAll = this.dbt.getFeatureType();
        return fTypeAll;
    }

    protected boolean canFilter() {
        return true;
    }

    protected boolean canRetype() {
        return true;
    }

    protected boolean canLimit() {
        return true;
    }

    protected boolean canSort() {
        return true;
    }

    protected boolean canTransact() {
        return true;
    }

    protected QueryCapabilities buildQueryCapabilities() {
        return new QueryCapabilities(){

            public boolean isUseProvidedFIDSupported() {
                return true;
            }
        };
    }
}

