/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.riwadatatable;

import de.riwagis.geotools.data.riwadatatable.RiwaDataTableDataStore;
import de.riwagis.riwadatatable.columns.OracleGeometryColumn;
import de.riwagis.riwadatatable.jdbc.DBType;
import de.riwagis.riwadatatable.jdbc.DataSourceConnectionManager;
import de.riwagis.riwadatatable.jdbc.DefaultConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfo;
import de.riwagis.riwadatatable.table.userinfo.DbTableUserInfoSystem;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jdbc.pool.DBDriver;
import java.awt.RenderingHints;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.util.SimpleInternationalString;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.util.InternationalString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiwaDataTableDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger log = LoggerFactory.getLogger(RiwaDataTableDataStoreFactory.class);
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)DBType.MySQL.getTypeIdentifier());
    public static final DataAccessFactory.Param HOST = new DataAccessFactory.Param("host", String.class, "Host", true, (Object)"localhost");
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true);
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", String.class, "Database", false);
    public static final DataAccessFactory.Param SCHEMA = new DataAccessFactory.Param("schema", String.class, "Schema", false);
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param("user", String.class, "user name to login as");
    public static final DataAccessFactory.Param PASSWD = new DataAccessFactory.Param("passwd", String.class, (InternationalString)new SimpleInternationalString("password used to login"), false, null, Collections.singletonMap("isPassword", Boolean.TRUE));
    public static final DataAccessFactory.Param DATASOURCE = new DataAccessFactory.Param("Data Source", DataSource.class, "Data Source", false);
    public static final DataAccessFactory.Param USER_INFO = new DataAccessFactory.Param("User Info", DbTableUserInfo.class, "User Info", false);
    public static final DataAccessFactory.Param DATA_DICTIONARY = new DataAccessFactory.Param("Data dictionary", List.class, "Data dictionary", false);
    public static final DataAccessFactory.Param MAXCONN = new DataAccessFactory.Param("max connections", Integer.class, "maximum number of open connections", false, (Object)10);
    public static final DataAccessFactory.Param MINCONN = new DataAccessFactory.Param("min connections", Integer.class, "minimum number of pooled connection", false, (Object)1);
    public static final DataAccessFactory.Param VALIDATECONN = new DataAccessFactory.Param("validate connections", Boolean.class, "check connection is alive before using it", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param LOWERCASE_WHEN_ORACLE = new DataAccessFactory.Param("lowercase_when_oracle", Boolean.class, "Return lowercase type and attribute names when using oracle database", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param MAXWAIT = new DataAccessFactory.Param("Connection timeout", Integer.class, "number of seconds the connection pool will wait before timing out attempting to get a new connection (default, 20 seconds)", false, (Object)20);
    public static final DataAccessFactory.Param TEST_WHILE_IDLE = new DataAccessFactory.Param("Test while idle", Boolean.class, "Periodically test the connections are still valid also while idle in the pool", false, (Object)true);
    public static final DataAccessFactory.Param TIME_BETWEEN_EVICTOR_RUNS = new DataAccessFactory.Param("Evictor run periodicity", Integer.class, "number of seconds between idle object evitor runs (default, 300 seconds)", false, (Object)300);
    public static final DataAccessFactory.Param MIN_EVICTABLE_TIME = new DataAccessFactory.Param("Max connection idle time", Integer.class, "number of seconds a connection needs to stay idle for the evictor to consider closing it", false, (Object)300);
    public static final DataAccessFactory.Param EVICTOR_TESTS_PER_RUN = new DataAccessFactory.Param("Evictor tests per run", Integer.class, "number of connections checked by the idle connection evictor for each of its runs (defaults to 3)", false, (Object)3);
    public static final DataAccessFactory.Param USESSL_WHEN_MYSQL = new DataAccessFactory.Param("usessl_when_mysql", Boolean.class, "Use SSL for connection encryption (MySQL only)", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param SRID = new DataAccessFactory.Param("srid", Integer.class, "Spatial reference id of geometries accessed by this datastore", false, (Object)25832);

    public String getDisplayName() {
        return "RiwaDataTable";
    }

    public String getDescription() {
        return "DB Datastore - RIWA for accessing MySQL, Postgres, Oracle, MSSQLServer or MariaDB";
    }

    public boolean canProcess(Map<String, ?> params) {
        if (!DataUtilities.canProcess(params, (DataAccessFactory.Param[])this.getParametersInfo())) {
            return false;
        }
        return this.checkDBType(params);
    }

    protected boolean checkDBType(Map<String, ?> params) {
        try {
            DBType dBType = DBType.findByIdentifier((String)((String)DBTYPE.lookUp(params)));
            return EnumSet.of(DBType.MySQL, DBType.Oracle, DBType.Postgres, DBType.MSSQLServer).contains(dBType);
        }
        catch (IOException e) {
            return false;
        }
    }

    public final DataStore createDataStore(Map<String, ?> params) throws IOException {
        Boolean lowerCaseWhenOracle;
        RiwaDataTableDataStore dataStore = new RiwaDataTableDataStore();
        DataSource ds = (DataSource)DATASOURCE.lookUp(params);
        if (ds == null) {
            BasicDataSource dsCreated = (BasicDataSource)this.createDataSource(params);
            dataStore.setDataSource((DataSource)dsCreated);
            dataStore.onDisposeAction(() -> {
                try {
                    dsCreated.close();
                }
                catch (Throwable e) {
                    log.error("Could not dispose dataStore: " + e.getMessage(), e);
                }
            });
        } else {
            dataStore.setDataSource(ds);
        }
        DbTableUserInfo userInfo = (DbTableUserInfo)USER_INFO.lookUp(params);
        if (userInfo == null) {
            userInfo = new DbTableUserInfoSystem();
        }
        dataStore.setUserInfo(userInfo);
        List providedTypeNames = (List)DATA_DICTIONARY.lookUp(params);
        if (providedTypeNames != null) {
            dataStore.setDataDictionary(providedTypeNames);
        }
        if ((lowerCaseWhenOracle = (Boolean)LOWERCASE_WHEN_ORACLE.lookUp(params)) == null) {
            lowerCaseWhenOracle = false;
        }
        dataStore.setLowerCaseWhenOracle(lowerCaseWhenOracle);
        JDBCConnectionInfo connInfo = this.createConnectionInfo(dataStore.getDataSource(), params);
        DataSourceConnectionManager cm = new DataSourceConnectionManager(dataStore.getDataSource(), connInfo);
        dataStore.setConnectionManager((JDBCConnectionManager)cm);
        dataStore.setFilterFactory(CommonFactoryFinder.getFilterFactory(null));
        dataStore.setGeometryFactory(new GeometryFactory());
        dataStore.setFeatureTypeFactory((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        dataStore.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
        dataStore.setDataStoreFactory(this);
        if (dataStore.getDataSource() == null) {
            throw new IOException("JDBC Connection not available with provided parameters");
        }
        return dataStore;
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        throw new UnsupportedOperationException("can't create a new data store");
    }

    public final DataAccessFactory.Param[] getParametersInfo() {
        LinkedHashMap<String, DataAccessFactory.Param> map = new LinkedHashMap<String, DataAccessFactory.Param>();
        this.setupParameters(map);
        return map.values().toArray(new DataAccessFactory.Param[map.size()]);
    }

    protected void setupParameters(Map<String, DataAccessFactory.Param> parameters) {
        parameters.put(RiwaDataTableDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(RiwaDataTableDataStoreFactory.HOST.key, HOST);
        parameters.put(RiwaDataTableDataStoreFactory.PORT.key, PORT);
        parameters.put(RiwaDataTableDataStoreFactory.DATABASE.key, DATABASE);
        parameters.put(RiwaDataTableDataStoreFactory.SCHEMA.key, SCHEMA);
        parameters.put(RiwaDataTableDataStoreFactory.USER.key, USER);
        parameters.put(RiwaDataTableDataStoreFactory.PASSWD.key, PASSWD);
        parameters.put(RiwaDataTableDataStoreFactory.MAXCONN.key, MAXCONN);
        parameters.put(RiwaDataTableDataStoreFactory.MINCONN.key, MINCONN);
        parameters.put(RiwaDataTableDataStoreFactory.MAXWAIT.key, MAXWAIT);
        parameters.put(RiwaDataTableDataStoreFactory.VALIDATECONN.key, VALIDATECONN);
        parameters.put(RiwaDataTableDataStoreFactory.LOWERCASE_WHEN_ORACLE.key, LOWERCASE_WHEN_ORACLE);
        parameters.put(RiwaDataTableDataStoreFactory.TEST_WHILE_IDLE.key, TEST_WHILE_IDLE);
        parameters.put(RiwaDataTableDataStoreFactory.TIME_BETWEEN_EVICTOR_RUNS.key, TIME_BETWEEN_EVICTOR_RUNS);
        parameters.put(RiwaDataTableDataStoreFactory.MIN_EVICTABLE_TIME.key, MIN_EVICTABLE_TIME);
        parameters.put(RiwaDataTableDataStoreFactory.EVICTOR_TESTS_PER_RUN.key, EVICTOR_TESTS_PER_RUN);
        parameters.put(RiwaDataTableDataStoreFactory.USESSL_WHEN_MYSQL.key, USESSL_WHEN_MYSQL);
        parameters.put(RiwaDataTableDataStoreFactory.SRID.key, SRID);
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }

    public DataSource createDataSource(Map<String, ?> params) throws IOException {
        Integer evictorTestsPerRun;
        Integer minEvictableTime;
        Integer timeBetweenEvictorRuns;
        Boolean testWhileIdle;
        Boolean validate;
        Integer maxConn;
        Integer minConn;
        Integer maxWait;
        String schema;
        String passwd;
        BasicDataSource dataSource = new BasicDataSource();
        DBType dbType = DBType.findByIdentifier((String)((String)DBTYPE.lookUp(params)));
        dataSource.setDriverClassName(dbType.getDriverClassName());
        dataSource.setUrl(this.buildJDBCUrl(params));
        String user = (String)USER.lookUp(params);
        if (user != null) {
            dataSource.setUsername(user);
        }
        if ((passwd = (String)PASSWD.lookUp(params)) != null) {
            dataSource.setPassword(passwd);
        }
        if ((schema = (String)SCHEMA.lookUp(params)) != null) {
            dataSource.addConnectionProperty(RiwaDataTableDataStoreFactory.SCHEMA.key, schema);
        }
        if ((maxWait = (Integer)MAXWAIT.lookUp(params)) != null && maxWait != -1) {
            dataSource.setMaxWaitMillis((long)maxWait.intValue() * 1000L);
        }
        if ((minConn = (Integer)MINCONN.lookUp(params)) != null) {
            dataSource.setMinIdle(minConn.intValue());
        }
        if ((maxConn = (Integer)MAXCONN.lookUp(params)) != null) {
            dataSource.setMaxTotal(maxConn.intValue());
        }
        if ((validate = (Boolean)VALIDATECONN.lookUp(params)) != null && validate.booleanValue() && this.getValidationQuery(dbType) != null) {
            dataSource.setTestOnBorrow(true);
            dataSource.setValidationQuery(this.getValidationQuery(dbType));
        }
        if ((testWhileIdle = (Boolean)TEST_WHILE_IDLE.lookUp(params)) != null) {
            dataSource.setTestWhileIdle(testWhileIdle.booleanValue());
        }
        if ((timeBetweenEvictorRuns = (Integer)TIME_BETWEEN_EVICTOR_RUNS.lookUp(params)) != null && timeBetweenEvictorRuns > 0) {
            dataSource.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictorRuns.intValue() * 1000L);
        }
        if ((minEvictableTime = (Integer)MIN_EVICTABLE_TIME.lookUp(params)) != null) {
            dataSource.setMinEvictableIdleTimeMillis((long)minEvictableTime.intValue() * 1000L);
        }
        if ((evictorTestsPerRun = (Integer)EVICTOR_TESTS_PER_RUN.lookUp(params)) != null) {
            dataSource.setNumTestsPerEvictionRun(evictorTestsPerRun.intValue());
        }
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        DBDriver driver = dbType.getDBDriver();
        if (driver != DBDriver.Unknown) {
            Collection driverParameters = driver.getDriverParameters();
            driverParameters.forEach(param -> dataSource.addConnectionProperty(param.getName(), param.getValue()));
        }
        return dataSource;
    }

    private JDBCConnectionInfo createConnectionInfo(DataSource ds, Map<String, ?> params) throws IOException {
        DBType dbType = DBType.findByIdentifier((String)((String)DBTYPE.lookUp(params)));
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        String schema = (String)SCHEMA.lookUp(params);
        String catalog = (String)DATABASE.lookUp(params);
        int srid = -1;
        Object objSRID = SRID.lookUp(params);
        if (objSRID != null) {
            srid = ((Number)objSRID).intValue();
        }
        if (srid == -1 && dbType == DBType.Oracle) {
            try (Connection conn = ds.getConnection();){
                srid = OracleGeometryColumn.getSRIDbyDatabaseMetadata((Connection)conn);
            }
            catch (SystemException | SQLException ex) {
                throw new IOException(ex);
            }
        }
        return new DefaultConnectionInfo(dbType.getDriverClassName(), this.buildJDBCUrl(params), user, passwd, schema, srid, catalog);
    }

    public String buildJDBCUrl(Map<String, ?> params) throws IOException {
        String dbPart;
        String connPart;
        String hostPart = StringUtils.trimToEmpty((String)((String)HOST.lookUp(params)));
        Integer port = (Integer)PORT.lookUp(params);
        String db = StringUtils.trimToEmpty((String)((String)DATABASE.lookUp(params)));
        DBType currDBType = DBType.findByIdentifier((String)((String)DBTYPE.lookUp(params)));
        Boolean useSSL = (Boolean)USESSL_WHEN_MYSQL.lookUp(params);
        String prefix = StringUtils.trimToEmpty((String)currDBType.getUrlPrefix());
        Object portPart = port != null ? ":" + port : "";
        return String.format("%s%s%s%s%s%s", prefix, connPart, hostPart, portPart, dbPart, switch (currDBType) {
            case DBType.Oracle -> {
                connPart = "@";
                dbPart = StringUtils.isNotBlank((String)db) ? (db.startsWith("/") ? db : String.format(":%s", db)) : "";
                yield "";
            }
            case DBType.MSSQLServer -> {
                connPart = "//";
                dbPart = StringUtils.isNotBlank((String)db) ? String.format(";databaseName=%s", db) : "";
                yield "";
            }
            case DBType.MySQL -> {
                connPart = "//";
                dbPart = StringUtils.isNotBlank((String)db) ? String.format("/%s", db) : "";
                yield useSSL != null && useSSL == true ? "?useSSL=true" : "?useSSL=false";
            }
            default -> {
                connPart = "//";
                dbPart = StringUtils.isNotBlank((String)db) ? String.format("/%s", db) : "";
                yield "";
            }
        });
    }

    private String getValidationQuery(DBType dbType) {
        return switch (dbType) {
            case DBType.Oracle -> "select 1 from dual";
            case DBType.MSSQLServer, DBType.MySQL, DBType.Postgres -> "select 1";
            default -> null;
        };
    }
}

